/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTaskList;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update data", new Object[0]), "updatedata", I18n.tr("Updates the objects in the active data layer from the server.", new Object[0]), Shortcut.registerShortcut("file:updatedata", I18n.tr("File: {0}", I18n.tr("Update data", new Object[0])), 85, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/UpdateData"));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null && !Main.isOffline(OnlineResource.OSM_API));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        OsmDataLayer osmDataLayer = this.getLayerManager().getEditLayer();
        if (!this.isEnabled() || osmDataLayer == null) {
            return;
        }
        ArrayList<Area> arrayList = new ArrayList<Area>();
        for (DataSource dataSource : osmDataLayer.data.getDataSources()) {
            arrayList.add(new Area(dataSource.bounds.asRect()));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (n = arrayList.size() - 1; n > 0; --n) {
            for (int i = n - 1; i > 0; --i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        ArrayList<Area> arrayList2 = new ArrayList<Area>();
        for (Area object : arrayList) {
            if (object.isEmpty()) continue;
            arrayList2.add(object);
        }
        if (arrayList2.isEmpty()) {
            UpdateSelectionAction.updatePrimitives(osmDataLayer.data.allPrimitives());
        } else {
            PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Download data", new Object[0]));
            Future<?> future = new DownloadTaskList().download(false, (Collection<Area>)arrayList2, true, false, (ProgressMonitor)pleaseWaitProgressMonitor);
            UpdateDataAction.waitFuture(future, pleaseWaitProgressMonitor);
        }
    }
}

