/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Objects;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchSetting;

public class Filter
extends SearchSetting {
    private static final String version = "1";
    public boolean enable = true;
    public boolean hiding;
    public boolean inverted;

    public Filter() {
        this.mode = SearchMode.add;
    }

    public Filter(FilterPreferenceEntry filterPreferenceEntry) {
        this();
        this.text = filterPreferenceEntry.text;
        if ("replace".equals(filterPreferenceEntry.mode)) {
            this.mode = SearchMode.replace;
        } else if ("add".equals(filterPreferenceEntry.mode)) {
            this.mode = SearchMode.add;
        } else if ("remove".equals(filterPreferenceEntry.mode)) {
            this.mode = SearchMode.remove;
        } else if ("in_selection".equals(filterPreferenceEntry.mode)) {
            this.mode = SearchMode.in_selection;
        }
        this.caseSensitive = filterPreferenceEntry.case_sensitive;
        this.regexSearch = filterPreferenceEntry.regex_search;
        this.mapCSSSearch = filterPreferenceEntry.mapCSS_search;
        this.enable = filterPreferenceEntry.enable;
        this.hiding = filterPreferenceEntry.hiding;
        this.inverted = filterPreferenceEntry.inverted;
    }

    public FilterPreferenceEntry getPreferenceEntry() {
        FilterPreferenceEntry filterPreferenceEntry = new FilterPreferenceEntry();
        filterPreferenceEntry.version = version;
        filterPreferenceEntry.text = this.text;
        filterPreferenceEntry.mode = this.mode.toString();
        filterPreferenceEntry.case_sensitive = this.caseSensitive;
        filterPreferenceEntry.regex_search = this.regexSearch;
        filterPreferenceEntry.mapCSS_search = this.mapCSSSearch;
        filterPreferenceEntry.enable = this.enable;
        filterPreferenceEntry.hiding = this.hiding;
        filterPreferenceEntry.inverted = this.inverted;
        return filterPreferenceEntry;
    }

    public static class FilterPreferenceEntry {
        @Preferences.writeExplicitly
        @Preferences.pref
        public String version = "1";
        @Preferences.pref
        public String text;
        @Preferences.writeExplicitly
        @Preferences.pref
        public String mode = "add";
        @Preferences.pref
        public boolean case_sensitive;
        @Preferences.pref
        public boolean regex_search;
        @Preferences.pref
        public boolean mapCSS_search;
        @Preferences.writeExplicitly
        @Preferences.pref
        public boolean enable = true;
        @Preferences.writeExplicitly
        @Preferences.pref
        public boolean hiding;
        @Preferences.writeExplicitly
        @Preferences.pref
        public boolean inverted;

        public int hashCode() {
            return Objects.hash(this.case_sensitive, this.enable, this.hiding, this.inverted, this.mapCSS_search, this.mode, this.regex_search, this.text, this.version);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FilterPreferenceEntry filterPreferenceEntry = (FilterPreferenceEntry)object;
            return this.case_sensitive == filterPreferenceEntry.case_sensitive && this.enable == filterPreferenceEntry.enable && this.hiding == filterPreferenceEntry.hiding && this.inverted == filterPreferenceEntry.inverted && this.mapCSS_search == filterPreferenceEntry.mapCSS_search && this.regex_search == filterPreferenceEntry.regex_search && Objects.equals(this.mode, filterPreferenceEntry.mode) && Objects.equals(this.text, filterPreferenceEntry.text) && Objects.equals(this.version, filterPreferenceEntry.version);
        }
    }
}

