/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadReferrersAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class AbstractUploadTask
extends PleaseWaitRunnable {
    public AbstractUploadTask(String string, boolean bl) {
        super(string, bl);
    }

    public AbstractUploadTask(String string, ProgressMonitor progressMonitor, boolean bl) {
        super(string, progressMonitor, bl);
    }

    public AbstractUploadTask(String string) {
        super(string);
    }

    protected void synchronizePrimitive(OsmPrimitiveType osmPrimitiveType, long l) {
        OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
        if (osmDataLayer == null) {
            throw new IllegalStateException(I18n.tr("Failed to update primitive with id {0} because current edit layer is null", l));
        }
        OsmPrimitive osmPrimitive = osmDataLayer.data.getPrimitiveById(l, osmPrimitiveType);
        if (osmPrimitive == null) {
            throw new IllegalStateException(I18n.tr("Failed to update primitive with id {0} because current edit layer does not include such a primitive", l));
        }
        MainApplication.worker.execute(new UpdatePrimitivesTask(osmDataLayer, Collections.singleton(osmPrimitive)));
    }

    protected void synchronizeDataSet() {
        UpdateDataAction updateDataAction = new UpdateDataAction();
        updateDataAction.actionPerformed(new ActionEvent(this, 0, ""));
    }

    protected void handleUploadConflictForKnownConflict(OsmPrimitiveType osmPrimitiveType, long l, String string, String string2) {
        String string3;
        switch (osmPrimitiveType) {
            case NODE: {
                string3 = I18n.tr("Synchronize node {0} only", l);
                break;
            }
            case WAY: {
                string3 = I18n.tr("Synchronize way {0} only", l);
                break;
            }
            case RELATION: {
                string3 = I18n.tr("Synchronize relation {0} only", l);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(string3, ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset", new Object[0]), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), null, null)};
        String string4 = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br>The conflict is caused by the <strong>{0}</strong> with id <strong>{1}</strong>,<br>the server has version {2}, your version is {3}.<br><br>Click <strong>{4}</strong> to synchronize the conflicting primitive only.<br>Click <strong>{5}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{6}</strong> to abort and continue editing.<br></html>", I18n.tr(osmPrimitiveType.getAPIName(), new Object[0]), l, string, string2, buttonSpecArray[0].text, buttonSpecArray[1].text, buttonSpecArray[2].text);
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, string4, I18n.tr("Conflicts detected", new Object[0]), 0, null, buttonSpecArray, buttonSpecArray[0], "/Concepts/Conflict");
        switch (n) {
            case 0: {
                this.synchronizePrimitive(osmPrimitiveType, l);
                break;
            }
            case 1: {
                this.synchronizeDataSet();
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void handleUploadConflictForUnknownConflict() {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset", new Object[0]), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), null, null)};
        String string = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br><br>Click <strong>{0}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{1}</strong> to abort and continue editing.<br></html>", buttonSpecArray[0].text, buttonSpecArray[1].text);
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Conflicts detected", new Object[0]), 0, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Concepts/Conflict"));
        if (n == 0) {
            this.synchronizeDataSet();
        }
    }

    protected void handleUploadConflictForClosedChangeset(long l, Date date) {
        String string = I18n.tr("<html>Uploading <strong>failed</strong> because you have been using<br>changeset {0} which was already closed at {1}.<br>Please upload again with a new or an existing open changeset.</html>", l, DateUtils.formatDateTime(date, 3, 3));
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Changeset closed", new Object[0]), 0);
    }

    protected void handleUploadPreconditionFailedConflict(OsmApiException osmApiException, Pair<OsmPrimitive, Collection<OsmPrimitive>> pair) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Prepare conflict resolution", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to download all referring objects for {0}", pair.a), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to cancel and to resume editing the map", new Object[0]), null)};
        String string = ExceptionUtil.explainPreconditionFailed(osmApiException).replace("</html>", "<br><br>" + I18n.tr("Click <strong>{0}</strong> to load them now.<br>If necessary JOSM will create conflicts which you can resolve in the Conflict Resolution Dialog.", buttonSpecArray[0].text)) + "</html>";
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Object still in use", new Object[0]), 0, null, buttonSpecArray, buttonSpecArray[0], "/Action/Upload#NodeStillInUseInWay");
        if (n == 0) {
            DownloadReferrersAction.downloadReferrers(MainApplication.getLayerManager().getEditLayer(), Arrays.asList((OsmPrimitive)pair.a));
        }
    }

    protected void handleUploadConflict(OsmApiException osmApiException) {
        String string = osmApiException.getErrorHeader();
        if (string != null) {
            Pattern pattern = Pattern.compile("Version mismatch: Provided (\\d+), server had: (\\d+) of (\\S+) (\\d+)");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                this.handleUploadConflictForKnownConflict(OsmPrimitiveType.from(matcher.group(3)), Long.parseLong(matcher.group(4)), matcher.group(2), matcher.group(1));
                return;
            }
            pattern = Pattern.compile("The changeset (\\d+) was closed at (.*)");
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                this.handleUploadConflictForClosedChangeset(Long.parseLong(matcher.group(1)), DateUtils.fromString(matcher.group(2)));
                return;
            }
        }
        Logging.warn(I18n.tr("Error header \"{0}\" did not match with an expected pattern", string));
        this.handleUploadConflictForUnknownConflict();
    }

    protected void handlePreconditionFailed(OsmApiException osmApiException) {
        Pair<OsmPrimitive, Collection<OsmPrimitive>> pair = ExceptionUtil.parsePreconditionFailed(osmApiException.getErrorHeader());
        if (pair != null) {
            this.handleUploadPreconditionFailedConflict(osmApiException, pair);
        } else {
            Logging.warn(I18n.tr("Error header \"{0}\" did not match with an expected pattern", osmApiException.getErrorHeader()));
            ExceptionDialogUtil.explainPreconditionFailed(osmApiException);
        }
    }

    protected void handleGone(OsmApiPrimitiveGoneException osmApiPrimitiveGoneException) {
        if (osmApiPrimitiveGoneException.isKnownPrimitive()) {
            UpdateSelectionAction.handlePrimitiveGoneException(osmApiPrimitiveGoneException.getPrimitiveId(), osmApiPrimitiveGoneException.getPrimitiveType());
        } else {
            ExceptionDialogUtil.explainGoneForUnknownPrimitive(osmApiPrimitiveGoneException);
        }
    }

    protected void handleFailedUpload(Exception exception) {
        if (exception instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)exception);
            return;
        }
        if (exception instanceof OsmApiPrimitiveGoneException) {
            this.handleGone((OsmApiPrimitiveGoneException)exception);
            return;
        }
        if (exception instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)exception;
            if (osmApiException.getResponseCode() == 409) {
                this.handleUploadConflict(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 412) {
                this.handlePreconditionFailed(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 404) {
                ExceptionDialogUtil.explainNotFound(osmApiException);
                return;
            }
        }
        ExceptionDialogUtil.explainException(exception);
    }
}

