/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.audio.AudioPreference;
import org.openstreetmap.josm.gui.preferences.display.ColorPreference;
import org.openstreetmap.josm.gui.preferences.display.DisplayPreference;
import org.openstreetmap.josm.gui.preferences.display.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.display.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.BackupPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.remotecontrol.RemoteControlPreference;
import org.openstreetmap.josm.gui.preferences.server.AuthenticationPreference;
import org.openstreetmap.josm.gui.preferences.server.OverpassServerPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.shortcut.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTestsPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class PreferenceTabbedPane
extends JTabbedPane
implements MouseWheelListener,
ExpertToggleAction.ExpertModeChangeListener,
ChangeListener {
    private final transient List<PreferenceTab> tabs = new ArrayList<PreferenceTab>();
    private static final Collection<PreferenceSettingFactory> SETTINGS_FACTORIES = new LinkedList<PreferenceSettingFactory>();
    private static final PreferenceSettingFactory ADVANCED_PREFERENCE_FACTORY = new AdvancedPreference.Factory();
    private final transient List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    private final transient List<PreferenceSetting> settingsInitialized = new ArrayList<PreferenceSetting>();
    final transient List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting tabPreferenceSetting) {
        return this.createPreferenceTab(tabPreferenceSetting, false);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting tabPreferenceSetting, boolean bl) {
        PreferencePanel preferencePanel;
        CheckParameterUtil.ensureParameterNotNull(tabPreferenceSetting, "caller");
        JComponent jComponent = preferencePanel = new PreferencePanel(tabPreferenceSetting);
        if (bl) {
            PreferenceScrollPane preferenceScrollPane = new PreferenceScrollPane(preferencePanel);
            jComponent = preferenceScrollPane;
        }
        this.tabs.add((PreferenceTab)((Object)jComponent));
        return preferencePanel;
    }

    private void selectTabBy(TabIdentifier tabIdentifier, Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            PreferenceTab preferenceTab;
            Component component = this.getComponentAt(i);
            if (!(component instanceof PreferenceTab) || !tabIdentifier.identify((preferenceTab = (PreferenceTab)((Object)component)).getTabPreferenceSetting(), object)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public void selectTabByName(String string) {
        this.selectTabBy((tabPreferenceSetting, object) -> object != null && tabPreferenceSetting != null && tabPreferenceSetting.getIconName() != null && object.equals(tabPreferenceSetting.getIconName()), string);
    }

    public void selectTabByPref(Class<? extends TabPreferenceSetting> clazz) {
        this.selectTabBy((tabPreferenceSetting, object) -> tabPreferenceSetting.getClass().isAssignableFrom((Class)object), clazz);
    }

    public boolean selectSubTabByPref(Class<? extends SubPreferenceSetting> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isInstance(preferenceSetting)) continue;
            SubPreferenceSetting subPreferenceSetting = (SubPreferenceSetting)preferenceSetting;
            TabPreferenceSetting tabPreferenceSetting = subPreferenceSetting.getTabPreferenceSetting(this);
            this.selectTabBy((tabPreferenceSetting2, object) -> tabPreferenceSetting2.equals(tabPreferenceSetting), null);
            return tabPreferenceSetting.selectSubTab(subPreferenceSetting);
        }
        return false;
    }

    public DisplayPreference getDisplayPreference() {
        return this.getSetting(DisplayPreference.class);
    }

    public MapPreference getMapPreference() {
        return this.getSetting(MapPreference.class);
    }

    public PluginPreference getPluginPreference() {
        return this.getSetting(PluginPreference.class);
    }

    public ImageryPreference getImageryPreference() {
        return this.getSetting(ImageryPreference.class);
    }

    public ShortcutPreference getShortcutPreference() {
        return this.getSetting(ShortcutPreference.class);
    }

    public ServerAccessPreference getServerPreference() {
        return this.getSetting(ServerAccessPreference.class);
    }

    public ValidatorPreference getValidatorPreference() {
        return this.getSetting(ValidatorPreference.class);
    }

    public void savePreferences() {
        PluginPreference pluginPreference = this.getPluginPreference();
        if (pluginPreference != null) {
            Set<PluginInformation> set = pluginPreference.getPluginsScheduledForUpdateOrDownload();
            PluginDownloadTask pluginDownloadTask = set != null && !set.isEmpty() ? new PluginDownloadTask((Component)this, set, I18n.tr("Download plugins", new Object[0])) : null;
            PluginDownloadAfterTask pluginDownloadAfterTask = new PluginDownloadAfterTask(pluginPreference, pluginDownloadTask, set);
            if (pluginDownloadTask != null) {
                MainApplication.worker.submit(pluginDownloadTask);
                MainApplication.worker.submit(() -> SwingUtilities.invokeLater(pluginDownloadAfterTask));
            } else {
                pluginDownloadAfterTask.run();
            }
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(this);
        super.getModel().addChangeListener(this);
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void buildGui() {
        ArrayList<PreferenceSettingFactory> arrayList = new ArrayList<PreferenceSettingFactory>(SETTINGS_FACTORIES);
        arrayList.addAll(PluginHandler.getPreferenceSetting());
        arrayList.add(ADVANCED_PREFERENCE_FACTORY);
        for (PreferenceSettingFactory preferenceSettingFactory : arrayList) {
            PreferenceSetting preferenceSetting;
            if (preferenceSettingFactory == null || (preferenceSetting = preferenceSettingFactory.createPreferenceSetting()) == null) continue;
            this.settings.add(preferenceSetting);
        }
        this.addGUITabs(false);
    }

    private void addGUITabsForSetting(Icon icon, TabPreferenceSetting tabPreferenceSetting) {
        for (PreferenceTab preferenceTab : this.tabs) {
            if (!preferenceTab.getTabPreferenceSetting().equals(tabPreferenceSetting)) continue;
            this.insertGUITabsForSetting(icon, tabPreferenceSetting, this.getTabCount());
        }
    }

    private int insertGUITabsForSetting(Icon icon, TabPreferenceSetting tabPreferenceSetting, int n) {
        int n2 = n;
        for (PreferenceTab preferenceTab : this.tabs) {
            if (!preferenceTab.getTabPreferenceSetting().equals(tabPreferenceSetting)) continue;
            this.insertTab(null, icon, preferenceTab.getComponent(), tabPreferenceSetting.getTooltip(), n2++);
        }
        return n2 - 1;
    }

    private void addGUITabs(boolean bl) {
        boolean bl2 = ExpertToggleAction.isExpert();
        Component component = this.getSelectedComponent();
        if (bl) {
            this.removeAll();
        }
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (preferenceSetting instanceof TabPreferenceSetting) {
                TabPreferenceSetting tabPreferenceSetting = (TabPreferenceSetting)preferenceSetting;
                if (!bl2 && tabPreferenceSetting.isExpert()) continue;
                String string = tabPreferenceSetting.getIconName();
                ImageIcon imageIcon = null;
                if (string != null && !string.isEmpty()) {
                    imageIcon = ImageProvider.get("preferences", string, ImageProvider.ImageSizes.SETTINGS_TAB);
                }
                if (this.settingsInitialized.contains(tabPreferenceSetting)) {
                    this.addGUITabsForSetting(imageIcon, tabPreferenceSetting);
                    continue;
                }
                this.addTab(null, imageIcon, new PreferencePanel(tabPreferenceSetting), tabPreferenceSetting.getTooltip());
                continue;
            }
            if (preferenceSetting instanceof SubPreferenceSetting) continue;
            Logging.warn("Ignoring preferences " + preferenceSetting);
        }
        try {
            if (component != null) {
                this.setSelectedComponent(component);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.warn(illegalArgumentException);
        }
    }

    @Override
    public void expertChanged(boolean bl) {
        this.addGUITabs(true);
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isAssignableFrom(preferenceSetting.getClass())) continue;
            return (T)preferenceSetting;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (super.indexAtLocation(mouseWheelEvent.getPoint().x, mouseWheelEvent.getPoint().y) < 0) {
            return;
        }
        int n = super.getSelectedIndex() + mouseWheelEvent.getWheelRotation();
        n = n < 0 ? 0 : n;
        n = n >= super.getTabCount() ? super.getTabCount() - 1 : n;
        super.setSelectedIndex(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        PreferenceTab preferenceTab;
        TabPreferenceSetting tabPreferenceSetting;
        int n = this.getSelectedIndex();
        Component component = this.getSelectedComponent();
        if (n > -1 && component instanceof PreferenceTab && !this.settingsInitialized.contains(tabPreferenceSetting = (preferenceTab = (PreferenceTab)((Object)component)).getTabPreferenceSetting())) {
            try {
                this.getModel().removeChangeListener(this);
                tabPreferenceSetting.addGui(this);
                for (PreferenceSetting preferenceSetting : this.settings) {
                    if (!(preferenceSetting instanceof SubPreferenceSetting)) continue;
                    this.addSubPreferenceSetting(tabPreferenceSetting, (SubPreferenceSetting)preferenceSetting);
                }
                Icon icon = this.getIconAt(n);
                this.remove(n);
                if (n <= this.insertGUITabsForSetting(icon, tabPreferenceSetting, n)) {
                    this.setSelectedIndex(n);
                }
            }
            catch (SecurityException securityException) {
                Logging.error(securityException);
            }
            catch (RuntimeException runtimeException) {
                BugReportExceptionHandler.handleException(runtimeException);
            }
            finally {
                this.settingsInitialized.add(tabPreferenceSetting);
                this.getModel().addChangeListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubPreferenceSetting(TabPreferenceSetting tabPreferenceSetting, SubPreferenceSetting subPreferenceSetting) {
        if (subPreferenceSetting.getTabPreferenceSetting(this) == tabPreferenceSetting) {
            try {
                subPreferenceSetting.addGui(this);
            }
            catch (SecurityException securityException) {
                Logging.error(securityException);
            }
            catch (RuntimeException runtimeException) {
                BugReportExceptionHandler.handleException(runtimeException);
            }
            finally {
                this.settingsInitialized.add(subPreferenceSetting);
            }
        }
    }

    static {
        SETTINGS_FACTORIES.add(new DisplayPreference.Factory());
        SETTINGS_FACTORIES.add(new DrawingPreference.Factory());
        SETTINGS_FACTORIES.add(new ColorPreference.Factory());
        SETTINGS_FACTORIES.add(new LafPreference.Factory());
        SETTINGS_FACTORIES.add(new LanguagePreference.Factory());
        SETTINGS_FACTORIES.add(new ServerAccessPreference.Factory());
        SETTINGS_FACTORIES.add(new AuthenticationPreference.Factory());
        SETTINGS_FACTORIES.add(new ProxyPreference.Factory());
        SETTINGS_FACTORIES.add(new OverpassServerPreference.Factory());
        SETTINGS_FACTORIES.add(new MapPreference.Factory());
        SETTINGS_FACTORIES.add(new ProjectionPreference.Factory());
        SETTINGS_FACTORIES.add(new MapPaintPreference.Factory());
        SETTINGS_FACTORIES.add(new TaggingPresetPreference.Factory());
        SETTINGS_FACTORIES.add(new BackupPreference.Factory());
        SETTINGS_FACTORIES.add(new PluginPreference.Factory());
        SETTINGS_FACTORIES.add(MainApplication.getToolbar());
        SETTINGS_FACTORIES.add(new AudioPreference.Factory());
        SETTINGS_FACTORIES.add(new ShortcutPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorTestsPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorTagCheckerRulesPreference.Factory());
        SETTINGS_FACTORIES.add(new RemoteControlPreference.Factory());
        SETTINGS_FACTORIES.add(new ImageryPreference.Factory());
    }

    @FunctionalInterface
    private static interface TabIdentifier {
        public boolean identify(TabPreferenceSetting var1, Object var2);
    }

    public static final class PreferenceScrollPane
    extends JScrollPane
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferenceScrollPane(Component component, TabPreferenceSetting tabPreferenceSetting) {
            super(component);
            this.preferenceSetting = tabPreferenceSetting;
        }

        private PreferenceScrollPane(PreferencePanel preferencePanel) {
            this(preferencePanel.getComponent(), preferencePanel.getTabPreferenceSetting());
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    public static final class PreferencePanel
    extends JPanel
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferencePanel(TabPreferenceSetting tabPreferenceSetting) {
            super(new GridBagLayout());
            CheckParameterUtil.ensureParameterNotNull(tabPreferenceSetting);
            this.preferenceSetting = tabPreferenceSetting;
            this.buildPanel();
        }

        private void buildPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)new JLabel(this.preferenceSetting.getTitle()), GBC.eol().insets(0, 5, 0, 10).anchor(18));
            JLabel jLabel = new JLabel("<html>" + this.preferenceSetting.getDescription() + "</html>");
            jLabel.setFont(jLabel.getFont().deriveFont(2));
            this.add((Component)jLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    private static interface PreferenceTab {
        public TabPreferenceSetting getTabPreferenceSetting();

        public Component getComponent();
    }

    @FunctionalInterface
    public static interface ValidationListener {
        public boolean validatePreferences();
    }

    private final class PluginDownloadAfterTask
    implements Runnable {
        private final PluginPreference preference;
        private final PluginDownloadTask task;
        private final Set<PluginInformation> toDownload;

        private PluginDownloadAfterTask(PluginPreference pluginPreference, PluginDownloadTask pluginDownloadTask, Set<PluginInformation> set) {
            this.preference = pluginPreference;
            this.task = pluginDownloadTask;
            this.toDownload = set;
        }

        @Override
        public void run() {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray22;
            boolean bl = false;
            for (HelpAwareOptionPane.ButtonSpec[] buttonSpecArray22 : PreferenceTabbedPane.this.settingsInitialized) {
                if (!buttonSpecArray22.ok()) continue;
                bl = true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            if (this.task != null && !this.task.isCanceled()) {
                PluginHandler.refreshLocalUpdatedPluginInfo(this.task.getDownloadedPlugins());
                stringBuilder.append(PluginPreference.buildDownloadSummary(this.task));
            }
            if (bl) {
                stringBuilder.append(I18n.tr("You have to restart JOSM for some settings to take effect.", new Object[0]));
                stringBuilder.append("<br/><br/>");
                stringBuilder.append(I18n.tr("Would you like to restart now?", new Object[0]));
            }
            stringBuilder.append("</html>");
            if (bl) {
                buttonSpecArray22 = RestartAction.getButtonSpecs();
                if (0 == HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuilder.toString(), I18n.tr("Restart", new Object[0]), 1, null, buttonSpecArray22, buttonSpecArray22[0], null)) {
                    MainApplication.getMenu().restart.actionPerformed(null);
                }
            } else if (this.task != null && !this.task.isCanceled()) {
                JOptionPane.showMessageDialog(Main.parent, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
            }
            buttonSpecArray22 = this.preference.getNewlyActivatedPlugins();
            if (buttonSpecArray22 != null) {
                boolean bl2;
                Collection<PluginInformation> collection = null;
                if (this.task != null && !this.task.isCanceled()) {
                    collection = this.task.getDownloadedPlugins();
                }
                ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>();
                for (PluginInformation pluginInformation : buttonSpecArray22) {
                    if (this.toDownload.contains(pluginInformation) && collection != null && !collection.contains(pluginInformation) || !pluginInformation.canloadatruntime) continue;
                    arrayList.add(pluginInformation);
                }
                HashSet hashSet = new HashSet(arrayList);
                hashSet.addAll(PluginHandler.getPlugins());
                do {
                    bl2 = false;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        if (PluginHandler.checkRequiredPluginsPreconditions(null, hashSet, (PluginInformation)iterator.next(), bl)) continue;
                        iterator.remove();
                        bl2 = true;
                    }
                } while (bl2);
                if (!arrayList.isEmpty()) {
                    PluginHandler.loadPlugins(PreferenceTabbedPane.this, arrayList, null);
                }
            }
            Main.parent.repaint();
        }
    }
}

