/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class TextContextualPopupMenu
extends JPopupMenu {
    private static final String EDITABLE = "editable";
    protected JTextComponent component;
    protected boolean undoRedo;
    protected final UndoAction undoAction = new UndoAction();
    protected final RedoAction redoAction = new RedoAction();
    protected final UndoManager undo = new UndoManager();
    protected final transient UndoableEditListener undoEditListener = undoableEditEvent -> {
        this.undo.addEdit(undoableEditEvent.getEdit());
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    };
    protected final transient PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
        if (EDITABLE.equals(propertyChangeEvent.getPropertyName())) {
            this.removeAll();
            this.addMenuEntries();
        }
    };

    protected TextContextualPopupMenu() {
    }

    protected TextContextualPopupMenu attach(JTextComponent jTextComponent, boolean bl) {
        if (jTextComponent != null && !this.isAttached()) {
            this.component = jTextComponent;
            this.undoRedo = bl;
            if (bl && jTextComponent.isEditable()) {
                jTextComponent.getDocument().addUndoableEditListener(this.undoEditListener);
                if (!GraphicsEnvironment.isHeadless()) {
                    jTextComponent.getInputMap().put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), this.undoAction);
                    jTextComponent.getInputMap().put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), this.redoAction);
                }
            }
            this.addMenuEntries();
            jTextComponent.addPropertyChangeListener(EDITABLE, this.propertyChangeListener);
        }
        return this;
    }

    private void addMenuEntries() {
        if (this.component.isEditable()) {
            if (this.undoRedo) {
                this.add(new JMenuItem(this.undoAction));
                this.add(new JMenuItem(this.redoAction));
                this.addSeparator();
            }
            this.addMenuEntry(this.component, I18n.tr("Cut", new Object[0]), "cut-to-clipboard", null);
        }
        this.addMenuEntry(this.component, I18n.tr("Copy", new Object[0]), "copy-to-clipboard", "copy");
        if (this.component.isEditable()) {
            this.addMenuEntry(this.component, I18n.tr("Paste", new Object[0]), "paste-from-clipboard", "paste");
            this.addMenuEntry(this.component, I18n.tr("Delete", new Object[0]), "delete-next", null);
        }
        this.addSeparator();
        this.addMenuEntry(this.component, I18n.tr("Select All", new Object[0]), "select-all", null);
    }

    protected TextContextualPopupMenu detach() {
        if (this.isAttached()) {
            this.component.removePropertyChangeListener(EDITABLE, this.propertyChangeListener);
            this.removeAll();
            if (this.undoRedo) {
                this.component.getDocument().removeUndoableEditListener(this.undoEditListener);
            }
            this.component = null;
        }
        return this;
    }

    public static PopupMenuLauncher enableMenuFor(JTextComponent jTextComponent, boolean bl) {
        PopupMenuLauncher popupMenuLauncher = new PopupMenuLauncher(new TextContextualPopupMenu().attach(jTextComponent, bl), true);
        jTextComponent.addMouseListener(popupMenuLauncher);
        return popupMenuLauncher;
    }

    public static void disableMenuFor(JTextComponent jTextComponent, PopupMenuLauncher popupMenuLauncher) {
        if (popupMenuLauncher.getMenu() instanceof TextContextualPopupMenu) {
            ((TextContextualPopupMenu)popupMenuLauncher.getMenu()).detach();
            jTextComponent.removeMouseListener(popupMenuLauncher);
        }
    }

    public final boolean isAttached() {
        return this.component != null;
    }

    protected void addMenuEntry(JTextComponent jTextComponent, String string, String string2, String string3) {
        Action action = jTextComponent.getActionMap().get(string2);
        if (action != null) {
            ImageIcon imageIcon;
            JMenuItem jMenuItem = new JMenuItem(action);
            jMenuItem.setText(string);
            if (string3 != null && Main.pref.getBoolean("text.popupmenu.useicons", true) && (imageIcon = ImageProvider.get(string3, ImageProvider.ImageSizes.SMALLICON)) != null) {
                jMenuItem.setIcon(imageIcon);
            }
            this.add(jMenuItem);
        }
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(I18n.tr("Redo", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextContextualPopupMenu.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                Logging.trace(cannotRedoException);
            }
            finally {
                this.updateRedoState();
                TextContextualPopupMenu.this.undoAction.updateUndoState();
            }
        }

        public void updateRedoState() {
            if (TextContextualPopupMenu.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextContextualPopupMenu.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", I18n.tr("Redo", new Object[0]));
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(I18n.tr("Undo", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextContextualPopupMenu.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                Logging.trace(cannotUndoException);
            }
            finally {
                this.updateUndoState();
                TextContextualPopupMenu.this.redoAction.updateRedoState();
            }
        }

        public void updateUndoState() {
            if (TextContextualPopupMenu.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextContextualPopupMenu.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", I18n.tr("Undo", new Object[0]));
            }
        }
    }
}

