/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.DragNDropTool;
import CH.ifa.draw.contrib.MDIDesktopPane;
import CH.ifa.draw.contrib.MDI_InternalFrame;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.ToolButton;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class MDI_DrawApplication
extends DrawApplication
implements InternalFrameListener {
    private MDI_InternalFrame currentFrame;
    private JComponent desktop;
    private Vector mdiListeners;
    static /* synthetic */ Class class$CH$ifa$draw$contrib$MDI_InternalFrame;
    static /* synthetic */ Class class$CH$ifa$draw$framework$DrawingView;

    public MDI_DrawApplication() {
        this("JHotDraw");
    }

    public MDI_DrawApplication(String title) {
        super(title);
        this.setDesktop(new MDIDesktopPane());
        this.getDesktop().setAlignmentX(0.0f);
        this.mdiListeners = new Vector();
        this.addInternalFrameListener(this);
    }

    protected DrawApplication createApplication() {
        return new MDI_DrawApplication();
    }

    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        DragNDropTool tool = new DragNDropTool(this);
        ToolButton tb = this.createToolButton("/CH/ifa/draw/images/SEL", "Drag N Drop Tool", tool);
        palette.add(tb);
    }

    protected JComponent createContents(DrawingView view) {
        if (view.isInteractive()) {
            MDI_InternalFrame internalFrame = this.createInternalFrame(view);
            JComponent contents = super.createContents(view);
            internalFrame.getContentPane().add(contents);
            this.getDesktop().add(internalFrame);
            internalFrame.setVisible(true);
            try {
                internalFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        return this.getDesktop();
    }

    protected MDI_InternalFrame createInternalFrame(DrawingView view) {
        String applicationTitle = null;
        applicationTitle = view == null || view.drawing() == null || view.drawing().getTitle() == null ? this.getApplicationName() + " - " + this.getDefaultDrawingTitle() : this.getApplicationName() + " - " + view.drawing().getTitle();
        MDI_InternalFrame internalFrame = new MDI_InternalFrame(applicationTitle, true, true, true, true);
        internalFrame.setDrawingView(view);
        internalFrame.setSize(200, 200);
        Enumeration enumeration = this.mdiListeners.elements();
        while (enumeration.hasMoreElements()) {
            internalFrame.addInternalFrameListener((InternalFrameListener)enumeration.nextElement());
        }
        this.fireViewCreatedEvent(view);
        return internalFrame;
    }

    public void promptNew() {
        if (this.hasInternalFrames()) {
            super.promptNew();
        } else {
            this.newWindow(this.createDrawing());
        }
    }

    public void newWindow(Drawing newDrawing) {
        DrawingView newView = this.createDrawingView();
        newView.setDrawing(newDrawing);
        this.createContents(newView);
        this.toolDone();
    }

    protected DrawingView createInitialDrawingView() {
        return NullDrawingView.getManagedDrawingView(this);
    }

    public void newView() {
        if (!this.view().isInteractive()) {
            return;
        }
        String copyTitle = this.view().drawing().getTitle();
        DrawingView fView = this.createDrawingView();
        fView.setDrawing(this.view().drawing());
        this.createContents(fView);
        if (copyTitle != null) {
            this.setDrawingTitle(copyTitle + " (View)");
        } else {
            this.setDrawingTitle(this.getDefaultDrawingTitle() + " (View)");
        }
        this.toolDone();
    }

    protected void setDesktop(JComponent newDesktop) {
        this.desktop = newDesktop;
    }

    public JComponent getDesktop() {
        return this.desktop;
    }

    public void addInternalFrameListener(InternalFrameListener newMDIListener) {
        this.mdiListeners.addElement(newMDIListener);
    }

    public void removeInternalFrameListener(InternalFrameListener oldMDIListener) {
        this.mdiListeners.removeElement(oldMDIListener);
    }

    public void activateFrame(MDI_InternalFrame newFrame) {
        if (this.currentFrame != newFrame) {
            if (newFrame.getDrawingView().drawing() != null) {
                newFrame.getDrawingView().unfreezeView();
            }
            if (this.currentFrame != null) {
                this.currentFrame.getDrawingView().freezeView();
                this.currentFrame.getDrawingView().clearSelection();
            }
            this.currentFrame = newFrame;
        }
        this.setView(this.currentFrame.getDrawingView());
    }

    public void deactivateFrame(MDI_InternalFrame frame) {
        if (this.currentFrame == frame) {
            this.currentFrame = null;
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        this.activateFrame((MDI_InternalFrame)e.getSource());
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        MDI_InternalFrame mdf = (MDI_InternalFrame)e.getSource();
        DrawingView dv = mdf.getDrawingView();
        this.fireViewDestroyingEvent(dv);
        if (mdf == this.currentFrame) {
            this.currentFrame = null;
            this.setView(NullDrawingView.getManagedDrawingView(this));
        }
    }

    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
        this.deactivateFrame((MDI_InternalFrame)e.getSource());
    }

    protected void setDrawingTitle(String newDrawingTitle) {
        this.currentFrame.setTitle(this.getApplicationName() + " - " + newDrawingTitle);
    }

    protected String getDrawingTitle() {
        return this.currentFrame.getDrawing().getTitle();
    }

    public boolean hasInternalFrames() {
        return ((JDesktopPane)this.getDesktop()).getAllFrames().length > 0;
    }

    public DrawingView[] views() {
        ArrayList<DrawingView> frames = new ArrayList<DrawingView>();
        JInternalFrame[] ifs = ((JDesktopPane)this.getDesktop()).getAllFrames();
        for (int x = 0; x < ifs.length; ++x) {
            DrawingView dv;
            if (!(class$CH$ifa$draw$contrib$MDI_InternalFrame == null ? MDI_DrawApplication.class$("CH.ifa.draw.contrib.MDI_InternalFrame") : class$CH$ifa$draw$contrib$MDI_InternalFrame).isInstance(ifs[x]) || !(class$CH$ifa$draw$framework$DrawingView == null ? MDI_DrawApplication.class$("CH.ifa.draw.framework.DrawingView") : class$CH$ifa$draw$framework$DrawingView).isInstance(dv = ((MDI_InternalFrame)ifs[x]).getDrawingView())) continue;
            frames.add(dv);
        }
        DrawingView[] views = new DrawingView[frames.size()];
        frames.toArray(views);
        return views;
    }
}

