/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.interlis.domainsandconstants.basetypes;

import ch.ehi.basics.tools.AbstractVisitor;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.uml1_4.changepropagation.MetaModel;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.implementation.AbstractEditorElement;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class IliDim
extends AbstractEditorElement
implements Serializable {
    private double value;
    private long base10shift;
    private long accuracy;

    @Override
    public void unlinkAll() {
        super.unlinkAll();
    }

    @Override
    public void enumerateChildren(AbstractVisitor visitor) {
        Object it = null;
        super.enumerateChildren(visitor);
    }

    public String toString() {
        String fmtPattern = "0";
        if (this.getAccuracy() > 0L) {
            fmtPattern = fmtPattern + "." + StringUtility.STRING((int)this.getAccuracy(), '0');
        }
        double value = this.getValue();
        value /= Math.pow(10.0, this.getBase10shift());
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setMinusSign('-');
        symbols.setZeroDigit('0');
        DecimalFormat fmt = new DecimalFormat(fmtPattern, symbols);
        String ret = fmt.format(value);
        return ret;
    }

    public static IliDim parseIliDim(String value) throws NumberFormatException {
        value = value.trim();
        IliDim ret = new IliDim();
        double val = Double.parseDouble(value);
        ret.setValue(val);
        int pp = value.indexOf(46);
        int pe = value.indexOf(101);
        if (pe == -1) {
            pe = value.indexOf(69);
        }
        if (pp >= 0) {
            if (pe >= 0) {
                ret.setAccuracy(pe - pp - 1);
            } else {
                ret.setAccuracy(value.length() - pp - 1);
            }
        }
        if (pe >= 0) {
            ret.setBase10shift(Long.parseLong(value.substring(pe + 1)));
        }
        return ret;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value1) {
        if (this.value != value1) {
            this.value = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setValue"));
        }
    }

    public long getBase10shift() {
        return this.base10shift;
    }

    public void setBase10shift(long value1) {
        if (this.base10shift != value1) {
            this.base10shift = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setBase10shift"));
        }
    }

    public long getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(long value1) {
        if (this.accuracy != value1) {
            this.accuracy = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setAccuracy"));
        }
    }
}

