#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 1.19.2.1
id: pandoc-1.19.2.1-ZuCGUREFWXFP7jOsWsHNL
key: pandoc-1.19.2.1-ZuCGUREFWXFP7jOsWsHNL
license: GPL
copyright: (c) 2006-2017 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook,
    MediaWiki markup, TWiki markup, Haddock markup, OPML,
    Emacs Org-Mode, txt2tags, Word Docx, ODT, and Textile, and
    it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, OPML, TEI, OpenDocument, ODT,
    Word docx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    groff man pages, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign ICML,
    and several kinds of HTML/javascript slide shows (S5, Slidy,
    Slideous, DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.Options Text.Pandoc.Pretty
    Text.Pandoc.Shared Text.Pandoc.MediaBag Text.Pandoc.Error
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.TeXMath
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.EPUB
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.TEI Text.Pandoc.PDF Text.Pandoc.UTF8
    Text.Pandoc.Templates Text.Pandoc.XML Text.Pandoc.SelfContained
    Text.Pandoc.Process Text.Pandoc.CSS
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Combine Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Util Text.Pandoc.Readers.Docx.StyleMap
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Writers.Shared
                Text.Pandoc.Asciify Text.Pandoc.MIME Text.Pandoc.Emoji
                Text.Pandoc.Parsing Text.Pandoc.UUID Text.Pandoc.ImageSize
                Text.Pandoc.Slides Text.Pandoc.Highlighting Text.Pandoc.Compat.Time
                Paths_pandoc
abi: 1848a8af9bfccfb0f3aafb47a657a09f
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/pandoc-1.19.2.1
library-dirs: /usr/lib/ghc-8.0.2/site-local/pandoc-1.19.2.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-1.19.2.1-ZuCGUREFWXFP7jOsWsHNL
depends:
    HTTP-4000.3.7-C67mjM47SfREJVHCgq4Jk3
    JuicyPixels-3.2.8.2-HrNcnMwJkalEdbHk5NK8ZZ
    SHA-1.6.4.2-6ZuKopcglGG4yoCGsd9koJ
    aeson-1.2.1.0-LtwtJj4trOg6E4DiroefXf array-0.5.1.1 base-4.9.1.0
    base64-bytestring-1.0.0.1-4O9TExPPz6eI82Yj7L4SIj binary-0.8.3.0
    blaze-html-0.9.0.1-6LoDCyuiOhm81hDccML19n
    blaze-markup-0.8.0.0-6wPbGvG5gVcIJK8r30JWLy bytestring-0.10.8.1
    cmark-0.5.6-JrUbgXp74siFdj3ZwUkLiw containers-0.5.7.1
    data-default-0.7.1.1-BNa3MzH41nV77yjS9K2Umq deepseq-1.4.2.0
    directory-1.3.0.0 doctemplates-0.1.0.2-KFHsuPypoIkAHjL8Gys8jz
    extensible-exceptions-0.1.1.4-IyAM3ARTqH7BVZ5oHMMtXH
    filemanip-0.3.6.3-39GGNCiHahb1wSL6fkG6wy filepath-1.4.1.1
    ghc-prim-0.5.0.0 haddock-library-1.4.3-JbTvLSEdh1LEWm8KMmBVQ
    hslua-0.4.1-ExHfa66qat32tQJe1kVtYH
    http-client-0.5.7.0-8CqgjLtDELe98Oo6kiK06v
    http-client-tls-0.3.5.1-5I7vA8BJnYp84mvxgJeNG3
    http-types-0.9.1-IqlxYYwrFhNBj6J7ATsByJ
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    network-2.6.3.2-IsLM4TXcLoRI0fmmBYVyQz
    network-uri-2.6.1.0-GzRvaV3udR3JtWfa3CLYOw
    old-time-1.1.0.3-EZzkBJ4NQxX4hHavrKxgaT
    pandoc-types-1.17.0.5-Ib0hSG6lz3sKb2F5FwlV4S
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR process-1.4.3.0
    random-1.1-9tceXaeYIMZ4JrKq20Egog
    scientific-0.3.5.1-3aJEdQvcyho88FhIoGrzGS
    skylighting-0.1.1.5-LTopY76uQqiE1jIIizjTL8
    syb-0.7-4OKdCpwGutyB1rNRmoa0ya
    tagsoup-0.14.1-A8v7iyBjfz82GOKyhT5ypk
    temporary-1.2.1.1-6DswsWwyVfs4EvmtlA0bHh
    texmath-0.9.4.1-IJdXBihRj3QJg8bMvqFvqF
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    unordered-containers-0.2.8.0-1tqMF698WJE3INvmpuzQZc
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
    xml-1.3.14-FVnE0jAbj4fGGraldXZwwG
    yaml-0.8.23.3-3BbiUBqxe192HmKg4jbbCV
    zip-archive-0.3.1.1-CTnIdx1PD2R28s6Hv1Ft3y
    zlib-0.6.1.2-GcLmGV5PElZD6CJvjR9umm
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
