/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Set;
import sun.security.ssl.CloneableDigest;
import sun.security.ssl.ProtocolVersion;

final class HandshakeHash {
    private int version = -1;
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private final boolean isServer;
    private MessageDigest md5;
    private MessageDigest sha;
    private final int clonesNeeded;
    private boolean cvAlgDetermined = false;
    private String cvAlg;
    private MessageDigest finMD;

    HandshakeHash(boolean isServer, boolean needCertificateVerify, Set<String> algs) {
        this.isServer = isServer;
        this.clonesNeeded = needCertificateVerify ? 3 : 2;
    }

    void update(byte[] b, int offset, int len) {
        switch (this.version) {
            case 1: {
                this.md5.update(b, offset, len);
                this.sha.update(b, offset, len);
                break;
            }
            default: {
                if (this.finMD != null) {
                    this.finMD.update(b, offset, len);
                }
                this.data.write(b, offset, len);
            }
        }
    }

    void reset() {
        if (this.version != -1) {
            throw new RuntimeException("reset() can be only be called before protocolDetermined");
        }
        this.data.reset();
    }

    void protocolDetermined(ProtocolVersion pv) {
        if (this.version != -1) {
            return;
        }
        this.version = pv.compareTo(ProtocolVersion.TLS12) >= 0 ? 2 : 1;
        switch (this.version) {
            case 1: {
                try {
                    this.md5 = CloneableDigest.getDigest("MD5", this.clonesNeeded);
                    this.sha = CloneableDigest.getDigest("SHA", this.clonesNeeded);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Algorithm MD5 or SHA not available", e);
                }
                byte[] bytes = this.data.toByteArray();
                this.update(bytes, 0, bytes.length);
                break;
            }
        }
    }

    MessageDigest getMD5Clone() {
        if (this.version != 1) {
            throw new RuntimeException("getMD5Clone() can be only be called for TLS 1.1");
        }
        return HandshakeHash.cloneDigest(this.md5);
    }

    MessageDigest getSHAClone() {
        if (this.version != 1) {
            throw new RuntimeException("getSHAClone() can be only be called for TLS 1.1");
        }
        return HandshakeHash.cloneDigest(this.sha);
    }

    private static MessageDigest cloneDigest(MessageDigest digest) {
        try {
            return (MessageDigest)digest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone digest", e);
        }
    }

    private static String normalizeAlgName(String alg) {
        if ((alg = alg.toUpperCase(Locale.US)).startsWith("SHA")) {
            if (alg.length() == 3) {
                return "SHA-1";
            }
            if (alg.charAt(3) != '-') {
                return "SHA-" + alg.substring(3);
            }
        }
        return alg;
    }

    void setFinishedAlg(String s) {
        if (s == null) {
            throw new RuntimeException("setFinishedAlg's argument cannot be null");
        }
        if (this.finMD != null) {
            return;
        }
        try {
            this.finMD = CloneableDigest.getDigest(HandshakeHash.normalizeAlgName(s), 2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        this.finMD.update(this.data.toByteArray());
    }

    void restrictCertificateVerifyAlgs(Set<String> algs) {
        if (this.version == 1) {
            throw new RuntimeException("setCertificateVerifyAlg() cannot be called for TLS 1.1");
        }
    }

    void setCertificateVerifyAlg(String s) {
        if (this.cvAlgDetermined) {
            return;
        }
        this.cvAlg = s == null ? null : HandshakeHash.normalizeAlgName(s);
        this.cvAlgDetermined = true;
    }

    byte[] getAllHandshakeMessages() {
        return this.data.toByteArray();
    }

    byte[] getFinishedHash() {
        try {
            return HandshakeHash.cloneDigest(this.finMD).digest();
        }
        catch (Exception e) {
            throw new Error("BAD");
        }
    }
}

