/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLProtocolException;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.SunJSSE;

final class SupportedEllipticCurvesExtension
extends HelloExtension {
    private static final Debug debug;
    private static final int ARBITRARY_PRIME = 65281;
    private static final int ARBITRARY_CHAR2 = 65282;
    private static final Map<String, Integer> oidToIdMap;
    private static final Map<Integer, String> idToOidMap;
    private static final Map<Integer, AlgorithmParameters> idToParams;
    private static final int[] supportedCurveIds;
    private final int[] curveIds;

    private static boolean isAvailableCurve(int curveId) {
        String oid = idToOidMap.get(curveId);
        if (oid != null) {
            AlgorithmParameters params = null;
            try {
                params = JsseJce.getAlgorithmParameters("EC");
                params.init(new ECGenParameterSpec(oid));
            }
            catch (Exception e) {
                return false;
            }
            idToParams.put(curveId, params);
            return true;
        }
        return false;
    }

    private SupportedEllipticCurvesExtension(int[] curveIds) {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        this.curveIds = curveIds;
    }

    SupportedEllipticCurvesExtension(HandshakeInStream s, int len) throws IOException {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        int k = s.getInt16();
        if ((len & 1) != 0 || k + 2 != len) {
            throw new SSLProtocolException("Invalid " + this.type + " extension");
        }
        this.curveIds = new int[k >> 1];
        for (int i = 0; i < this.curveIds.length; ++i) {
            this.curveIds[i] = s.getInt16();
        }
    }

    static int getActiveCurves(AlgorithmConstraints constraints) {
        return SupportedEllipticCurvesExtension.getPreferredCurve(supportedCurveIds, constraints);
    }

    static boolean hasActiveCurves(AlgorithmConstraints constraints) {
        return SupportedEllipticCurvesExtension.getActiveCurves(constraints) >= 0;
    }

    static SupportedEllipticCurvesExtension createExtension(AlgorithmConstraints constraints) {
        ArrayList<Integer> idList = new ArrayList<Integer>(supportedCurveIds.length);
        for (int curveId : supportedCurveIds) {
            if (!constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), "EC", idToParams.get(curveId))) continue;
            idList.add(curveId);
        }
        if (!idList.isEmpty()) {
            int[] ids = new int[idList.size()];
            int i = 0;
            for (Integer id : idList) {
                ids[i++] = id;
            }
            return new SupportedEllipticCurvesExtension(ids);
        }
        return null;
    }

    int getPreferredCurve(AlgorithmConstraints constraints) {
        return SupportedEllipticCurvesExtension.getPreferredCurve(this.curveIds, constraints);
    }

    private static int getPreferredCurve(int[] curves, AlgorithmConstraints constraints) {
        for (int curveId : curves) {
            if (!SupportedEllipticCurvesExtension.isSupported(curveId) || !constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), "EC", idToParams.get(curveId))) continue;
            return curveId;
        }
        return -1;
    }

    boolean contains(int index) {
        for (int curveId : this.curveIds) {
            if (index != curveId) continue;
            return true;
        }
        return false;
    }

    @Override
    int length() {
        return 6 + (this.curveIds.length << 1);
    }

    @Override
    void send(HandshakeOutStream s) throws IOException {
        s.putInt16(this.type.id);
        int k = this.curveIds.length << 1;
        s.putInt16(k + 2);
        s.putInt16(k);
        for (int curveId : this.curveIds) {
            s.putInt16(curveId);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Extension " + this.type + ", curve names: {");
        boolean first = true;
        for (int curveId : this.curveIds) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String curveName = SupportedEllipticCurvesExtension.getCurveName(curveId);
            if (curveName != null) {
                sb.append(curveName);
                continue;
            }
            if (curveId == 65281) {
                sb.append("arbitrary_explicit_prime_curves");
                continue;
            }
            if (curveId == 65282) {
                sb.append("arbitrary_explicit_char2_curves");
                continue;
            }
            sb.append("unknown curve " + curveId);
        }
        sb.append("}");
        return sb.toString();
    }

    static boolean isSupported(int index) {
        for (int curveId : supportedCurveIds) {
            if (index != curveId) continue;
            return true;
        }
        return false;
    }

    static int getCurveIndex(ECParameterSpec params) {
        String oid = JsseJce.getNamedCurveOid(params);
        if (oid == null) {
            return -1;
        }
        Integer n = oidToIdMap.get(oid);
        return n == null ? -1 : n;
    }

    static String getCurveOid(int index) {
        return idToOidMap.get(index);
    }

    static ECGenParameterSpec getECGenParamSpec(int index) {
        AlgorithmParameters params = idToParams.get(index);
        try {
            return params.getParameterSpec(ECGenParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            String curveOid = SupportedEllipticCurvesExtension.getCurveOid(index);
            return new ECGenParameterSpec(curveOid);
        }
    }

    private static String getCurveName(int index) {
        for (NamedEllipticCurve namedCurve : NamedEllipticCurve.values()) {
            if (namedCurve.id != index) continue;
            return namedCurve.name;
        }
        return null;
    }

    static {
        ArrayList<Integer> idList;
        debug = Debug.getInstance("ssl");
        oidToIdMap = new HashMap<String, Integer>();
        idToOidMap = new HashMap<Integer, String>();
        idToParams = new HashMap<Integer, AlgorithmParameters>();
        boolean requireFips = SunJSSE.isFIPS();
        NamedEllipticCurve nec = NamedEllipticCurve.getCurve("secp256r1", false);
        String property = AccessController.doPrivileged(new GetPropertyAction("jdk.tls.namedGroups"));
        if (property != null && property.length() != 0 && property.length() > 1 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
            property = property.substring(1, property.length() - 1);
        }
        if (property != null && property.length() != 0) {
            String[] curves = property.split(",");
            idList = new ArrayList<Integer>(curves.length);
            for (String curve : curves) {
                NamedEllipticCurve namedCurve;
                if ((curve = curve.trim()).isEmpty() || (namedCurve = NamedEllipticCurve.getCurve(curve, requireFips)) == null || !SupportedEllipticCurvesExtension.isAvailableCurve(namedCurve.id)) continue;
                idList.add(namedCurve.id);
            }
            if (idList.isEmpty() && JsseJce.isEcAvailable()) {
                throw new IllegalArgumentException("System property jdk.tls.namedGroups(" + property + ") " + "contains no supported elliptic curves");
            }
        } else {
            int[] ids = new int[]{23, 24, 25};
            idList = new ArrayList(ids.length);
            for (int curveId : ids) {
                if (!SupportedEllipticCurvesExtension.isAvailableCurve(curveId)) continue;
                idList.add(curveId);
            }
        }
        if (debug != null && idList.isEmpty()) {
            debug.println("Initialized [jdk.tls.namedGroups|default] list contains no available elliptic curves. " + (property != null ? "(" + property + ")" : "[Default]"));
        }
        supportedCurveIds = new int[idList.size()];
        int i = 0;
        for (Integer id : idList) {
            SupportedEllipticCurvesExtension.supportedCurveIds[i++] = id;
        }
    }

    private static enum NamedEllipticCurve {
        P256_R1(23, "secp256r1", "1.2.840.10045.3.1.7", true),
        P384_R1(24, "secp384r1", "1.3.132.0.34", true),
        P521_R1(25, "secp521r1", "1.3.132.0.35", true);

        int id;
        String name;
        String oid;
        boolean isFips;

        private NamedEllipticCurve(int id, String name, String oid, boolean isFips) {
            this.id = id;
            this.name = name;
            this.oid = oid;
            this.isFips = isFips;
            if (oidToIdMap.put(oid, id) != null || idToOidMap.put(id, oid) != null) {
                throw new RuntimeException("Duplicate named elliptic curve definition: " + name);
            }
        }

        static NamedEllipticCurve getCurve(String name, boolean requireFips) {
            for (NamedEllipticCurve curve : NamedEllipticCurve.values()) {
                if (!curve.name.equals(name) || requireFips && !curve.isFips) continue;
                return curve;
            }
            return null;
        }
    }
}

