/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.CommandSource$;
import sbt.Exec$;
import sbt.StandardMain$;
import sbt.internal.BuildStructure;
import sbt.internal.CommandChannel;
import sbt.internal.server.NetworkChannel$;
import sbt.internal.server.SettingQuery$;
import sbt.protocol.CommandMessage;
import sbt.protocol.EventMessage;
import sbt.protocol.ExecCommand;
import sbt.protocol.Serialization$;
import sbt.protocol.SettingQuery;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import sjsonnew.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0005%\u0011aBT3uo>\u00148n\u00115b]:,GN\u0003\u0002\u0004\t\u000511/\u001a:wKJT!!\u0002\u0004\u0002\u0011%tG/\u001a:oC2T\u0011aB\u0001\u0004g\n$8\u0001A\n\u0003\u0001)\u0001\"a\u0003\u0007\u000e\u0003\u0011I!!\u0004\u0003\u0003\u001d\r{W.\\1oI\u000eC\u0017M\u001c8fY\"Aq\u0002\u0001BC\u0002\u0013\u0005\u0001#\u0001\u0003oC6,W#A\t\u0011\u0005IYbBA\n\u001a!\t!r#D\u0001\u0016\u0015\t1\u0002\"\u0001\u0004=e>|GO\u0010\u0006\u00021\u0005)1oY1mC&\u0011!dF\u0001\u0007!J,G-\u001a4\n\u0005qi\"AB*ue&twM\u0003\u0002\u001b/!Aq\u0004\u0001B\u0001B\u0003%\u0011#A\u0003oC6,\u0007\u0005\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003)\u0019wN\u001c8fGRLwN\u001c\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\n1A\\3u\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\rM{7m[3u\u0011!Y\u0003A!A!\u0002\u0013a\u0013!C:ueV\u001cG/\u001e:f!\tYQ&\u0003\u0002/\t\tq!)^5mIN#(/^2ukJ,\u0007\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\b\u0006\u00033iU2\u0004CA\u001a\u0001\u001b\u0005\u0011\u0001\"B\b0\u0001\u0004\t\u0002\"B\u00110\u0001\u0004\u0011\u0003\"B\u00160\u0001\u0004a\u0003b\u0002\u001d\u0001\u0005\u0004%I!O\u0001\beVtg.\u001b8h+\u0005Q\u0004CA\u001eC\u001b\u0005a$BA\u001f?\u0003\u0019\tGo\\7jG*\u0011q\bQ\u0001\u000bG>t7-\u001e:sK:$(BA!'\u0003\u0011)H/\u001b7\n\u0005\rc$!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004F\u0001\u0001\u0006IAO\u0001\teVtg.\u001b8hA!9q\t\u0001b\u0001\n\u0013A\u0015!\u00033fY&l\u0017\u000e^3s+\u0005I\u0005C\u0001&L\u001b\u00059\u0012B\u0001'\u0018\u0005\u0011\u0011\u0015\u0010^3\t\r9\u0003\u0001\u0015!\u0003J\u0003)!W\r\\5nSR,'\u000f\t\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0003\ryW\u000f^\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011QKJ\u0001\u0003S>L!a\u0016+\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\re\u0003\u0001\u0015!\u0003S\u0003\u0011yW\u000f\u001e\u0011\t\u000fm\u0003!\u0019!C\u00019\u00061A\u000f\u001b:fC\u0012,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u001a\nA\u0001\\1oO&\u0011!m\u0018\u0002\u0007)\"\u0014X-\u00193\t\r\u0011\u0004\u0001\u0015!\u0003^\u0003\u001d!\bN]3bI\u0002BQA\u001a\u0001\u0005\u0002\u001d\fA\u0002];cY&\u001c\b.\u0012<f]R,\"\u0001[<\u0015\u0007%\f\t\u0001\u0006\u0002k[B\u0011!j[\u0005\u0003Y^\u0011A!\u00168ji\"9a.ZA\u0001\u0002\by\u0017AC3wS\u0012,gnY3%cA\u0019\u0001o];\u000e\u0003ET\u0011A]\u0001\tg*\u001cxN\u001c8fo&\u0011A/\u001d\u0002\u000b\u0015N|gNR8s[\u0006$\bC\u0001<x\u0019\u0001!Q\u0001_3C\u0002e\u0014\u0011!Q\t\u0003uv\u0004\"AS>\n\u0005q<\"a\u0002(pi\"Lgn\u001a\t\u0003\u0015zL!a`\f\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002\u0004\u0015\u0004\r!^\u0001\u0006KZ,g\u000e\u001e\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0003M\u0001XO\u00197jg\",e/\u001a8u\u001b\u0016\u001c8/Y4f)\rQ\u00171\u0002\u0005\t\u0003\u0007\t)\u00011\u0001\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014\u0019\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003/\t\tB\u0001\u0007Fm\u0016tG/T3tg\u0006<W\rC\u0004\u0002\u001c\u0001!\t!!\b\u0002\u0019A,(\r\\5tQ\nKH/Z:\u0015\u0007)\fy\u0002\u0003\u0005\u0002\u0004\u0005e\u0001\u0019AA\u0011!\u0011Q\u00151E%\n\u0007\u0005\u0015rCA\u0003BeJ\f\u0017\u0010C\u0004\u0002*\u0001!\t!a\u000b\u0002\u0013=t7i\\7nC:$Gc\u00016\u0002.!A\u0011qFA\u0014\u0001\u0004\t\t$A\u0004d_6l\u0017M\u001c3\u0011\t\u0005=\u00111G\u0005\u0005\u0003k\t\tB\u0001\bD_6l\u0017M\u001c3NKN\u001c\u0018mZ3\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005iqN\\#yK\u000e\u001cu.\\7b]\u0012$B!!\u0010\u0002DA\u0019!*a\u0010\n\u0007\u0005\u0005sCA\u0004C_>dW-\u00198\t\u0011\u0005\u0015\u0013q\u0007a\u0001\u0003\u000f\n1aY7e!\u0011\ty!!\u0013\n\t\u0005-\u0013\u0011\u0003\u0002\f\u000bb,7mQ8n[\u0006tG\rC\u0004\u0002P\u0001!I!!\u0015\u0002\u001d=t7+\u001a;uS:<\u0017+^3ssR\u0019!.a\u0015\t\u0011\u0005U\u0013Q\na\u0001\u0003/\n1A]3r!\u0011\ty!!\u0017\n\t\u0005m\u0013\u0011\u0003\u0002\r'\u0016$H/\u001b8h#V,'/\u001f\u0005\b\u0003?\u0002A\u0011AA1\u0003!\u0019\b.\u001e;e_^tG#\u00016")
public final class NetworkChannel
extends CommandChannel {
    private final String name;
    public final Socket sbt$internal$server$NetworkChannel$$connection;
    private final BuildStructure structure;
    private final AtomicBoolean sbt$internal$server$NetworkChannel$$running;
    private final byte sbt$internal$server$NetworkChannel$$delimiter;
    private final OutputStream out;
    private final Thread thread;

    public String name() {
        return this.name;
    }

    public AtomicBoolean sbt$internal$server$NetworkChannel$$running() {
        return this.sbt$internal$server$NetworkChannel$$running;
    }

    public byte sbt$internal$server$NetworkChannel$$delimiter() {
        return this.sbt$internal$server$NetworkChannel$$delimiter;
    }

    private OutputStream out() {
        return this.out;
    }

    public Thread thread() {
        return this.thread;
    }

    public <A> void publishEvent(A event, JsonFormat<A> evidence$1) {
        byte[] bytes = Serialization$.MODULE$.serializeEvent(event, evidence$1);
        this.publishBytes(bytes);
    }

    public void publishEventMessage(EventMessage event) {
        byte[] bytes = Serialization$.MODULE$.serializeEventMessage(event);
        this.publishBytes(bytes);
    }

    public void publishBytes(byte[] event) {
        this.out().write(event);
        this.out().write(this.sbt$internal$server$NetworkChannel$$delimiter());
        this.out().flush();
    }

    public void onCommand(CommandMessage command) {
        CommandMessage commandMessage = command;
        if (commandMessage instanceof ExecCommand) {
            ExecCommand execCommand = (ExecCommand)commandMessage;
            this.onExecCommand(execCommand);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (commandMessage instanceof SettingQuery) {
            SettingQuery settingQuery = (SettingQuery)commandMessage;
            this.onSettingQuery(settingQuery);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)commandMessage);
        }
    }

    private boolean onExecCommand(ExecCommand cmd) {
        return this.append(Exec$.MODULE$.apply(cmd.commandLine(), cmd.execId().orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)Exec$.MODULE$.newExecId())), (Option)new Some((Object)CommandSource$.MODULE$.apply(this.name()))));
    }

    private void onSettingQuery(SettingQuery req) {
        StandardMain$.MODULE$.exchange().publishEventMessage((EventMessage)SettingQuery$.MODULE$.handleSettingQuery(req, this.structure));
    }

    public void shutdown() {
        Predef$.MODULE$.println((Object)"Shutting down client connection");
        this.sbt$internal$server$NetworkChannel$$running().set(false);
        this.out().close();
    }

    public NetworkChannel(String name, Socket connection, BuildStructure structure) {
        this.name = name;
        this.sbt$internal$server$NetworkChannel$$connection = connection;
        this.structure = structure;
        this.sbt$internal$server$NetworkChannel$$running = new AtomicBoolean(true);
        this.sbt$internal$server$NetworkChannel$$delimiter = (byte)10;
        this.out = connection.getOutputStream();
        this.thread = new Thread(this){
            private final /* synthetic */ NetworkChannel $outer;

            public void run() {
                try {
                    byte[] readBuffer = new byte[4096];
                    InputStream in = this.$outer.sbt$internal$server$NetworkChannel$$connection.getInputStream();
                    this.$outer.sbt$internal$server$NetworkChannel$$connection.setSoTimeout(5000);
                    Vector buffer = package$.MODULE$.Vector().empty();
                    int bytesRead = 0;
                    while (bytesRead != -1 && this.$outer.sbt$internal$server$NetworkChannel$$running().get()) {
                        Object object;
                        try {
                            bytesRead = in.read(readBuffer);
                            buffer = (Vector)buffer.$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(readBuffer)).toVector().take(bytesRead), Vector$.MODULE$.canBuildFrom());
                            int delimPos = buffer.indexOf((Object)BoxesRunTime.boxToByte((byte)this.$outer.sbt$internal$server$NetworkChannel$$delimiter()));
                            if (delimPos > 0) {
                                Vector chunk = buffer.take(delimPos);
                                buffer = buffer.drop(delimPos + 1);
                                object = Serialization$.MODULE$.deserializeCommand((Seq)chunk).fold((Function1 & Serializable & scala.Serializable)errorDesc -> {
                                    $anon$1.$anonfun$run$1(errorDesc);
                                    return BoxedUnit.UNIT;
                                }, (Function1 & Serializable & scala.Serializable)command -> {
                                    $anon$1.$anonfun$run$2(this, command);
                                    return BoxedUnit.UNIT;
                                });
                                continue;
                            }
                            object = BoxedUnit.UNIT;
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            object = BoxedUnit.UNIT;
                        }
                    }
                }
                finally {
                    this.$outer.shutdown();
                }
            }

            public static final /* synthetic */ void $anonfun$run$1(String errorDesc) {
                Predef$.MODULE$.println((Object)("Got invalid chunk from client: " + errorDesc));
            }

            public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, CommandMessage command) {
                $this.$outer.onCommand(command);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sbt-networkchannel-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$outer.sbt$internal$server$NetworkChannel$$connection.getPort())})));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(java.lang.String ), $anonfun$run$2$adapted(sbt.internal.server.NetworkChannel$$anon$1 sbt.protocol.CommandMessage )}, serializedLambda);
            }
        };
        this.thread().start();
    }
}

