/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.Cipher;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.Aes128CtsHmacSha1EType;
import sun.security.krb5.internal.crypto.Aes256CtsHmacSha1EType;
import sun.security.krb5.internal.crypto.ArcFourHmacEType;
import sun.security.krb5.internal.crypto.Des3CbcHmacSha1KdEType;
import sun.security.krb5.internal.crypto.DesCbcCrcEType;
import sun.security.krb5.internal.crypto.DesCbcMd5EType;
import sun.security.krb5.internal.crypto.NullEType;

public abstract class EType {
    private static final boolean DEBUG;
    private static final boolean ALLOW_WEAK_CRYPTO;
    private static final int[] BUILTIN_ETYPES;
    private static final int[] BUILTIN_ETYPES_NOAES256;

    public static EType getInstance(int eTypeConst) throws KdcErrException {
        EType eType = null;
        String eTypeName = null;
        switch (eTypeConst) {
            case 0: {
                eType = new NullEType();
                eTypeName = "sun.security.krb5.internal.crypto.NullEType";
                break;
            }
            case 1: {
                eType = new DesCbcCrcEType();
                eTypeName = "sun.security.krb5.internal.crypto.DesCbcCrcEType";
                break;
            }
            case 3: {
                eType = new DesCbcMd5EType();
                eTypeName = "sun.security.krb5.internal.crypto.DesCbcMd5EType";
                break;
            }
            case 16: {
                eType = new Des3CbcHmacSha1KdEType();
                eTypeName = "sun.security.krb5.internal.crypto.Des3CbcHmacSha1KdEType";
                break;
            }
            case 17: {
                eType = new Aes128CtsHmacSha1EType();
                eTypeName = "sun.security.krb5.internal.crypto.Aes128CtsHmacSha1EType";
                break;
            }
            case 18: {
                eType = new Aes256CtsHmacSha1EType();
                eTypeName = "sun.security.krb5.internal.crypto.Aes256CtsHmacSha1EType";
                break;
            }
            case 23: {
                eType = new ArcFourHmacEType();
                eTypeName = "sun.security.krb5.internal.crypto.ArcFourHmacEType";
                break;
            }
            default: {
                String msg = "encryption type = " + EType.toString(eTypeConst) + " (" + eTypeConst + ")";
                throw new KdcErrException(14, msg);
            }
        }
        if (DEBUG) {
            System.out.println(">>> EType: " + eTypeName);
        }
        return eType;
    }

    public abstract int eType();

    public abstract int minimumPadSize();

    public abstract int confounderSize();

    public abstract int checksumType();

    public abstract int checksumSize();

    public abstract int blockSize();

    public abstract int keyType();

    public abstract int keySize();

    public abstract byte[] encrypt(byte[] var1, byte[] var2, int var3) throws KrbCryptoException;

    public abstract byte[] encrypt(byte[] var1, byte[] var2, byte[] var3, int var4) throws KrbCryptoException;

    public abstract byte[] decrypt(byte[] var1, byte[] var2, int var3) throws KrbApErrException, KrbCryptoException;

    public abstract byte[] decrypt(byte[] var1, byte[] var2, byte[] var3, int var4) throws KrbApErrException, KrbCryptoException;

    public int dataSize(byte[] data) {
        return data.length - this.startOfData();
    }

    public int padSize(byte[] data) {
        return data.length - this.confounderSize() - this.checksumSize() - this.dataSize(data);
    }

    public int startOfChecksum() {
        return this.confounderSize();
    }

    public int startOfData() {
        return this.confounderSize() + this.checksumSize();
    }

    public int startOfPad(byte[] data) {
        return this.confounderSize() + this.checksumSize() + this.dataSize(data);
    }

    public byte[] decryptedData(byte[] data) {
        int tempSize = this.dataSize(data);
        byte[] result = new byte[tempSize];
        System.arraycopy(data, this.startOfData(), result, 0, tempSize);
        return result;
    }

    public static int[] getBuiltInDefaults() {
        int allowed = 0;
        try {
            allowed = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] result = allowed < 256 ? BUILTIN_ETYPES_NOAES256 : BUILTIN_ETYPES;
        if (!ALLOW_WEAK_CRYPTO) {
            return Arrays.copyOfRange(result, 0, result.length - 2);
        }
        return result;
    }

    public static int[] getDefaults(String configName) {
        try {
            return Config.getInstance().defaultEtype(configName);
        }
        catch (KrbException exc) {
            if (DEBUG) {
                System.out.println("Exception while getting " + configName + exc.getMessage());
                System.out.println("Using default builtin etypes");
            }
            return EType.getBuiltInDefaults();
        }
    }

    public static int[] getDefaults(String configName, EncryptionKey[] keys) throws KrbException {
        int[] answer = EType.getDefaults(configName);
        if (answer == null) {
            throw new KrbException("No supported encryption types listed in " + configName);
        }
        ArrayList<Integer> list = new ArrayList<Integer>(answer.length);
        for (int i = 0; i < answer.length; ++i) {
            if (EncryptionKey.findKey(answer[i], keys) == null) continue;
            list.add(answer[i]);
        }
        int len = list.size();
        if (len <= 0) {
            StringBuffer keystr = new StringBuffer();
            for (int i = 0; i < keys.length; ++i) {
                keystr.append(EType.toString(keys[i].getEType()));
                keystr.append(" ");
            }
            throw new KrbException("Do not have keys of types listed in " + configName + " available; only have keys of following type: " + keystr.toString());
        }
        answer = new int[len];
        for (int i = 0; i < len; ++i) {
            answer[i] = (Integer)list.get(i);
        }
        return answer;
    }

    public static boolean isSupported(int eTypeConst, int[] config) {
        for (int i = 0; i < config.length; ++i) {
            if (eTypeConst != config[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(int eTypeConst) {
        int[] enabledETypes = EType.getBuiltInDefaults();
        return EType.isSupported(eTypeConst, enabledETypes);
    }

    public static String toString(int type) {
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 1: {
                return "DES CBC mode with CRC-32";
            }
            case 2: {
                return "DES CBC mode with MD4";
            }
            case 3: {
                return "DES CBC mode with MD5";
            }
            case 4: {
                return "reserved";
            }
            case 5: {
                return "DES3 CBC mode with MD5";
            }
            case 6: {
                return "reserved";
            }
            case 7: {
                return "DES3 CBC mode with SHA1";
            }
            case 9: {
                return "DSA with SHA1- Cms0ID";
            }
            case 10: {
                return "MD5 with RSA encryption - Cms0ID";
            }
            case 11: {
                return "SHA1 with RSA encryption - Cms0ID";
            }
            case 12: {
                return "RC2 CBC mode with Env0ID";
            }
            case 13: {
                return "RSA encryption with Env0ID";
            }
            case 14: {
                return "RSAES-0AEP-ENV-0ID";
            }
            case 15: {
                return "DES-EDE3-CBC-ENV-0ID";
            }
            case 16: {
                return "DES3 CBC mode with SHA1-KD";
            }
            case 17: {
                return "AES128 CTS mode with HMAC SHA1-96";
            }
            case 18: {
                return "AES256 CTS mode with HMAC SHA1-96";
            }
            case 23: {
                return "RC4 with HMAC";
            }
            case 24: {
                return "RC4 with HMAC EXP";
            }
        }
        return "Unknown (" + type + ")";
    }

    static {
        boolean allowed;
        block3: {
            DEBUG = Krb5.DEBUG;
            allowed = true;
            try {
                Config cfg = Config.getInstance();
                String temp = cfg.getDefault("allow_weak_crypto", "libdefaults");
                if (temp != null && temp.equals("false")) {
                    allowed = false;
                }
            }
            catch (Exception exc) {
                if (!DEBUG) break block3;
                System.out.println("Exception in getting allow_weak_crypto, using default value " + exc.getMessage());
            }
        }
        ALLOW_WEAK_CRYPTO = allowed;
        BUILTIN_ETYPES = new int[]{18, 17, 16, 23, 1, 3};
        BUILTIN_ETYPES_NOAES256 = new int[]{17, 16, 23, 1, 3};
    }
}

