/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

class ServiceFinder<T> {
    private final Set<T> services;

    ServiceFinder(String serviceName, ClassLoader loader) throws IOException {
        Enumeration<URL> urls;
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
            urls = ClassLoader.getSystemResources(serviceName);
        } else {
            urls = loader.getResources(serviceName);
        }
        List<String> classNames = ServiceFinder.readClassNames(urls);
        this.services = this.instantiateClasses(classNames, loader);
    }

    Collection<T> getServices() {
        return this.services;
    }

    private static List<String> readClassNames(Enumeration<URL> urls) {
        String encoding2 = System.getProperty("file.encoding");
        ArrayList<String> names2 = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                String line;
                url = urls.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), encoding2));
                while ((line = reader.readLine()) != null) {
                    if ((line = ServiceFinder.deleteComments(line)) == null) continue;
                    names2.add(line);
                }
            }
            catch (IOException e) {
                System.err.println("Failed to get a class name from " + url);
            }
        }
        return names2;
    }

    private static String deleteComments(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        if (line.length() < 1) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line, "#");
        return ((String)st.nextElement()).trim();
    }

    private Set<T> instantiateClasses(Collection<String> names2, ClassLoader loader) {
        HashSet instances = new HashSet(names2.size());
        for (String name2 : names2) {
            try {
                Class<?> clazz = Class.forName(name2, true, loader);
                instances.add(clazz.newInstance());
            }
            catch (ClassNotFoundException e) {
                System.err.println(name2 + " was not found");
            }
            catch (InstantiationException e) {
                System.err.println(name2 + " was not instantiated");
            }
            catch (IllegalAccessException e) {
                System.err.println(name2 + " committed illegal access");
            }
            catch (Throwable e) {
                System.err.println("failed to instantiate " + name2);
            }
        }
        return instances;
    }
}

