/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.PropertyPermission;

final class PropertyPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient Map perms = new HashMap(32);
    private boolean all_allowed = false;
    private static final long serialVersionUID = 7015263904581634791L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PropertyPermission pp = (PropertyPermission)permission;
        String propName = pp.getName();
        PropertyPermissionCollection propertyPermissionCollection = this;
        synchronized (propertyPermissionCollection) {
            PropertyPermission existing = (PropertyPermission)this.perms.get(propName);
            if (existing != null) {
                int newMask;
                int oldMask = existing.getMask();
                if (oldMask != (newMask = pp.getMask())) {
                    int effective = oldMask | newMask;
                    String actions2 = PropertyPermission.getActions(effective);
                    this.perms.put(propName, new PropertyPermission(propName, actions2));
                }
            } else {
                this.perms.put(propName, permission);
            }
        }
        if (!this.all_allowed && propName.equals("*")) {
            this.all_allowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        int last;
        PropertyPermission x;
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission pp = (PropertyPermission)permission;
        int desired = pp.getMask();
        int effective = 0;
        if (this.all_allowed) {
            PropertyPermissionCollection propertyPermissionCollection = this;
            synchronized (propertyPermissionCollection) {
                x = (PropertyPermission)this.perms.get("*");
            }
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
        }
        String name = pp.getName();
        PropertyPermissionCollection propertyPermissionCollection = this;
        synchronized (propertyPermissionCollection) {
            x = (PropertyPermission)this.perms.get(name);
        }
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            name = name.substring(0, last + 1) + "*";
            PropertyPermissionCollection propertyPermissionCollection2 = this;
            synchronized (propertyPermissionCollection2) {
                x = (PropertyPermission)this.perms.get(name);
            }
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        PropertyPermissionCollection propertyPermissionCollection = this;
        synchronized (propertyPermissionCollection) {
            return Collections.enumeration(this.perms.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable permissions = new Hashtable(this.perms.size() * 2);
        PropertyPermissionCollection propertyPermissionCollection = this;
        synchronized (propertyPermissionCollection) {
            permissions.putAll(this.perms);
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("all_allowed", this.all_allowed);
        pfields.put("permissions", permissions);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        this.all_allowed = gfields.get("all_allowed", false);
        Hashtable permissions = (Hashtable)gfields.get("permissions", null);
        this.perms = new HashMap(permissions.size() * 2);
        this.perms.putAll(permissions);
    }
}

