/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CreateIndexResponse
extends AcknowledgedResponse {
    private boolean shardsAcked;
    private String index;

    protected CreateIndexResponse() {
    }

    protected CreateIndexResponse(boolean acknowledged, boolean shardsAcked, String index) {
        super(acknowledged);
        assert (acknowledged || !shardsAcked);
        this.shardsAcked = shardsAcked;
        this.index = index;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.readAcknowledged(in);
        this.shardsAcked = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_5_6_0_UNRELEASED)) {
            this.index = in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeAcknowledged(out);
        out.writeBoolean(this.shardsAcked);
        if (out.getVersion().onOrAfter(Version.V_5_6_0_UNRELEASED)) {
            out.writeString(this.index);
        }
    }

    public boolean isShardsAcked() {
        return this.shardsAcked;
    }

    public String index() {
        return this.index;
    }

    public void addCustomFields(XContentBuilder builder) throws IOException {
        builder.field("shards_acknowledged", this.isShardsAcked());
        builder.field("index", this.index());
    }
}

