/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.transport.TransportAddress;

public final class LocalTransportAddress
implements TransportAddress {
    public static final short TYPE_ID = 2;
    private static final AtomicLong transportAddressIdGenerator = new AtomicLong();
    private String id;

    public static LocalTransportAddress buildUnique() {
        return new LocalTransportAddress(Long.toString(transportAddressIdGenerator.incrementAndGet()));
    }

    public LocalTransportAddress(String id) {
        this.id = id;
    }

    public LocalTransportAddress(StreamInput in) throws IOException {
        this.id = in.readString();
    }

    public LocalTransportAddress(StreamInput in, String hostString) throws IOException {
        this(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
    }

    public String id() {
        return this.id;
    }

    @Override
    public short uniqueAddressTypeId() {
        return 2;
    }

    @Override
    public boolean sameHost(TransportAddress other) {
        return other instanceof LocalTransportAddress && this.id.equals(((LocalTransportAddress)other).id);
    }

    @Override
    public boolean isLoopbackOrLinkLocalAddress() {
        return false;
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public String getAddress() {
        return "0.0.0.0";
    }

    @Override
    public int getPort() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransportAddress that = (LocalTransportAddress)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "local[" + this.id + "]";
    }
}

