/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class SimpleQueryParser
extends org.apache.lucene.queryparser.simple.SimpleQueryParser {
    private final Settings settings;
    private QueryShardContext context;

    public SimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags, Settings settings, QueryShardContext context) {
        super(analyzer, weights, flags);
        this.settings = settings;
        this.context = context;
    }

    private Query rethrowUnlessLenient(RuntimeException e) {
        if (this.settings.lenient()) {
            return null;
        }
        throw e;
    }

    protected Query newTermQuery(Term term) {
        MappedFieldType currentFieldType = this.context.fieldMapper(term.field());
        if (currentFieldType == null || currentFieldType.tokenized()) {
            return super.newTermQuery(term);
        }
        return currentFieldType.termQuery(term.bytes(), this.context);
    }

    public Query newDefaultQuery(String text) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                Query q = this.createBooleanQuery((String)entry.getKey(), text, super.getDefaultOperator());
                if (q == null) continue;
                bq.add(SimpleQueryParser.wrapWithBoost(q, ((Float)entry.getValue()).floatValue()), BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    public Query newFuzzyQuery(String text, int fuzziness) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            String fieldName = (String)entry.getKey();
            try {
                BytesRef term = this.getAnalyzer().normalize(fieldName, text);
                FuzzyQuery query = new FuzzyQuery(new Term(fieldName, term), fuzziness);
                bq.add(SimpleQueryParser.wrapWithBoost((Query)query, ((Float)entry.getValue()).floatValue()), BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    public Query newPhraseQuery(String text, int slop) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                String quoteField;
                MappedFieldType quotedFieldType;
                String field = (String)entry.getKey();
                if (this.settings.quoteFieldSuffix() != null && (quotedFieldType = this.context.fieldMapper(quoteField = field + this.settings.quoteFieldSuffix())) != null) {
                    field = quoteField;
                }
                Float boost = (Float)entry.getValue();
                Query q = this.createPhraseQuery(field, text, slop);
                if (q == null) continue;
                bq.add(SimpleQueryParser.wrapWithBoost(q, boost.floatValue()), BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    public Query newPrefixQuery(String text) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            String fieldName = (String)entry.getKey();
            try {
                if (this.settings.analyzeWildcard()) {
                    Query analyzedQuery = this.newPossiblyAnalyzedQuery(fieldName, text);
                    if (analyzedQuery == null) continue;
                    bq.add(SimpleQueryParser.wrapWithBoost(analyzedQuery, ((Float)entry.getValue()).floatValue()), BooleanClause.Occur.SHOULD);
                    continue;
                }
                Term term = new Term(fieldName, this.getAnalyzer().normalize(fieldName, text));
                PrefixQuery query = new PrefixQuery(term);
                bq.add(SimpleQueryParser.wrapWithBoost((Query)query, ((Float)entry.getValue()).floatValue()), BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                return this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
        assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
        try (TokenStream source = analyzer.tokenStream(field, queryText);){
            if (source.hasAttribute(DisableGraphAttribute.class)) {
                this.setEnableGraphQueries(false);
            }
            Query query = super.createFieldQuery(source, operator, field, quoted, phraseSlop);
            this.setEnableGraphQueries(true);
            Query query2 = query;
            return query2;
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    private static Query wrapWithBoost(Query query, float boost) {
        if (boost != 1.0f) {
            return new BoostQuery(query, boost);
        }
        return query;
    }

    private Query newPossiblyAnalyzedQuery(String field, String termStr) {
        ArrayList tlist = new ArrayList();
        try (TokenStream source = this.getAnalyzer().tokenStream(field, termStr);){
            source.reset();
            ArrayList<BytesRef> currentPos = new ArrayList<BytesRef>();
            CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posAtt = (PositionIncrementAttribute)source.addAttribute(PositionIncrementAttribute.class);
            try {
                boolean hasMoreTokens = source.incrementToken();
                while (hasMoreTokens) {
                    if (!currentPos.isEmpty() && posAtt.getPositionIncrement() > 0) {
                        tlist.add(currentPos);
                        currentPos = new ArrayList();
                    }
                    BytesRef term = this.getAnalyzer().normalize(field, termAtt.toString());
                    currentPos.add(term);
                    hasMoreTokens = source.incrementToken();
                }
                if (!currentPos.isEmpty()) {
                    tlist.add(currentPos);
                }
            }
            catch (IOException hasMoreTokens) {
                // empty catch block
            }
        }
        catch (IOException e) {
            return new PrefixQuery(new Term(field, termStr));
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1 && ((List)tlist.get(0)).size() == 1) {
            return new PrefixQuery(new Term(field, (BytesRef)((List)tlist.get(0)).get(0)));
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (int pos = 0; pos < tlist.size(); ++pos) {
            Object posQuery;
            boolean isLastPos;
            List plist = (List)tlist.get(pos);
            boolean bl = isLastPos = pos == tlist.size() - 1;
            if (plist.size() == 1) {
                posQuery = isLastPos ? new PrefixQuery(new Term(field, (BytesRef)plist.get(0))) : this.newTermQuery(new Term(field, (BytesRef)plist.get(0)));
            } else if (!isLastPos) {
                Term[] terms = new Term[plist.size()];
                for (int i = 0; i < plist.size(); ++i) {
                    terms[i] = new Term(field, (BytesRef)plist.get(i));
                }
                posQuery = new SynonymQuery(terms);
            } else {
                BooleanQuery.Builder innerBuilder = new BooleanQuery.Builder();
                for (BytesRef token : plist) {
                    innerBuilder.add(new BooleanClause((Query)new PrefixQuery(new Term(field, token)), BooleanClause.Occur.SHOULD));
                }
                posQuery = innerBuilder.setDisableCoord(true).build();
            }
            builder.add(new BooleanClause(posQuery, this.getDefaultOperator()));
        }
        return builder.build();
    }

    static class Settings {
        private boolean lenient = false;
        private boolean analyzeWildcard = false;
        private String quoteFieldSuffix = null;

        Settings() {
        }

        Settings(Settings other) {
            this.lenient = other.lenient;
            this.analyzeWildcard = other.analyzeWildcard;
            this.quoteFieldSuffix = other.quoteFieldSuffix;
        }

        public void lenient(boolean lenient) {
            this.lenient = lenient;
        }

        public boolean lenient() {
            return this.lenient;
        }

        public void analyzeWildcard(boolean analyzeWildcard) {
            this.analyzeWildcard = analyzeWildcard;
        }

        public boolean analyzeWildcard() {
            return this.analyzeWildcard;
        }

        public void quoteFieldSuffix(String suffix) {
            this.quoteFieldSuffix = suffix;
        }

        public String quoteFieldSuffix() {
            return this.quoteFieldSuffix;
        }

        public int hashCode() {
            return Objects.hash(this.lenient, this.analyzeWildcard, this.quoteFieldSuffix);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Settings other = (Settings)obj;
            return Objects.equals(this.lenient, other.lenient) && Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.quoteFieldSuffix, other.quoteFieldSuffix);
        }
    }
}

