/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmRuntimeTypes;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfiguration;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends KtVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet(KtTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create(KtTokens.PLUS, KtTokens.MINUS, KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.RANGE, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.IDENTIFIER));
    private final Map<String, Integer> anonymousSubclassesCount;
    private final Stack<ClassDescriptor> classStack;
    private final Stack<String> nameStack;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmRuntimeTypes runtimeTypes;
    private final JvmFileClassesProvider fileClassesProvider;
    private final TypeMappingConfiguration<Type> typeMappingConfiguration;
    private final boolean shouldInlineConstVals;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state2) {
        if (state2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        this.anonymousSubclassesCount = new HashMap<String, Integer>();
        this.classStack = new Stack();
        this.nameStack = new Stack();
        this.bindingTrace = state2.getBindingTrace();
        this.bindingContext = state2.getBindingContext();
        this.filter = state2.getGenerateDeclaredClassFilter();
        this.runtimeTypes = state2.getJvmRuntimeTypes();
        this.fileClassesProvider = state2.getFileClassesProvider();
        this.typeMappingConfiguration = state2.getTypeMapper().getTypeMappingConfiguration();
        this.shouldInlineConstVals = state2.getShouldInlineConstVals();
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        if (callableDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        if (supertypes2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        ClassDescriptor classDescriptor = this.recordClassForCallable(element, callableDescriptor, supertypes2, name, null);
        if (classDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        return classDescriptor;
    }

    @NotNull
    private ClassDescriptor recordClassForFunction(@NotNull KtElement element, @NotNull FunctionDescriptor functionDescriptor, @NotNull String name, @Nullable DeclarationDescriptor customContainer) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        if (functionDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        ClassDescriptor classDescriptor = this.recordClassForCallable(element, functionDescriptor, this.runtimeTypes.getSupertypesForClosure(functionDescriptor), name, customContainer);
        if (classDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(9);
        }
        return classDescriptor;
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name, @Nullable DeclarationDescriptor customContainer) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(10);
        }
        if (callableDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(11);
        }
        if (supertypes2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        String simpleName = name.substring(name.lastIndexOf(47) + 1);
        SyntheticClassDescriptorForLambda classDescriptor = new SyntheticClassDescriptorForLambda(customContainer != null ? customContainer : this.correctContainerForLambda(callableDescriptor, element), Name.special("<closure-" + simpleName + ">"), supertypes2, element);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_CALLABLE, callableDescriptor, classDescriptor);
        SyntheticClassDescriptorForLambda syntheticClassDescriptorForLambda = classDescriptor;
        if (syntheticClassDescriptorForLambda == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(14);
        }
        return syntheticClassDescriptorForLambda;
    }

    @NotNull
    private DeclarationDescriptor correctContainerForLambda(@NotNull CallableDescriptor descriptor2, @NotNull KtElement function2) {
        DeclarationDescriptor container2;
        if (descriptor2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(15);
        }
        if (function2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(16);
        }
        if ((container2 = descriptor2.getContainingDeclaration()) instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(container2.getContainingDeclaration())) {
            PsiElement element = function2;
            while (element != null) {
                KtElement child = element;
                if (this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element = element.getParent()) == container2) {
                    DeclarationDescriptor declarationDescriptor = container2;
                    if (declarationDescriptor == null) {
                        CodegenAnnotatingVisitor.$$$reportNull$$$0(17);
                    }
                    return declarationDescriptor;
                }
                if (!(element instanceof KtObjectDeclaration) || !(element.getParent() instanceof KtObjectLiteralExpression) || !(child instanceof KtSuperTypeList)) continue;
                container2 = container2.getContainingDeclaration().getContainingDeclaration();
            }
        }
        DeclarationDescriptor declarationDescriptor = container2;
        if (declarationDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(18);
        }
        return declarationDescriptor;
    }

    @NotNull
    private String inventAnonymousClassName() {
        String top = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        String string = top + "$" + (cnt + 1);
        if (string == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    public void visitKtElement(@NotNull KtElement element) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(20);
        }
        super.visitKtElement(element);
        element.acceptChildren(this);
    }

    @Override
    public void visitScript(@NotNull KtScript script) {
        if (script == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(21);
        }
        this.classStack.push(this.bindingContext.get(BindingContext.SCRIPT, script));
        this.nameStack.push(AsmUtil.internalNameByFqNameWithoutInnerClasses(script.getFqName()));
        script.acceptChildren(this);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitKtFile(@NotNull KtFile file) {
        if (file == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(22);
        }
        this.nameStack.push(AsmUtil.internalNameByFqNameWithoutInnerClasses(file.getPackageFqName()));
        file.acceptChildren(this);
        this.nameStack.pop();
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        if (enumEntry == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(23);
        }
        if (enumEntry.getDeclarations().isEmpty()) {
            for (KtSuperTypeListEntry specifier : enumEntry.getSuperTypeListEntries()) {
                specifier.accept(this);
            }
            return;
        }
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        if (descriptor2 == null) {
            return;
        }
        this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor2);
        super.visitEnumEntry(enumEntry);
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        if (declaration == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(24);
        }
        if (!this.filter.shouldAnnotateClass(declaration)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitObjectDeclaration(declaration);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitClass(@NotNull KtClass klass2) {
        if (klass2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(25);
        }
        if (!this.filter.shouldAnnotateClass(klass2)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass2);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitClass(klass2);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Name descriptorName = SpecialNames.safeIdentifier(classDescriptor.getName());
        if (DescriptorUtils.isTopLevelDeclaration(classDescriptor)) {
            return base.isEmpty() ? descriptorName.asString() : base + '/' + descriptorName;
        }
        return this.typeMappingConfiguration.getInnerClassNameFactory().invoke(base, descriptorName.asString());
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        KtObjectDeclaration object;
        ClassDescriptor classDescriptor;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(26);
        }
        if ((classDescriptor = this.bindingContext.get(BindingContext.CLASS, object = expression2.getObjectDeclaration())) == null) {
            super.visitObjectLiteralExpression(expression2);
            return;
        }
        String name = this.inventAnonymousClassName();
        this.recordClosure(classDescriptor, name);
        KtSuperTypeList delegationSpecifierList = object.getSuperTypeList();
        if (delegationSpecifierList != null) {
            delegationSpecifierList.accept(this);
        }
        this.classStack.push(classDescriptor);
        this.nameStack.push(CodegenBinding.getAsmType(this.bindingContext, classDescriptor).getInternalName());
        KtClassBody body = object.getBody();
        if (body != null) {
            super.visitClassBody(body);
        }
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        KtFunctionLiteral functionLiteral;
        FunctionDescriptor functionDescriptor;
        if (lambdaExpression == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(27);
        }
        if ((functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral = lambdaExpression.getFunctionLiteral())) == null) {
            return;
        }
        String name = this.inventAnonymousClassName();
        Collection<KotlinType> supertypes2 = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
        ClassDescriptor classDescriptor = this.recordClassForCallable(functionLiteral, functionDescriptor, supertypes2, name);
        MutableClosure closure = this.recordClosure(classDescriptor, name);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        if (CoroutineUtilKt.isSuspendLambda(functionDescriptor)) {
            closure.setSuspend(true);
            closure.setSuspendLambda();
        }
        super.visitLambdaExpression(lambdaExpression);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
        Collection<KotlinType> supertypes2;
        CallableDescriptor callableDescriptor;
        KotlinType receiverType;
        ResolvedCall<? extends CallableDescriptor> referencedFunction;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(28);
        }
        if ((referencedFunction = CallUtilKt.getResolvedCall(expression2.getCallableReference(), this.bindingContext)) == null) {
            return;
        }
        CallableDescriptor target = referencedFunction.getResultingDescriptor();
        KtExpression receiverExpression = expression2.getReceiverExpression();
        KotlinType kotlinType = receiverType = receiverExpression != null ? this.bindingContext.getType(receiverExpression) : null;
        if (target instanceof FunctionDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = this.runtimeTypes.getSupertypesForFunctionReference((FunctionDescriptor)target, receiverType != null);
        } else if (target instanceof PropertyDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = Collections.singleton(this.runtimeTypes.getSupertypeForPropertyReference((PropertyDescriptor)target, ReflectionTypes.Companion.isNumberedKMutablePropertyType(callableDescriptor.getReturnType()), receiverType != null));
        } else {
            return;
        }
        String name = this.inventAnonymousClassName();
        ClassDescriptor classDescriptor = this.recordClassForCallable(expression2, callableDescriptor, supertypes2, name);
        MutableClosure closure = this.recordClosure(classDescriptor, name);
        if (receiverType != null) {
            closure.setCaptureReceiverType(receiverType);
        }
        super.visitCallableReferenceExpression(expression2);
    }

    @NotNull
    private MutableClosure recordClosure(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(29);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(30);
        }
        MutableClosure mutableClosure = CodegenBinding.recordClosure(this.bindingTrace, classDescriptor, CodegenAnnotatingVisitor.peekFromStack(this.classStack), Type.getObjectType(name));
        if (mutableClosure == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(31);
        }
        return mutableClosure;
    }

    private void recordLocalVariablePropertyMetadata(LocalVariableDescriptor variableDescriptor) {
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(variableDescriptor, this.bindingContext);
        if (delegateType == null) {
            return;
        }
        LocalVariableDescriptor metadataVariableDescriptor = new LocalVariableDescriptor(variableDescriptor.getContainingDeclaration(), Annotations.Companion.getEMPTY(), Name.identifier(variableDescriptor.getName().asString() + "$metadata"), ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(variableDescriptor)), false, false, SourceElement.NO_SOURCE);
        this.bindingTrace.record(CodegenBinding.LOCAL_VARIABLE_PROPERTY_METADATA, variableDescriptor, metadataVariableDescriptor);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        String nameForClassOrPackageMember;
        DeclarationDescriptor descriptor2;
        if (property == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(32);
        }
        if ((descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property)) == null) {
            return;
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            this.recordLocalVariablePropertyMetadata((LocalVariableDescriptor)descriptor2);
        }
        if ((nameForClassOrPackageMember = this.getNameForClassOrPackageMember(descriptor2)) != null) {
            this.nameStack.push(nameForClassOrPackageMember);
        } else {
            this.nameStack.push(CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + '$' + SpecialNames.safeIdentifier(property.getNameAsSafeName()).asString());
        }
        KtPropertyDelegate delegate2 = property.getDelegate();
        if (delegate2 != null && descriptor2 instanceof VariableDescriptorWithAccessors) {
            VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
            String name = this.inventAnonymousClassName();
            KotlinType supertype = this.runtimeTypes.getSupertypeForPropertyReference(variableDescriptor, variableDescriptor.isVar(), false);
            ClassDescriptor classDescriptor = this.recordClassForCallable(delegate2, variableDescriptor, Collections.singleton(supertype), name);
            this.recordClosure(classDescriptor, name);
            Type containerType = this.getMetadataOwner(property);
            List<VariableDescriptorWithAccessors> descriptors = this.bindingTrace.get(CodegenBinding.DELEGATED_PROPERTIES, containerType);
            if (descriptors == null) {
                descriptors = new ArrayList<VariableDescriptorWithAccessors>(1);
                this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTIES, containerType, descriptors);
            }
            descriptors.add(variableDescriptor);
            this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, variableDescriptor, containerType);
        }
        super.visitProperty(property);
        this.nameStack.pop();
    }

    @NotNull
    private Type getMetadataOwner(@NotNull KtProperty property) {
        if (property == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(33);
        }
        for (int i = this.classStack.size() - 1; i >= 0; --i) {
            ClassDescriptor descriptor2 = (ClassDescriptor)this.classStack.get(i);
            if (descriptor2 instanceof SyntheticClassDescriptorForLambda) continue;
            ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
            Type type2 = classId != null ? AsmUtil.asmTypeByClassId(classId) : CodegenBinding.getAsmType(this.bindingContext, descriptor2);
            if (type2 == null) {
                CodegenAnnotatingVisitor.$$$reportNull$$$0(34);
            }
            return type2;
        }
        Type type3 = Type.getObjectType(FileClasses.getFileClassInternalName(this.fileClassesProvider, property.getContainingKtFile()));
        if (type3 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(35);
        }
        return type3;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        FunctionDescriptor functionDescriptor;
        if (function2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(36);
        }
        if ((functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2)) == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor);
        if (functionDescriptor instanceof SimpleFunctionDescriptor && functionDescriptor.isSuspend()) {
            SimpleFunctionDescriptor jvmSuspendFunctionView = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView((SimpleFunctionDescriptor)functionDescriptor);
            for (Pair<ValueParameterDescriptor, ValueParameterDescriptor> parameterDescriptorPair : CollectionsKt.zip(functionDescriptor.getValueParameters(), jvmSuspendFunctionView.getValueParameters())) {
                this.bindingTrace.record(CodegenBinding.PARAMETER_SYNONYM, parameterDescriptorPair.getFirst(), parameterDescriptorPair.getSecond());
            }
            this.bindingTrace.record(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor, jvmSuspendFunctionView);
            if (nameForClassOrPackageMember != null) {
                this.nameStack.push(nameForClassOrPackageMember);
            }
            String name = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor = this.recordClassForFunction(function2, functionDescriptor, name, functionDescriptor);
            MutableClosure closure = this.recordClosure(classDescriptor, name);
            closure.setSuspend(true);
            super.visitNamedFunction(function2);
            if (nameForClassOrPackageMember != null) {
                this.nameStack.pop();
            }
            return;
        }
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push(nameForClassOrPackageMember);
            super.visitNamedFunction(function2);
            this.nameStack.pop();
        } else {
            String name = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor = this.recordClassForFunction(function2, functionDescriptor, name, null);
            this.recordClosure(classDescriptor, name);
            this.classStack.push(classDescriptor);
            this.nameStack.push(name);
            super.visitNamedFunction(function2);
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(37);
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        String peek = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        String name = SpecialNames.safeIdentifier(descriptor2.getName()).asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            assert (containingFile != null) : "File not found for " + descriptor2;
            return FileClasses.getFileClassInternalName(this.fileClassesProvider, containingFile) + '$' + name;
        }
        return null;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(38);
        }
        super.visitCallExpression(expression2);
        this.checkSamCall(expression2);
    }

    private void checkSamCall(@NotNull KtCallElement expression2) {
        ResolvedCall<? extends CallableDescriptor> call2;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(39);
        }
        if ((call2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext)) == null) {
            return;
        }
        CallableDescriptor descriptor2 = call2.getResultingDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        this.recordSamConstructorIfNeeded(expression2, call2);
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor2);
        if (original == null) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call2.getValueArgumentsByIndex();
        if (valueArguments2 == null) {
            return;
        }
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            SamType samType = SamType.create(TypeMapperUtilsKt.removeExternalProjections(valueParameter.getType()));
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments2.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
        }
    }

    @Override
    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(40);
        }
        super.visitSuperTypeCallEntry(call2);
        this.checkSamCall(call2);
    }

    private void recordSamConstructorIfNeeded(@NotNull KtCallElement expression2, @NotNull ResolvedCall<?> call2) {
        Object callableDescriptor;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(41);
        }
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(42);
        }
        if (!((callableDescriptor = call2.getResultingDescriptor()).getOriginal() instanceof SamConstructorDescriptor)) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call2.getValueArgumentsByIndex();
        if (valueArguments2 == null || valueArguments2.size() != 1) {
            return;
        }
        ResolvedValueArgument valueArgument = valueArguments2.get(0);
        if (!(valueArgument instanceof ExpressionValueArgument)) {
            return;
        }
        ValueArgument argument = ((ExpressionValueArgument)valueArgument).getValueArgument();
        if (argument == null) {
            return;
        }
        KtExpression argumentExpression = argument.getArgumentExpression();
        this.bindingTrace.record(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2, argumentExpression);
        SamType samType = SamType.create(callableDescriptor.getReturnType());
        this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(43);
        }
        super.visitBinaryExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        SamType samType = SamType.create(original.getValueParameters().get(0).getType());
        if (samType == null) {
            return;
        }
        IElementType token = expression2.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getRight(), samType);
        } else if (token == KtTokens.IN_KEYWORD || token == KtTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getLeft(), samType);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(44);
        }
        super.visitArrayAccessExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List<KtExpression> indexExpressions = expression2.getIndexExpressions();
        List<ValueParameterDescriptor> parameters2 = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters2) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters2.size() - 1) {
                PsiElement parent2 = expression2.getParent();
                if (!(parent2 instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.EQ) continue;
                KtExpression right = ((KtBinaryExpression)parent2).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            KtExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(45);
        }
        super.visitWhenExpression(expression2);
        if (!this.isWhenWithEnums(expression2)) {
            return;
        }
        String currentClassName = this.getCurrentTopLevelClassOrPackagePartInternalName(expression2.getContainingKtFile());
        if (this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName) == null) {
            this.bindingTrace.record(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName, new ArrayList(1));
        }
        List<WhenByEnumsMapping> mappings = this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName);
        assert (mappings != null) : "guaranteed by contract";
        int fieldNumber = mappings.size();
        assert (expression2.getSubjectExpression() != null) : "subject expression should be not null in a valid when by enums";
        KotlinType type2 = WhenChecker.whenSubjectType(expression2, this.bindingContext);
        assert (type2 != null) : "should not be null in a valid when by enums";
        ClassDescriptor classDescriptor = (ClassDescriptor)type2.getConstructor().getDeclarationDescriptor();
        assert (classDescriptor != null) : "because it's enum";
        WhenByEnumsMapping mapping2 = new WhenByEnumsMapping(classDescriptor, currentClassName, fieldNumber);
        for (ConstantValue<?> constant : SwitchCodegenUtil.getAllConstants(expression2, this.bindingContext, this.shouldInlineConstVals)) {
            if (constant instanceof NullValue) continue;
            assert (constant instanceof EnumValue) : "expression in when should be EnumValue";
            mapping2.putFirstTime((EnumValue)constant, mapping2.size() + 1);
        }
        mappings.add(mapping2);
        this.bindingTrace.record(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression2, mapping2);
    }

    private boolean isWhenWithEnums(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(46);
        }
        return WhenChecker.isWhenByEnum(expression2, this.bindingContext) && SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression2, this.bindingContext, this.shouldInlineConstVals, constant -> constant instanceof EnumValue || constant instanceof NullValue);
    }

    @NotNull
    private String getCurrentTopLevelClassOrPackagePartInternalName(@NotNull KtFile file) {
        if (file == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(47);
        }
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptor previous = (ClassDescriptor)iterator2.previous();
            if (!DescriptorUtils.isTopLevelOrInnerClass(previous)) continue;
            String string = CodegenBinding.getAsmType(this.bindingContext, previous).getInternalName();
            if (string == null) {
                CodegenAnnotatingVisitor.$$$reportNull$$$0(48);
            }
            return string;
        }
        String string = FileClasses.getFacadeClassInternalName(this.fileClassesProvider, file);
        if (string == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static <T> T peekFromStack(@NotNull Stack<T> stack) {
        if (stack == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(50);
        }
        return stack.empty() ? null : (T)stack.peek();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 31: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 31: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableDescriptor";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypes";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 31: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 15: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 22: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumEntry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 26: 
            case 28: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor";
                break;
            }
            case 5: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "recordClassForCallable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "recordClassForFunction";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "correctContainerForLambda";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "inventAnonymousClassName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "recordClosure";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataOwner";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTopLevelClassOrPackagePartInternalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "recordClassForCallable";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 31: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "recordClassForFunction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "correctContainerForLambda";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitKtElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitScript";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitKtFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumEntry";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectDeclaration";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "recordClosure";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getMetadataOwner";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNameForClassOrPackageMember";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkSamCall";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperTypeCallEntry";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "recordSamConstructorIfNeeded";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isWhenWithEnums";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTopLevelClassOrPackagePartInternalName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "peekFromStack";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 31: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

