/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Extension;
import com.ibm.xmi.framework.Value;
import com.ibm.xmi.framework.XMIObject;
import com.ibm.xmi.framework.XMLElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class XMIContainer {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ArrayList objects;
    protected ArrayList topObjects = new ArrayList();
    protected HashMap nameToElement;
    protected HashMap uuidToData;
    protected HashSet objectsSet;
    protected HashSet uuidObjects;

    public XMIContainer(Iterator iterator) {
        while (iterator.hasNext()) {
            this.topObjects.add(iterator.next());
        }
        this.objects = new ArrayList();
        this.objectsSet = new HashSet();
        this.uuidObjects = new HashSet();
    }

    public void add(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.topObjects.add(e);
                arrayList.add(e);
            }
        }
        if (this.nameToElement != null) {
            this.addObjectsToNameHash(arrayList);
        }
        if (this.uuidToData != null) {
            this.addObjectsToUUIDHash(arrayList);
        }
    }

    private void addObjectToNameHash(XMIObject xMIObject) {
        if (this.objectsSet.contains(xMIObject)) {
            return;
        }
        this.objectsSet.add(xMIObject);
        this.objects.add(xMIObject);
        this.addToNameHashtable(xMIObject);
        if (!xMIObject.isXMIProxy()) {
            Iterator iterator = xMIObject.getXMIValues().iterator();
            while (iterator.hasNext()) {
                Value value = (Value)iterator.next();
                this.addToNameHashtable(value);
                int n = value.getXMIType();
                if (n != 8 && n != 4 || value.getXMIValue() == null) continue;
                if (value.getXMIValue() instanceof XMIObject) {
                    this.addObjectToNameHash((XMIObject)value.getXMIValue());
                    continue;
                }
                if (!(value.getXMIValue() instanceof Collection)) continue;
                Iterator iterator2 = ((Collection)value.getXMIValue()).iterator();
                while (iterator2.hasNext()) {
                    this.addObjectToNameHash((XMIObject)iterator2.next());
                }
            }
        }
    }

    private void addObjectToUUIDHash(XMIObject xMIObject) {
        if (this.uuidObjects.contains(xMIObject)) {
            return;
        }
        this.uuidObjects.add(xMIObject);
        this.addToUUIDHashtable(xMIObject);
        if (!xMIObject.isXMIProxy()) {
            Iterator iterator = xMIObject.getXMIValues().iterator();
            while (iterator.hasNext()) {
                Value value = (Value)iterator.next();
                if (value.getXMIType() != 8 && value.getXMIType() != 4 || value.getXMIValue() == null) continue;
                if (value.getXMIValue() instanceof XMIObject) {
                    this.addObjectToUUIDHash((XMIObject)value.getXMIValue());
                    continue;
                }
                if (!(value.getXMIValue() instanceof Collection)) continue;
                Iterator iterator2 = ((Collection)value.getXMIValue()).iterator();
                while (iterator2.hasNext()) {
                    this.addObjectToUUIDHash((XMIObject)iterator2.next());
                }
            }
        }
    }

    private void addObjectsToNameHash(ArrayList arrayList) {
        if (arrayList != null) {
            if (this.nameToElement == null) {
                this.nameToElement = new HashMap();
            }
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                this.addObjectToNameHash((XMIObject)iterator.next());
            }
        }
    }

    private void addObjectsToUUIDHash(ArrayList arrayList) {
        if (arrayList != null) {
            if (this.uuidToData == null) {
                this.uuidToData = new HashMap();
            }
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                this.addObjectToUUIDHash((XMIObject)iterator.next());
            }
        }
    }

    private void addToNameHashtable(Data data) {
        String string = data.getXMIName();
        if (string != null) {
            ArrayList<Data> arrayList = (ArrayList<Data>)this.nameToElement.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Data>();
                this.nameToElement.put(string, arrayList);
            }
            if (!arrayList.contains(data)) {
                arrayList.add(data);
            }
        }
    }

    private void addToUUIDHashtable(XMIObject xMIObject) {
        String string = xMIObject.getXMIUUID();
        if (string != null && this.uuidToData.get(string) == null) {
            this.uuidToData.put(string, xMIObject);
        }
    }

    public XMIObject get(String string) {
        if (string == null) {
            return null;
        }
        if (this.uuidToData == null && this.topObjects.size() == 0) {
            return null;
        }
        if (this.uuidToData == null && this.topObjects.size() > 0) {
            this.addObjectsToUUIDHash(this.topObjects);
        }
        return (XMIObject)this.uuidToData.get(string);
    }

    public Collection getData(String string) {
        ArrayList arrayList;
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.nameToElement == null && this.topObjects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.nameToElement == null && this.topObjects.size() > 0) {
            this.addObjectsToNameHash(this.topObjects);
        }
        if ((arrayList = (ArrayList)this.nameToElement.get(string)) == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection getObjects() {
        if (this.nameToElement == null) {
            this.addObjectsToNameHash(this.topObjects);
        }
        if (this.objects == null || this.objects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.objects);
    }

    public Collection getTopObjects() {
        if (this.topObjects == null || this.topObjects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.topObjects);
    }

    private String printObject(XMIObject xMIObject, int n) {
        Object object;
        Iterator iterator;
        Iterator iterator2;
        String string = "";
        while (string.length() < n) {
            string = string + " ";
        }
        if (xMIObject == null) {
            return string + "null\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("Object: ");
        stringBuffer.append(xMIObject.getXMIName());
        stringBuffer.append(" id: ");
        stringBuffer.append(xMIObject.getXMIId());
        stringBuffer.append("\n");
        if (xMIObject.getXMILabel() != null) {
            stringBuffer.append(string);
            stringBuffer.append("  label:   ");
            stringBuffer.append(xMIObject.getXMILabel());
            stringBuffer.append("\n");
        }
        if (xMIObject.getXMIUUID() != null) {
            stringBuffer.append(string);
            stringBuffer.append("  uuid:    ");
            stringBuffer.append(xMIObject.getXMIUUID());
            stringBuffer.append("\n");
        }
        if (xMIObject.getXMIHref() != null) {
            stringBuffer.append(string);
            stringBuffer.append("  href:    ");
            stringBuffer.append(xMIObject.getXMIHref());
            stringBuffer.append("\n");
        }
        if (xMIObject.getXMIDefiner() != null) {
            stringBuffer.append(string);
            stringBuffer.append("  definer: ");
            stringBuffer.append(xMIObject.getXMIDefiner());
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("  isProxy: ");
        stringBuffer.append(xMIObject.isXMIProxy());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        if (xMIObject.getXMINamespace() != null) {
            stringBuffer.append("  namespace: ");
            stringBuffer.append(xMIObject.getXMINamespace());
            stringBuffer.append("\n");
        }
        Iterator iterator3 = null;
        iterator3 = !xMIObject.isXMIProxy() ? xMIObject.getXMISets().iterator() : Collections.EMPTY_LIST.iterator();
        if (iterator3.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("  Tag values:\n");
        }
        while (iterator3.hasNext()) {
            iterator2 = iterator3.next();
            iterator = xMIObject.getXMITags((String)((Object)iterator2)).iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(string);
                stringBuffer.append("    set: '");
                stringBuffer.append(iterator2);
                stringBuffer.append("' tag: '");
                stringBuffer.append(object);
                stringBuffer.append("' value: '");
                stringBuffer.append(xMIObject.getXMITagValue((String)((Object)iterator2), (String)object));
                stringBuffer.append("'\n");
            }
        }
        iterator2 = Collections.EMPTY_LIST.iterator();
        if (!xMIObject.isXMIProxy()) {
            iterator2 = xMIObject.getXMIValues().iterator();
        }
        if (iterator2.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("  Values:\n");
        }
        while (iterator2.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("    ");
            stringBuffer.append(iterator2.next());
            stringBuffer.append("\n");
        }
        iterator = null;
        iterator = !xMIObject.isXMIProxy() ? xMIObject.getXMIExtensions().iterator() : Collections.EMPTY_LIST.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("  Extensions:\n");
        }
        while (iterator.hasNext()) {
            object = (Extension)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append("    extender: '");
            stringBuffer.append(object.getXMIExtender());
            stringBuffer.append("' extenderID: '");
            stringBuffer.append(object.getXMIExtenderID());
            stringBuffer.append("'\n");
            Iterator iterator4 = object.getXMIContents().iterator();
            if (!iterator4.hasNext()) continue;
            stringBuffer.append(string);
            stringBuffer.append("      contents:\n");
            while (iterator4.hasNext()) {
                Object e = iterator4.next();
                if (e instanceof XMIObject) {
                    stringBuffer.append(this.printObject((XMIObject)e, n + 8));
                    continue;
                }
                if (!(e instanceof XMLElement)) continue;
                stringBuffer.append(this.printXMLElement((XMLElement)e, n + 8));
            }
            stringBuffer.append(string);
            stringBuffer.append("      end contents:\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("End object: ");
        stringBuffer.append(xMIObject.getXMIName());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String printXMLElement(XMLElement xMLElement, int n) {
        Object object;
        String string = "";
        while (string.length() < n) {
            string = string + " ";
        }
        String string2 = string + "XML element tag: " + xMLElement.getXMIName() + "\n";
        Iterator iterator = xMLElement.getXMIAttribs().iterator();
        if (!iterator.hasNext()) {
            string2 = string2 + string + "  attribs: []\n";
        } else {
            object = "";
            while (iterator.hasNext()) {
                if (!((String)object).equals("")) {
                    object = (String)object + " ";
                }
                object = (String)object + iterator.next() + "," + "\"" + iterator.next() + "\"";
            }
            string2 = string2 + string + "  attribs: [" + (String)object + "]\n";
        }
        object = xMLElement.getXMIContents().iterator();
        if (!object.hasNext()) return string2;
        string2 = string2 + string + "  contents:\n";
        while (object.hasNext()) {
            Object e = object.next();
            string2 = e instanceof XMLElement ? string2 + this.printXMLElement((XMLElement)e, n + 4) : string2 + string + "    '" + e + "'\n";
        }
        return string2 + string + "  end contents:\n";
    }

    public String toString() {
        if (this.topObjects == null) {
            return "empty";
        }
        String string = "--------------------------------\n";
        if (this.nameToElement == null) {
            this.addObjectsToNameHash(this.topObjects);
        }
        Iterator iterator = ((AbstractList)this.objects).iterator();
        while (iterator.hasNext()) {
            string = string + this.printObject((XMIObject)iterator.next(), 0);
            string = string + "--------------------------------\n";
        }
        return string;
    }
}

