/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XVerticalScrollbar;
import sun.awt.X11.XWindow;
import sun.util.logging.PlatformLogger;

public class ListHelper
implements XScrollbarClient {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.ListHelper");
    private final int FOCUS_INSET = 1;
    private final int BORDER_WIDTH;
    private final int ITEM_MARGIN;
    private final int TEXT_SPACE;
    private final int SCROLLBAR_WIDTH;
    private List items;
    private List selected;
    private boolean multiSelect;
    private int focusedIndex;
    private int maxVisItems;
    private XVerticalScrollbar vsb;
    private boolean vsbVis;
    private XHorizontalScrollbar hsb;
    private boolean hsbVis;
    private Font font;
    private FontMetrics fm;
    private XWindow peer;
    private Color[] colors;
    boolean mouseDraggedOutVertically = false;
    private volatile boolean vsbVisibilityChanged = false;

    public ListHelper(XWindow peer, Color[] colors, int initialSize, boolean multiSelect, boolean scrollVert, boolean scrollHoriz, Font font, int maxVisItems, int SPACE, int MARGIN, int BORDER, int SCROLLBAR) {
        this.peer = peer;
        this.colors = colors;
        this.multiSelect = multiSelect;
        this.items = new ArrayList(initialSize);
        this.selected = new ArrayList(1);
        this.selected.add(-1);
        this.maxVisItems = maxVisItems;
        if (scrollVert) {
            this.vsb = new XVerticalScrollbar(this);
            this.vsb.setValues(0, 0, 0, 0, 1, maxVisItems - 1);
        }
        if (scrollHoriz) {
            this.hsb = new XHorizontalScrollbar(this);
            this.hsb.setValues(0, 0, 0, 0, 1, 1);
        }
        this.setFont(font);
        this.TEXT_SPACE = SPACE;
        this.ITEM_MARGIN = MARGIN;
        this.BORDER_WIDTH = BORDER;
        this.SCROLLBAR_WIDTH = SCROLLBAR;
    }

    @Override
    public Component getEventSource() {
        return this.peer.getEventSource();
    }

    public void add(String item) {
        this.items.add(item);
        this.updateScrollbars();
    }

    public void add(String item, int index) {
        this.items.add(index, item);
        this.updateScrollbars();
    }

    public void remove(String item) {
        this.items.remove(item);
        this.updateScrollbars();
    }

    public void remove(int index) {
        this.items.remove(index);
        this.updateScrollbars();
    }

    public void removeAll() {
        this.items.removeAll(this.items);
        this.updateScrollbars();
    }

    public void setMultiSelect(boolean ms) {
        this.multiSelect = ms;
    }

    public void select(int index) {
        if (index > this.getItemCount() - 1) {
            int n = index = this.isEmpty() ? -1 : 0;
        }
        if (this.multiSelect) {
            assert (false) : "Implement ListHelper.select() for multiselect";
        } else if (this.getSelectedIndex() != index) {
            this.selected.remove(0);
            this.selected.add(index);
            this.makeVisible(index);
        }
    }

    public void deselect(int index) {
        assert (false);
    }

    public int getSelectedIndex() {
        if (!this.multiSelect) {
            Integer val = (Integer)this.selected.get(0);
            return val;
        }
        return -1;
    }

    int[] getSelectedIndexes() {
        assert (false);
        return null;
    }

    public boolean checkVsbVisibilityChangedAndReset() {
        boolean returnVal = this.vsbVisibilityChanged;
        this.vsbVisibilityChanged = false;
        return returnVal;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItem(int index) {
        return (String)this.items.get(index);
    }

    public void setFocusedIndex(int index) {
        this.focusedIndex = index;
    }

    public boolean isFocusedIndex(int index) {
        return index == this.focusedIndex;
    }

    public void setFont(Font newFont) {
        if (newFont != this.font) {
            this.font = newFont;
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        }
    }

    public int getMaxItemWidth() {
        int m = 0;
        int end = this.getItemCount();
        for (int i = 0; i < end; ++i) {
            int l = this.fm.stringWidth(this.getItem(i));
            m = Math.max(m, l);
        }
        return m;
    }

    int getItemHeight() {
        return this.fm.getHeight() + 2 * this.TEXT_SPACE;
    }

    public int y2index(int y) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("y=" + y + ", firstIdx=" + this.firstDisplayedIndex() + ", itemHeight=" + this.getItemHeight() + ",item_margin=" + this.ITEM_MARGIN);
        }
        int newIdx = this.firstDisplayedIndex() + (y - 2 * this.ITEM_MARGIN) / (this.getItemHeight() + 2 * this.ITEM_MARGIN);
        return newIdx;
    }

    public int firstDisplayedIndex() {
        if (this.vsbVis) {
            return this.vsb.getValue();
        }
        return 0;
    }

    public int lastDisplayedIndex() {
        if (this.hsbVis) assert (false) : "Implement for horiz scroll bar";
        return this.vsbVis ? this.vsb.getValue() + this.maxVisItems - 1 : this.getItemCount() - 1;
    }

    public void makeVisible(int index) {
        if (this.vsbVis) {
            if (index < this.firstDisplayedIndex()) {
                this.vsb.setValue(index);
            } else if (index > this.lastDisplayedIndex()) {
                this.vsb.setValue(index - this.maxVisItems + 1);
            }
        }
    }

    public void up() {
        int curIdx = this.getSelectedIndex();
        int numItems = this.getItemCount();
        assert (curIdx >= 0);
        int newIdx = curIdx == 0 ? numItems - 1 : --curIdx;
        this.select(newIdx);
    }

    public void down() {
        int newIdx = (this.getSelectedIndex() + 1) % this.getItemCount();
        this.select(newIdx);
    }

    public void pageUp() {
        if (this.vsbVis && this.firstDisplayedIndex() > 0) {
            if (this.multiSelect) {
                assert (false) : "Implement pageUp() for multiSelect";
            } else {
                int selectionOffset = this.getSelectedIndex() - this.firstDisplayedIndex();
                int newIdx = this.firstDisplayedIndex() - this.vsb.getBlockIncrement();
                this.vsb.setValue(newIdx);
                this.select(this.firstDisplayedIndex() + selectionOffset);
            }
        }
    }

    public void pageDown() {
        if (this.vsbVis && this.lastDisplayedIndex() < this.getItemCount() - 1) {
            if (this.multiSelect) {
                assert (false) : "Implement pageDown() for multiSelect";
            } else {
                int selectionOffset = this.getSelectedIndex() - this.firstDisplayedIndex();
                int newIdx = this.lastDisplayedIndex();
                this.vsb.setValue(newIdx);
                this.select(this.firstDisplayedIndex() + selectionOffset);
            }
        }
    }

    public void home() {
    }

    public void end() {
    }

    public boolean isVSBVisible() {
        return this.vsbVis;
    }

    public boolean isHSBVisible() {
        return this.hsbVis;
    }

    public XVerticalScrollbar getVSB() {
        return this.vsb;
    }

    public XHorizontalScrollbar getHSB() {
        return this.hsb;
    }

    public boolean isInVertSB(Rectangle bounds, int x, int y) {
        if (this.vsbVis) {
            assert (this.vsb != null) : "Vert scrollbar is visible, yet is null?";
            int sbHeight = this.hsbVis ? bounds.height - this.SCROLLBAR_WIDTH : bounds.height;
            return x <= bounds.width && x >= bounds.width - this.SCROLLBAR_WIDTH && y >= 0 && y <= sbHeight;
        }
        return false;
    }

    public boolean isInHorizSB(Rectangle bounds, int x, int y) {
        if (this.hsbVis) {
            assert (this.hsb != null) : "Horiz scrollbar is visible, yet is null?";
            int sbWidth = this.vsbVis ? bounds.width - this.SCROLLBAR_WIDTH : bounds.width;
            return x <= sbWidth && x >= 0 && y >= bounds.height - this.SCROLLBAR_WIDTH && y <= bounds.height;
        }
        return false;
    }

    public void handleVSBEvent(MouseEvent e, Rectangle bounds, int x, int y) {
        int sbHeight = this.hsbVis ? bounds.height - this.SCROLLBAR_WIDTH : bounds.height;
        this.vsb.handleMouseEvent(e.getID(), e.getModifiers(), x - (bounds.width - this.SCROLLBAR_WIDTH), y);
    }

    void updateScrollbars() {
        boolean oldVsbVis = this.vsbVis;
        boolean bl = this.vsbVis = this.vsb != null && this.items.size() > this.maxVisItems;
        if (this.vsbVis) {
            this.vsb.setValues(this.vsb.getValue(), this.getNumItemsDisplayed(), this.vsb.getMinimum(), this.items.size());
        }
        this.vsbVisibilityChanged = this.vsbVis != oldVsbVis;
    }

    public int getNumItemsDisplayed() {
        return this.items.size() > this.maxVisItems ? this.maxVisItems : this.items.size();
    }

    @Override
    public void repaintScrollbarRequest(XScrollbar sb) {
        Graphics g = this.peer.getGraphics();
        Rectangle bounds = this.peer.getBounds();
        if (sb == this.vsb && this.vsbVis) {
            this.paintVSB(g, XComponentPeer.getSystemColors(), bounds);
        } else if (sb == this.hsb && this.hsbVis) {
            this.paintHSB(g, XComponentPeer.getSystemColors(), bounds);
        }
        g.dispose();
    }

    @Override
    public void notifyValue(XScrollbar obj, int type, int v, boolean isAdjusting) {
        if (obj == this.vsb) {
            boolean needRepaint;
            int oldScrollValue = this.vsb.getValue();
            this.vsb.setValue(v);
            boolean bl = needRepaint = oldScrollValue != this.vsb.getValue();
            if (this.mouseDraggedOutVertically) {
                int oldItemValue = this.getSelectedIndex();
                int newItemValue = this.getSelectedIndex() + v - oldScrollValue;
                this.select(newItemValue);
                needRepaint = needRepaint || this.getSelectedIndex() != oldItemValue;
            }
            Graphics g = this.peer.getGraphics();
            Rectangle bounds = this.peer.getBounds();
            int first = v;
            int last = Math.min(this.getItemCount() - 1, v + this.maxVisItems);
            if (needRepaint) {
                this.paintItems(g, this.colors, bounds, first, last);
            }
            g.dispose();
        } else if ((XHorizontalScrollbar)obj == this.hsb) {
            this.hsb.setValue(v);
        }
    }

    public void updateColors(Color[] newColors) {
        this.colors = newColors;
    }

    public void paintItems(Graphics g, Color[] colors, Rectangle bounds) {
    }

    public void paintAllItems(Graphics g, Color[] colors, Rectangle bounds) {
        this.paintItems(g, colors, bounds, this.firstDisplayedIndex(), this.lastDisplayedIndex());
    }

    public void paintItems(Graphics g, Color[] colors, Rectangle bounds, int first, int last) {
        this.peer.flush();
        int x = this.BORDER_WIDTH + this.ITEM_MARGIN;
        int width = bounds.width - 2 * this.ITEM_MARGIN - 2 * this.BORDER_WIDTH - (this.vsbVis ? this.SCROLLBAR_WIDTH : 0);
        int height = this.getItemHeight();
        int y = this.BORDER_WIDTH + this.ITEM_MARGIN;
        for (int i = first; i <= last; ++i) {
            this.paintItem(g, colors, this.getItem(i), x, y, width, height, this.isItemSelected(i), this.isFocusedIndex(i));
            y += height + 2 * this.ITEM_MARGIN;
        }
        if (this.vsbVis) {
            this.paintVSB(g, XComponentPeer.getSystemColors(), bounds);
        }
        if (this.hsbVis) {
            this.paintHSB(g, XComponentPeer.getSystemColors(), bounds);
        }
        this.peer.flush();
    }

    public void paintItem(Graphics g, Color[] colors, String string, int x, int y, int width, int height, boolean selected, boolean focused) {
        if (selected) {
            g.setColor(colors[3]);
        } else {
            g.setColor(colors[0]);
        }
        g.fillRect(x, y, width, height);
        if (focused) {
            g.setColor(Color.BLACK);
            g.drawRect(x + 1, y + 1, width - 2, height - 2);
        }
        if (selected) {
            g.setColor(colors[0]);
        } else {
            g.setColor(colors[3]);
        }
        g.setFont(this.font);
        int fontAscent = this.fm.getAscent();
        int fontDescent = this.fm.getDescent();
        g.drawString(string, x + this.TEXT_SPACE, y + (height + this.fm.getMaxAscent() - this.fm.getMaxDescent()) / 2);
    }

    boolean isItemSelected(int index) {
        for (Integer val : this.selected) {
            if (val != index) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintVSB(Graphics g, Color[] colors, Rectangle bounds) {
        int height = bounds.height - 2 * this.BORDER_WIDTH - (this.hsbVis ? this.SCROLLBAR_WIDTH - 2 : 0);
        Graphics ng = g.create();
        g.setColor(colors[0]);
        try {
            ng.translate(bounds.width - this.BORDER_WIDTH - this.SCROLLBAR_WIDTH, this.BORDER_WIDTH);
            this.vsb.setSize(this.SCROLLBAR_WIDTH, bounds.height);
            this.vsb.paint(ng, colors, true);
        }
        finally {
            ng.dispose();
        }
    }

    public void paintHSB(Graphics g, Color[] colors, Rectangle bounds) {
    }

    static boolean doWheelScroll(XVerticalScrollbar vsb, XHorizontalScrollbar hsb, MouseWheelEvent e) {
        XScrollbar scroll = null;
        if (vsb != null) {
            scroll = vsb;
        } else if (hsb != null) {
            scroll = hsb;
        } else {
            return false;
        }
        int wheelRotation = e.getWheelRotation();
        if (wheelRotation < 0 && scroll.getValue() > scroll.getMinimum() || wheelRotation > 0 && scroll.getValue() < scroll.getMaximum() || wheelRotation != 0) {
            int type = e.getScrollType();
            int incr = type == 1 ? wheelRotation * scroll.getBlockIncrement() : e.getUnitsToScroll() * scroll.getUnitIncrement();
            scroll.setValue(scroll.getValue() + incr);
            return true;
        }
        return false;
    }

    void trackMouseDraggedScroll(int mouseX, int mouseY, int listWidth, int listHeight) {
        if (!this.mouseDraggedOutVertically) {
            if (this.vsb.beforeThumb(mouseX, mouseY)) {
                this.vsb.setMode(2);
            } else {
                this.vsb.setMode(1);
            }
        }
        if (!(this.mouseDraggedOutVertically || mouseY >= 0 && mouseY < listHeight)) {
            this.mouseDraggedOutVertically = true;
            this.vsb.startScrollingInstance();
        }
        if (this.mouseDraggedOutVertically && mouseY >= 0 && mouseY < listHeight && mouseX >= 0 && mouseX < listWidth) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
    }

    void trackMouseReleasedScroll() {
        if (this.mouseDraggedOutVertically) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
    }
}

