#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: feed
version: 0.3.12.0
id: feed-0.3.12.0-9wLyfro2SuZ2iqtJ3auvdE
key: feed-0.3.12.0-9wLyfro2SuZ2iqtJ3auvdE
license: BSD3
maintainer: Adam Bergmark <adam@bergmark.nl>
homepage: https://github.com/bergmark/feed
synopsis: Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
description:
    Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
    .
    To help working with the multiple feed formats we'\''ve
    ended up with, this set of modules provides parsers,
    pretty printers and some utility code for querying
    and just generally working with a concrete representation
    of feeds in Haskell.
    .
    See here for an example of how to create an Atom feed:
    <https://github.com/bergmark/feed/blob/master/tests/Example/CreateAtom.hs>
    .
    For basic reading and editing of feeds, consult
    the documentation of the Text.Feed.* hierarchy.
category: Text
author: Sigbjorn Finne <sof@forkIO.com>
exposed: True
exposed-modules:
    Text.Atom.Feed Text.Atom.Feed.Export Text.Atom.Feed.Import
    Text.Atom.Feed.Link Text.Atom.Feed.Validate Text.Atom.Pub
    Text.Atom.Pub.Export Text.DublinCore.Types Text.Feed.Constructor
    Text.Feed.Export Text.Feed.Import Text.Feed.Query
    Text.Feed.Translate Text.Feed.Types Text.Feed.Util Text.RSS.Export
    Text.RSS.Import Text.RSS.Syntax Text.RSS1.Export Text.RSS1.Import
    Text.RSS1.Syntax Text.RSS1.Utils
abi: 677b11976b9ef82d7ca207d1897a519a
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/feed-0.3.12.0
library-dirs: /usr/lib/ghc-8.0.2/site-local/feed-0.3.12.0
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/feed-0.3.12.0
hs-libraries: HSfeed-0.3.12.0-9wLyfro2SuZ2iqtJ3auvdE
depends:
    base-4.9.1.0 old-locale-1.0.0.7-KGBP1BSKxH5GCm0LnZP04j
    old-time-1.1.0.3-EZzkBJ4NQxX4hHavrKxgaT time-1.6.0.1
    time-locale-compat-0.1.1.3-KZ1jqNx8uhlHjmuPPj6V1Y
    utf8-string-1.0.1.1-1DpjxLeTvGg7ttZZojxJR5
    xml-1.3.14-FVnE0jAbj4fGGraldXZwwG
haddock-interfaces: /usr/share/doc/haskell-feed/html/feed.haddock
haddock-html: /usr/share/doc/haskell-feed/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
