#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hackage-security
version: 0.5.2.2
id: hackage-security-0.5.2.2-GCDLVTcWT11CzFQsk06qA9
key: hackage-security-0.5.2.2-GCDLVTcWT11CzFQsk06qA9
license: BSD3
copyright: Copyright 2015-2016 Well-Typed LLP
maintainer: edsko@well-typed.com
homepage: https://github.com/well-typed/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
category: Distribution
author: Edsko de Vries
exposed: True
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.Trusted Hackage.Security.TUF.FileMap
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
abi: 3965f0bbeb488c79c6f869d59b8366ab
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/hackage-security-0.5.2.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/hackage-security-0.5.2.2
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/hackage-security-0.5.2.2
hs-libraries: HShackage-security-0.5.2.2-GCDLVTcWT11CzFQsk06qA9
depends:
    Cabal-1.24.2.0 base-4.9.1.0
    base16-bytestring-0.1.1.6-4E2p94lTx8gIceMhu8Kl9o
    base64-bytestring-1.0.0.1-4O9TExPPz6eI82Yj7L4SIj
    bytestring-0.10.8.1 containers-0.5.7.1
    cryptohash-sha256-0.11.100.1-4jVo7W1Cec2JgABhLoMmkP
    directory-1.3.0.0 ed25519-0.0.5.0-1z9PQIidIUl5GmWR4nJdUy
    filepath-1.4.1.1 ghc-prim-0.5.0.0 mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    network-2.6.3.2-IsLM4TXcLoRI0fmmBYVyQz
    network-uri-2.6.1.0-GzRvaV3udR3JtWfa3CLYOw
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR pretty-1.1.3.3
    tar-0.5.0.3-60pC6grTbvG2zWoTgfDWBJ template-haskell-2.11.1.0
    time-1.6.0.1 transformers-0.5.2.0
    zlib-0.6.1.2-GcLmGV5PElZD6CJvjR9umm
haddock-interfaces: /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock
haddock-html: /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
