/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg.drew;

import java.io.File;
import java.util.HashMap;
import tim.prune.jpeg.ExifGateway;
import tim.prune.jpeg.JpegData;
import tim.prune.jpeg.drew.JpegException;
import tim.prune.jpeg.drew.JpegSegmentReader;
import tim.prune.jpeg.drew.Rational;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifReader {
    private final byte[] _data;
    private boolean _isMotorolaByteOrder;
    private int _thumbnailOffset = -1;
    private int _thumbnailLength = -1;
    private static final int[] BYTES_PER_FORMAT;
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_STRING = 2;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SRATIONAL = 10;
    public static final int TAG_EXIF_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE = 37500;
    public static final int TIFF_HEADER_START_OFFSET = 6;
    public static final int TAG_GPS_VERSION_ID = 0;
    public static final int TAG_GPS_LATITUDE_REF = 1;
    public static final int TAG_GPS_LATITUDE = 2;
    public static final int TAG_GPS_LONGITUDE_REF = 3;
    public static final int TAG_GPS_LONGITUDE = 4;
    public static final int TAG_GPS_ALTITUDE_REF = 5;
    public static final int TAG_GPS_ALTITUDE = 6;
    public static final int TAG_GPS_TIMESTAMP = 7;
    public static final int TAG_GPS_DATESTAMP = 29;
    public static final int TAG_DATETIME_ORIGINAL = 36867;
    public static final int TAG_DATETIME_DIGITIZED = 36868;
    private static final int TAG_THUMBNAIL_OFFSET = 513;
    private static final int TAG_THUMBNAIL_LENGTH = 514;
    private static final int TAG_ORIENTATION = 274;
    private static final int TAG_BEARING = 17;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        BYTES_PER_FORMAT = nArray;
    }

    public ExifReader(File file) throws JpegException {
        this._data = JpegSegmentReader.readExifSegment(file);
    }

    public JpegData extract() {
        JpegData jpegData = new JpegData();
        if (this._data == null) {
            return jpegData;
        }
        if (this._data.length <= 14) {
            jpegData.addError("Exif data segment must contain at least 14 bytes");
            return jpegData;
        }
        if (!"Exif\u0000\u0000".equals(new String(this._data, 0, 6))) {
            jpegData.addError("Exif data segment doesn't begin with 'Exif'");
            return jpegData;
        }
        String string = new String(this._data, 6, 2);
        if (!this.setByteOrder(string)) {
            jpegData.addError("Unclear distinction between Motorola/Intel byte ordering: " + string);
            return jpegData;
        }
        if (this.get16Bits(8) != 42) {
            jpegData.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return jpegData;
        }
        int n = this.get32Bits(10) + 6;
        if (n >= this._data.length - 1) {
            jpegData.addError("First exif directory offset is beyond end of Exif data segment");
            n = 14;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        this.processDirectory(jpegData, false, hashMap, n, 6);
        return jpegData;
    }

    private boolean setByteOrder(String string) {
        if ("MM".equals(string)) {
            this._isMotorolaByteOrder = true;
        } else if ("II".equals(string)) {
            this._isMotorolaByteOrder = false;
        } else {
            return false;
        }
        return true;
    }

    private void processDirectory(JpegData jpegData, boolean bl, HashMap<Integer, String> hashMap, int n, int n2) {
        int n3;
        if (hashMap.containsKey(n)) {
            return;
        }
        hashMap.put(n, "processed");
        if (n >= this._data.length || n < 0) {
            jpegData.addError("Ignored directory marked to start outside data segment");
            return;
        }
        int n4 = this.get16Bits(n);
        if (n4 == 0) {
            return;
        }
        if (!this.isDirectoryLengthValid(n, n2)) {
            jpegData.addError("Directory length is not valid");
            return;
        }
        jpegData.setExifDataPresent();
        int n5 = 0;
        while (n5 < n4) {
            n3 = this.calculateTagOffset(n, n5);
            int n6 = this.get16Bits(n3);
            int n7 = this.get16Bits(n3 + 2);
            if (n7 < 1 || n7 > 12) {
                jpegData.addError("Invalid format code: " + n7);
            } else {
                int n8 = this.get32Bits(n3 + 4);
                if (n8 < 0) {
                    jpegData.addError("Negative component count in EXIF");
                } else {
                    int n9 = n8 * BYTES_PER_FORMAT[n7];
                    int n10 = this.calculateTagValueOffset(n9, n3, n2);
                    if (n10 < 0 || n10 > this._data.length) {
                        jpegData.addError("Illegal pointer offset value in EXIF");
                    } else if (n9 < 0 || n10 + n9 > this._data.length) {
                        jpegData.addError("Illegal number of bytes: " + n9);
                    } else {
                        int n11 = n2 + this.get32Bits(n10);
                        switch (n6) {
                            case 34665: {
                                this.processDirectory(jpegData, false, hashMap, n11, n2);
                                break;
                            }
                            case 40965: {
                                break;
                            }
                            case 34853: {
                                this.processDirectory(jpegData, true, hashMap, n11, n2);
                                break;
                            }
                            case 37500: {
                                break;
                            }
                            default: {
                                if (bl) {
                                    this.processGpsTag(jpegData, n6, n10, n8, n7);
                                    break;
                                }
                                this.processExifTag(jpegData, n6, n10, n8, n7);
                            }
                        }
                    }
                }
            }
            ++n5;
        }
        n5 = this.calculateTagOffset(n, n4);
        n3 = this.get32Bits(n5);
        if (n3 != 0) {
            if ((n3 += n2) >= this._data.length) {
                return;
            }
            if (n3 < n) {
                return;
            }
            this.processDirectory(jpegData, false, hashMap, n3, n2);
        }
    }

    private boolean isDirectoryLengthValid(int n, int n2) {
        int n3 = this.get16Bits(n);
        int n4 = 2 + 12 * n3 + 4;
        return n4 + n + n2 < this._data.length;
    }

    private void processGpsTag(JpegData jpegData, int n, int n2, int n3, int n4) {
        try {
            switch (n) {
                case 1: {
                    jpegData.setLatitudeRef(this.readString(n2, n4, n3));
                    break;
                }
                case 2: {
                    Rational[] rationalArray = this.readRationalArray(n2, n4, n3);
                    jpegData.setLatitude(new double[]{rationalArray[0].doubleValue(), rationalArray[1].doubleValue(), ExifGateway.convertToPositiveValue(rationalArray[2].getNumerator(), rationalArray[2].getDenominator())});
                    break;
                }
                case 3: {
                    jpegData.setLongitudeRef(this.readString(n2, n4, n3));
                    break;
                }
                case 4: {
                    Rational[] rationalArray = this.readRationalArray(n2, n4, n3);
                    jpegData.setLongitude(new double[]{rationalArray[0].doubleValue(), rationalArray[1].doubleValue(), ExifGateway.convertToPositiveValue(rationalArray[2].getNumerator(), rationalArray[2].getDenominator())});
                    break;
                }
                case 5: {
                    jpegData.setAltitudeRef(this._data[n2]);
                    break;
                }
                case 6: {
                    jpegData.setAltitude(this.readRational(n2, n4, n3).intValue());
                    break;
                }
                case 7: {
                    Rational[] rationalArray = this.readRationalArray(n2, n4, n3);
                    jpegData.setGpsTimestamp(new int[]{rationalArray[0].intValue(), rationalArray[1].intValue(), rationalArray[2].intValue()});
                    break;
                }
                case 29: {
                    Rational[] rationalArray = this.readRationalArray(n2, n4, n3);
                    if (rationalArray != null) {
                        jpegData.setGpsDatestamp(new int[]{rationalArray[0].intValue(), rationalArray[1].intValue(), rationalArray[2].intValue()});
                        break;
                    }
                    String string = this.readString(n2, n4, n3);
                    if (string != null && string.length() == 10) {
                        jpegData.setGpsDatestamp(new int[]{Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(8))});
                    }
                    break;
                }
                case 17: {
                    Rational rational = this.readRational(n2, n4, n3);
                    if (rational == null) break;
                    jpegData.setBearing(rational.doubleValue());
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception exception) {}
    }

    private void processExifTag(JpegData jpegData, int n, int n2, int n3, int n4) {
        if (n == 36867) {
            jpegData.setOriginalTimestamp(this.readString(n2, n4, n3));
        } else if (n == 36868) {
            jpegData.setDigitizedTimestamp(this.readString(n2, n4, n3));
        } else if (n == 513) {
            this._thumbnailOffset = 6 + this.get16Bits(n2);
            this.extractThumbnail(jpegData);
        } else if (n == 514) {
            this._thumbnailLength = this.get16Bits(n2);
            this.extractThumbnail(jpegData);
        } else if (n == 274 && jpegData.getOrientationCode() < 1) {
            jpegData.setOrientationCode(this.get16Bits(n2));
        }
    }

    private void extractThumbnail(JpegData jpegData) {
        if (this._thumbnailOffset > 0 && this._thumbnailLength > 0 && jpegData.getThumbnailImage() == null) {
            byte[] byArray = new byte[this._thumbnailLength];
            System.arraycopy(this._data, this._thumbnailOffset, byArray, 0, this._thumbnailLength);
            jpegData.setThumbnailImage(byArray);
        }
    }

    private int calculateTagValueOffset(int n, int n2, int n3) {
        if (n > 4) {
            int n4 = this.get32Bits(n2 + 8);
            if (n4 + n > this._data.length) {
                return -1;
            }
            return n3 + n4;
        }
        return n2 + 8;
    }

    private String readString(int n, int n2, int n3) {
        if (n2 != 2) {
            return null;
        }
        int n4 = 0;
        while (n + n4 < this._data.length && this._data[n + n4] != 0 && n4 < n3) {
            ++n4;
        }
        return new String(this._data, n, n4);
    }

    private Rational readRational(int n, int n2, int n3) {
        if (n2 != 10 && n2 != 5 || n3 != 1) {
            return null;
        }
        return new Rational(this.get32Bits(n), this.get32Bits(n + 4));
    }

    private Rational[] readRationalArray(int n, int n2, int n3) {
        if (n2 != 10 && n2 != 5) {
            return null;
        }
        Rational[] rationalArray = new Rational[n3];
        int n4 = 0;
        while (n4 < n3) {
            rationalArray[n4] = new Rational(this.get32Bits(n + 8 * n4), this.get32Bits(n + 4 + 8 * n4));
            ++n4;
        }
        return rationalArray;
    }

    private int calculateTagOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }

    private int get16Bits(int n) {
        if (n < 0 || n + 2 > this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorolaByteOrder) {
            return this._data[n] << 8 & 0xFF00 | this._data[n + 1] & 0xFF;
        }
        return this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }

    private int get32Bits(int n) {
        if (n < 0 || n + 4 > this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorolaByteOrder) {
            return this._data[n] << 24 & 0xFF000000 | this._data[n + 1] << 16 & 0xFF0000 | this._data[n + 2] << 8 & 0xFF00 | this._data[n + 3] & 0xFF;
        }
        return this._data[n + 3] << 24 & 0xFF000000 | this._data[n + 2] << 16 & 0xFF0000 | this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }
}

