/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.LdapCtx;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;

public final class SortResponseControl
extends BasicControl {
    public static final String OID = "1.2.840.113556.1.4.474";
    private static final long serialVersionUID = 5142939176006310877L;
    private int resultCode = 0;
    private String badAttrId = null;

    public SortResponseControl(String id, boolean criticality, byte[] value) throws IOException {
        super(id, criticality, value);
        BerDecoder ber = new BerDecoder(value, 0, value.length);
        ber.parseSeq(null);
        this.resultCode = ber.parseEnumeration();
        if (ber.bytesLeft() > 0 && ber.peekByte() == 128) {
            this.badAttrId = ber.parseStringWithTag(128, true, null);
        }
    }

    public boolean isSorted() {
        return this.resultCode == 0;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getAttributeID() {
        return this.badAttrId;
    }

    public NamingException getException() {
        return LdapCtx.mapErrorCode(this.resultCode, null);
    }
}

