/*
 * Decompiled with CFR 0.152.
 */
package dguitar.adaptors.midi;

import dguitar.adaptors.song.Song;
import dguitar.adaptors.song.SongEvent;
import dguitar.adaptors.song.SongMeasure;
import dguitar.adaptors.song.SongVirtualTrack;
import dguitar.adaptors.song.Tempo;
import dguitar.adaptors.song.TimeSignature;
import dguitar.adaptors.song.event.SongEventImpl;
import dguitar.adaptors.song.event.SongNoteOnMessage;
import dguitar.adaptors.song.impl.SongDeviceImpl;
import dguitar.adaptors.song.impl.SongImpl;
import dguitar.adaptors.song.impl.SongMeasureImpl;
import dguitar.adaptors.song.impl.SongMeasureTrackImpl;
import dguitar.adaptors.song.impl.SongTrackImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MidiAdaptor {
    public static Song makeSong(String midiFile) throws InvalidMidiDataException, IOException {
        File file = new File(midiFile);
        MidiFileFormat mff = MidiSystem.getMidiFileFormat(file);
        int ppq = mff.getResolution();
        Sequence seq = MidiSystem.getSequence(file);
        Track[] midiTracks = seq.getTracks();
        Track tempoMap = midiTracks[0];
        MetaMessage mm = MidiAdaptor.findMetaMessage(tempoMap, 0L, 81);
        byte[] messageData = mm.getData();
        int usq = (messageData[0] & 0xFF) << 16 | (messageData[1] & 0xFF) << 8 | messageData[2] & 0xFF;
        Tempo tempo = new Tempo();
        tempo.setUSQ(usq);
        SongImpl song = new SongImpl(ppq, tempo);
        long longest = 0L;
        int t = 1;
        while (t < midiTracks.length) {
            Track midiTrack = midiTracks[t];
            long thisTrack = midiTrack.ticks();
            if (thisTrack > longest) {
                longest = thisTrack;
            }
            ++t;
        }
        SongMeasureImpl songMeasure = new SongMeasureImpl(0, (int)longest, new TimeSignature(4, 4));
        song.addPhrase(songMeasure);
        int usedTracks = 0;
        int t2 = 1;
        while (t2 < midiTracks.length) {
            Track midiTrack = midiTracks[t2];
            Collection splitTracks = MidiAdaptor.splitTrack(midiTrack);
            Iterator it = splitTracks.iterator();
            while (it.hasNext()) {
                List singleTrack = (List)it.next();
                MidiAdaptor.encodeTrack(song, songMeasure, singleTrack, ++usedTracks);
            }
            ++t2;
        }
        return song;
    }

    private static Collection splitTrack(Track midiTrack) {
        HashMap<Integer, LinkedList<MidiEvent>> channelToTrack = new HashMap<Integer, LinkedList<MidiEvent>>();
        int count = midiTrack.size();
        int i = 0;
        while (i < count) {
            MidiEvent me = midiTrack.get(i);
            MidiMessage mm = me.getMessage();
            int status = mm.getStatus();
            if (status < 240) {
                int channel = status & 0xF;
                LinkedList<MidiEvent> thisTrack = (LinkedList<MidiEvent>)channelToTrack.get(new Integer(channel));
                if (thisTrack == null) {
                    thisTrack = new LinkedList<MidiEvent>();
                    channelToTrack.put(new Integer(channel), thisTrack);
                }
                thisTrack.add(me);
            }
            ++i;
        }
        return channelToTrack.values();
    }

    private static void encodeTrack(Song song, SongMeasure songMeasure, List singleTrack, int trackIndex) {
        SongTrackImpl st = new SongTrackImpl(trackIndex, 1);
        song.addTrack(st);
        SongMeasureTrackImpl smt = new SongMeasureTrackImpl(st);
        songMeasure.addTrack(smt);
        SongVirtualTrack svt = smt.getVirtualTrack(0);
        boolean processingControllers = true;
        int channel = 0;
        HashMap<Integer, SongEventImpl> openNotes = new HashMap<Integer, SongEventImpl>();
        int events = singleTrack.size();
        int i = 0;
        while (i < events) {
            MidiEvent midiEvent = (MidiEvent)singleTrack.get(i);
            long offset = midiEvent.getTick();
            MidiMessage message = midiEvent.getMessage();
            int status = message.getStatus();
            if (status < 240) {
                int command = status & 0xF0;
                channel = (status & 0xF) + 1;
                if (processingControllers && (command == 144 || command == 128)) {
                    processingControllers = false;
                }
                if (processingControllers) {
                    block0 : switch (command) {
                        case 176: {
                            ShortMessage cc = (ShortMessage)message;
                            int controller = cc.getData1();
                            int value = cc.getData2();
                            switch (controller) {
                                case 100: {
                                    break block0;
                                }
                                case 101: {
                                    break block0;
                                }
                                case 6: {
                                    st.setBendSensitivity(value);
                                    break block0;
                                }
                                case 7: {
                                    st.setVolume(value);
                                    break block0;
                                }
                                case 10: {
                                    st.setPan(value);
                                    break block0;
                                }
                                case 93: {
                                    st.setChorus(value);
                                    break block0;
                                }
                                case 91: {
                                    st.setReverb(value);
                                    break block0;
                                }
                                case 92: {
                                    st.setTremolo(value);
                                    break block0;
                                }
                                case 95: {
                                    st.setPhaser(value);
                                }
                            }
                            break;
                        }
                        case 192: {
                            ShortMessage pc = (ShortMessage)message;
                            st.setProgram(pc.getData1());
                        }
                    }
                } else if (command == 144 || command == 128) {
                    boolean noteOn;
                    ShortMessage sm = (ShortMessage)message;
                    int data1 = sm.getData1();
                    int data2 = sm.getData2();
                    boolean bl = noteOn = command == 144 && data2 != 0;
                    if (noteOn) {
                        SongNoteOnMessage snom = new SongNoteOnMessage(data1, data2, 0, 0);
                        SongEventImpl se = new SongEventImpl((int)offset, snom);
                        openNotes.put(new Integer(data1), se);
                        svt.addEvent(se);
                    } else {
                        SongEvent se = (SongEvent)openNotes.get(new Integer(data1));
                        int noteStart = se.getTime();
                        SongNoteOnMessage snom = (SongNoteOnMessage)se.getMessage();
                        snom.setDuration((int)offset - noteStart);
                    }
                }
            }
            ++i;
        }
        SongDeviceImpl device = new SongDeviceImpl(1, channel);
        st.setPrimaryDevice(device);
    }

    static MetaMessage findMetaMessage(Track track, long timestamp, int metaType) {
        int events = track.size();
        int i = 0;
        while (i < events) {
            MetaMessage m;
            MidiMessage mm;
            MidiEvent me = track.get(i);
            long eventTime = me.getTick();
            if (eventTime > timestamp) {
                return null;
            }
            if (eventTime == timestamp && (mm = me.getMessage()) instanceof MetaMessage && (m = (MetaMessage)mm).getType() == metaType) {
                return m;
            }
            ++i;
        }
        return null;
    }
}

