// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Units_ShiftedUnit_HeaderFile
#define _Units_ShiftedUnit_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Units_ShiftedUnit.hxx>

#include <Standard_Real.hxx>
#include <Units_Unit.hxx>
#include <Standard_CString.hxx>
#include <Handle_Units_Quantity.hxx>
#include <Handle_Units_Token.hxx>
#include <Standard_Integer.hxx>
class Units_Quantity;
class Units_Token;


//! This class is useful   to describe  units  with  a
//! shifted origin in relation to another unit. A well
//! known example  is the  Celsius degrees in relation
//! to Kelvin degrees. The shift of the Celsius origin
//! is 273.15 Kelvin degrees.
class Units_ShiftedUnit : public Units_Unit
{

public:

  
  //! Creates  and  returns a  shifted unit.   <aname> is the
  //! name of the unit,  <asymbol> is the usual abbreviation
  //! of the unit, <avalue> is the  value in relation to the
  //! International System of Units, and <amove>  is the gap
  //! in relation to another unit.
  //!
  //! For  example Celcius   dregee   of temperature  is  an
  //! instance of ShiftedUnit  with <avalue> equal to 1. and
  //! <amove> equal to 273.15.
  Standard_EXPORT Units_ShiftedUnit(const Standard_CString aname, const Standard_CString asymbol, const Standard_Real avalue, const Standard_Real amove, const Handle(Units_Quantity)& aquantity);
  
  //! Creates  and returns a  unit.  <aname> is  the name of
  //! the  unit, <asymbol> is the  usual abbreviation of the
  //! unit.
  Standard_EXPORT Units_ShiftedUnit(const Standard_CString aname, const Standard_CString asymbol);
  
  //! Creates  and returns a  unit.  <aname> is  the name of
  //! the  unit.
  Standard_EXPORT Units_ShiftedUnit(const Standard_CString aname);
  
  //! Sets the field <themove> to <amove>
  Standard_EXPORT   void Move (const Standard_Real amove) ;
  
  //! Returns the shifted value <themove>.
  Standard_EXPORT   Standard_Real Move()  const;
  
  //! This redefined method returns a ShiftedToken object.
  Standard_EXPORT virtual   Handle(Units_Token) Token()  const;
  
  Standard_EXPORT virtual   void Dump (const Standard_Integer ashift, const Standard_Integer alevel)  const;




  DEFINE_STANDARD_RTTI(Units_ShiftedUnit)

protected:




private: 


  Standard_Real themove;


};







#endif // _Units_ShiftedUnit_HeaderFile
