/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsDesktopManager;
import com.sun.java.swing.plaf.windows.WindowsInternalFrameTitlePane;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class WindowsInternalFrameUI
extends BasicInternalFrameUI {
    XPStyle xp = XPStyle.getXP();

    @Override
    public void installDefaults() {
        super.installDefaults();
        if (this.xp != null) {
            this.frame.setBorder(new XPBorder());
        } else {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.border"));
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(c, "opaque", this.xp == null ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void uninstallDefaults() {
        this.frame.setBorder(null);
        super.uninstallDefaults();
    }

    public static ComponentUI createUI(JComponent b) {
        return new WindowsInternalFrameUI((JInternalFrame)b);
    }

    public WindowsInternalFrameUI(JInternalFrame w) {
        super(w);
    }

    @Override
    protected DesktopManager createDesktopManager() {
        return new WindowsDesktopManager();
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new WindowsInternalFrameTitlePane(w);
        return this.titlePane;
    }

    private class XPBorder
    extends AbstractBorder {
        private XPStyle.Skin leftSkin;
        private XPStyle.Skin rightSkin;
        private XPStyle.Skin bottomSkin;

        private XPBorder() {
            this.leftSkin = WindowsInternalFrameUI.this.xp.getSkin(WindowsInternalFrameUI.this.frame, TMSchema.Part.WP_FRAMELEFT);
            this.rightSkin = WindowsInternalFrameUI.this.xp.getSkin(WindowsInternalFrameUI.this.frame, TMSchema.Part.WP_FRAMERIGHT);
            this.bottomSkin = WindowsInternalFrameUI.this.xp.getSkin(WindowsInternalFrameUI.this.frame, TMSchema.Part.WP_FRAMEBOTTOM);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            TMSchema.State state = ((JInternalFrame)c).isSelected() ? TMSchema.State.ACTIVE : TMSchema.State.INACTIVE;
            int topBorderHeight = WindowsInternalFrameUI.this.titlePane != null ? ((WindowsInternalFrameUI)WindowsInternalFrameUI.this).titlePane.getSize().height : 0;
            this.bottomSkin.paintSkin(g, 0, height - this.bottomSkin.getHeight(), width, this.bottomSkin.getHeight(), state);
            this.leftSkin.paintSkin(g, 0, topBorderHeight - 1, this.leftSkin.getWidth(), height - topBorderHeight - this.bottomSkin.getHeight() + 2, state);
            this.rightSkin.paintSkin(g, width - this.rightSkin.getWidth(), topBorderHeight - 1, this.rightSkin.getWidth(), height - topBorderHeight - this.bottomSkin.getHeight() + 2, state);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 4;
            insets.left = this.leftSkin.getWidth();
            insets.right = this.rightSkin.getWidth();
            insets.bottom = this.bottomSkin.getHeight();
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

