/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public final class XAtom {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private static XAtom[] emptyList = new XAtom[0];
    public static final long XA_PRIMARY = 1L;
    public static final long XA_SECONDARY = 2L;
    public static final long XA_ARC = 3L;
    public static final long XA_ATOM = 4L;
    public static final long XA_BITMAP = 5L;
    public static final long XA_CARDINAL = 6L;
    public static final long XA_COLORMAP = 7L;
    public static final long XA_CURSOR = 8L;
    public static final long XA_CUT_BUFFER0 = 9L;
    public static final long XA_CUT_BUFFER1 = 10L;
    public static final long XA_CUT_BUFFER2 = 11L;
    public static final long XA_CUT_BUFFER3 = 12L;
    public static final long XA_CUT_BUFFER4 = 13L;
    public static final long XA_CUT_BUFFER5 = 14L;
    public static final long XA_CUT_BUFFER6 = 15L;
    public static final long XA_CUT_BUFFER7 = 16L;
    public static final long XA_DRAWABLE = 17L;
    public static final long XA_FONT = 18L;
    public static final long XA_INTEGER = 19L;
    public static final long XA_PIXMAP = 20L;
    public static final long XA_POINT = 21L;
    public static final long XA_RECTANGLE = 22L;
    public static final long XA_RESOURCE_MANAGER = 23L;
    public static final long XA_RGB_COLOR_MAP = 24L;
    public static final long XA_RGB_BEST_MAP = 25L;
    public static final long XA_RGB_BLUE_MAP = 26L;
    public static final long XA_RGB_DEFAULT_MAP = 27L;
    public static final long XA_RGB_GRAY_MAP = 28L;
    public static final long XA_RGB_GREEN_MAP = 29L;
    public static final long XA_RGB_RED_MAP = 30L;
    public static final long XA_STRING = 31L;
    public static final long XA_VISUALID = 32L;
    public static final long XA_WINDOW = 33L;
    public static final long XA_WM_COMMAND = 34L;
    public static final long XA_WM_HINTS = 35L;
    public static final long XA_WM_CLIENT_MACHINE = 36L;
    public static final long XA_WM_ICON_NAME = 37L;
    public static final long XA_WM_ICON_SIZE = 38L;
    public static final long XA_WM_NAME = 39L;
    public static final long XA_WM_NORMAL_HINTS = 40L;
    public static final long XA_WM_SIZE_HINTS = 41L;
    public static final long XA_WM_ZOOM_HINTS = 42L;
    public static final long XA_MIN_SPACE = 43L;
    public static final long XA_NORM_SPACE = 44L;
    public static final long XA_MAX_SPACE = 45L;
    public static final long XA_END_SPACE = 46L;
    public static final long XA_SUPERSCRIPT_X = 47L;
    public static final long XA_SUPERSCRIPT_Y = 48L;
    public static final long XA_SUBSCRIPT_X = 49L;
    public static final long XA_SUBSCRIPT_Y = 50L;
    public static final long XA_UNDERLINE_POSITION = 51L;
    public static final long XA_UNDERLINE_THICKNESS = 52L;
    public static final long XA_STRIKEOUT_ASCENT = 53L;
    public static final long XA_STRIKEOUT_DESCENT = 54L;
    public static final long XA_ITALIC_ANGLE = 55L;
    public static final long XA_X_HEIGHT = 56L;
    public static final long XA_QUAD_WIDTH = 57L;
    public static final long XA_WEIGHT = 58L;
    public static final long XA_POINT_SIZE = 59L;
    public static final long XA_RESOLUTION = 60L;
    public static final long XA_COPYRIGHT = 61L;
    public static final long XA_NOTICE = 62L;
    public static final long XA_FONT_NAME = 63L;
    public static final long XA_FAMILY_NAME = 64L;
    public static final long XA_FULL_NAME = 65L;
    public static final long XA_CAP_HEIGHT = 66L;
    public static final long XA_WM_CLASS = 67L;
    public static final long XA_WM_TRANSIENT_FOR = 68L;
    public static final long XA_LAST_PREDEFINED = 68L;
    static HashMap<Long, XAtom> atomToAtom = new HashMap();
    static HashMap<String, XAtom> nameToAtom = new HashMap();
    long atom = 0L;
    String name;
    long display;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(XAtom at) {
        if (at == null) {
            return;
        }
        Class<XAtom> clazz = XAtom.class;
        synchronized (XAtom.class) {
            if (at.atom != 0L) {
                atomToAtom.put(at.atom, at);
            }
            if (at.name != null) {
                nameToAtom.put(at.name, at);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XAtom lookup(long atom) {
        Class<XAtom> clazz = XAtom.class;
        synchronized (XAtom.class) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return atomToAtom.get(atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XAtom lookup(String name) {
        Class<XAtom> clazz = XAtom.class;
        synchronized (XAtom.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return nameToAtom.get(name);
        }
    }

    static XAtom get(long atom) {
        XAtom xatom = XAtom.lookup(atom);
        if (xatom == null) {
            xatom = new XAtom(XToolkit.getDisplay(), atom);
        }
        return xatom;
    }

    public static XAtom get(String name) {
        XAtom xatom = XAtom.lookup(name);
        if (xatom == null) {
            xatom = new XAtom(XToolkit.getDisplay(), name);
        }
        return xatom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getName() {
        if (this.name == null) {
            XToolkit.awtLock();
            try {
                this.name = XlibWrapper.XGetAtomName(this.display, this.atom);
            }
            finally {
                XToolkit.awtUnlock();
            }
            this.register();
        }
        return this.name;
    }

    static String asString(long atom) {
        XAtom at = XAtom.lookup(atom);
        if (at == null) {
            return Long.toString(atom);
        }
        return at.toString();
    }

    void register() {
        XAtom.register(this);
    }

    public String toString() {
        if (this.name != null) {
            return this.name + ":" + this.atom;
        }
        return Long.toString(this.atom);
    }

    private XAtom(long display, String name) {
        this(display, name, true);
    }

    public XAtom(String name, boolean autoIntern) {
        this(XToolkit.getDisplay(), name, autoIntern);
    }

    public XAtom(long display, long atom) {
        this.atom = atom;
        this.display = display;
        this.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XAtom(long display, String name, boolean autoIntern) {
        this.name = name;
        this.display = display;
        if (autoIntern) {
            XToolkit.awtLock();
            try {
                this.atom = XlibWrapper.InternAtom(display, name, 0);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        this.register();
    }

    public XAtom() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(long window, String str) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            XlibWrapper.SetProperty(this.display, window, this.atom, str);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setPropertyUTF8(long window, String str) {
        XAtom XA_UTF8_STRING = XAtom.get("UTF8_STRING");
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        byte[] bdata = null;
        try {
            bdata = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        if (bdata != null) {
            this.setAtomData(window, XA_UTF8_STRING.atom, bdata);
        }
    }

    public void setProperty8(long window, String str) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        byte[] bdata = null;
        try {
            bdata = str.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        if (bdata != null) {
            this.setAtomData(window, 31L, bdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(long window) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            String string = XlibWrapper.GetProperty(this.display, window, this.atom);
            return string;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get32Property(long window, long property_type) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        WindowPropertyGetter getter = new WindowPropertyGetter(window, this, 0L, 1L, false, property_type);
        try {
            int status = getter.execute();
            if (status != 0 || getter.getData() == 0L) {
                long l = 0L;
                return l;
            }
            if (getter.getActualType() != property_type || getter.getActualFormat() != 32) {
                long l = 0L;
                return l;
            }
            long l = Native.getCard32(getter.getData());
            return l;
        }
        finally {
            getter.dispose();
        }
    }

    public long getCard32Property(XBaseWindow window) {
        return this.get32Property(window.getWindow(), 6L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCard32Property(long window, long value) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            Native.putCard32(XlibWrapper.larg1, value);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), window, this.atom, 6L, 32, 0, XlibWrapper.larg1, 1);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setCard32Property(XBaseWindow window, long value) {
        this.setCard32Property(window.getWindow(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAtomData(long window, long data_ptr, int length) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        WindowPropertyGetter getter = new WindowPropertyGetter(window, this, 0L, (long)length, false, this);
        try {
            int status = getter.execute();
            if (status != 0 || getter.getData() == 0L) {
                boolean bl = false;
                return bl;
            }
            if (getter.getActualType() != this.atom || getter.getActualFormat() != 32 || getter.getNumberOfItems() != length) {
                boolean bl = false;
                return bl;
            }
            XlibWrapper.memcpy(data_ptr, getter.getData(), length * XAtom.getAtomSize());
            boolean bl = true;
            return bl;
        }
        finally {
            getter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAtomData(long window, long type, long data_ptr, int length) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        WindowPropertyGetter getter = new WindowPropertyGetter(window, this, 0L, (long)length, false, type);
        try {
            int status = getter.execute();
            if (status != 0 || getter.getData() == 0L) {
                boolean bl = false;
                return bl;
            }
            if (getter.getActualType() != type || getter.getActualFormat() != 32 || getter.getNumberOfItems() != length) {
                boolean bl = false;
                return bl;
            }
            XlibWrapper.memcpy(data_ptr, getter.getData(), length * XAtom.getAtomSize());
            boolean bl = true;
            return bl;
        }
        finally {
            getter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData(long window, long data_ptr, int length) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), window, this.atom, this.atom, 32, 0, data_ptr, length);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData(long window, long type, long data_ptr, int length) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), window, this.atom, type, 32, 0, data_ptr, length);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData8(long window, long type, long data_ptr, int length) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), window, this.atom, type, 8, 0, data_ptr, length);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeleteProperty(long window) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), window, this.atom);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeleteProperty(XBaseWindow window) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window.getWindow());
        XToolkit.awtLock();
        try {
            XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), window.getWindow(), this.atom);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData(long window, long property_type, byte[] data) {
        long bdata = Native.toData(data);
        try {
            this.setAtomData8(window, property_type, bdata, data.length);
        }
        finally {
            unsafe.freeMemory(bdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArrayProperty(long window, long property_type) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        WindowPropertyGetter getter = new WindowPropertyGetter(window, this, 0L, 65535L, false, property_type);
        try {
            byte[] res;
            int status = getter.execute();
            if (status != 0 || getter.getData() == 0L) {
                byte[] byArray = null;
                return byArray;
            }
            if (getter.getActualType() != property_type || getter.getActualFormat() != 8) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = res = XlibWrapper.getStringBytes(getter.getData());
            return byArray;
        }
        finally {
            getter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intern(boolean onlyIfExists) {
        XToolkit.awtLock();
        try {
            this.atom = XlibWrapper.InternAtom(this.display, this.name, onlyIfExists ? 1 : 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterned() {
        if (this.atom == 0L) {
            XToolkit.awtLock();
            try {
                this.atom = XlibWrapper.InternAtom(this.display, this.name, 1);
            }
            finally {
                XToolkit.awtUnlock();
            }
            if (this.atom == 0L) {
                return false;
            }
            this.register();
            return true;
        }
        return true;
    }

    public void setValues(long display, String name, long atom) {
        this.display = display;
        this.atom = atom;
        this.name = name;
        this.register();
    }

    static int getAtomSize() {
        return Native.getLongSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XAtom[] getAtomListProperty(long window) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        WindowPropertyGetter getter = new WindowPropertyGetter(window, this, 0L, 65535L, false, 4L);
        try {
            int status = getter.execute();
            if (status != 0 || getter.getData() == 0L) {
                XAtom[] xAtomArray = emptyList;
                return xAtomArray;
            }
            if (getter.getActualType() != 4L || getter.getActualFormat() != 32) {
                XAtom[] xAtomArray = emptyList;
                return xAtomArray;
            }
            int count = getter.getNumberOfItems();
            if (count == 0) {
                XAtom[] xAtomArray = emptyList;
                return xAtomArray;
            }
            long list_atoms = getter.getData();
            XAtom[] res = new XAtom[count];
            for (int index = 0; index < count; ++index) {
                res[index] = XAtom.get(XAtom.getAtom(list_atoms + (long)(index * XAtom.getAtomSize())));
            }
            XAtom[] xAtomArray = res;
            return xAtomArray;
        }
        finally {
            getter.dispose();
        }
    }

    XAtomList getAtomListPropertyList(long window) {
        return new XAtomList(this.getAtomListProperty(window));
    }

    XAtomList getAtomListPropertyList(XBaseWindow window) {
        return this.getAtomListPropertyList(window.getWindow());
    }

    XAtom[] getAtomListProperty(XBaseWindow window) {
        return this.getAtomListProperty(window.getWindow());
    }

    void setAtomListProperty(long window, XAtom[] atoms) {
        long data = XAtom.toData(atoms);
        this.setAtomData(window, 4L, data, atoms.length);
        unsafe.freeMemory(data);
    }

    void setAtomListProperty(long window, XAtomList atoms) {
        long data = atoms.getAtomsData();
        this.setAtomData(window, 4L, data, atoms.size());
        unsafe.freeMemory(data);
    }

    public void setAtomListProperty(XBaseWindow window, XAtom[] atoms) {
        this.setAtomListProperty(window.getWindow(), atoms);
    }

    public void setAtomListProperty(XBaseWindow window, XAtomList atoms) {
        this.setAtomListProperty(window.getWindow(), atoms);
    }

    long getAtom() {
        return this.atom;
    }

    void putAtom(long ptr) {
        Native.putLong(ptr, this.atom);
    }

    static long getAtom(long ptr) {
        return Native.getLong(ptr);
    }

    static long toData(XAtom[] atoms) {
        long data = unsafe.allocateMemory(XAtom.getAtomSize() * atoms.length);
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] == null) continue;
            atoms[i].putAtom(data + (long)(i * XAtom.getAtomSize()));
        }
        return data;
    }

    void checkWindow(long window) {
        if (window == 0L) {
            throw new IllegalArgumentException("Window must not be zero");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof XAtom)) {
            return false;
        }
        XAtom ot = (XAtom)o;
        return this.atom == ot.atom && this.display == ot.display;
    }

    public int hashCode() {
        return (int)((this.atom ^ this.display) & 0xFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowProperty(long window, long window_value) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        XToolkit.awtLock();
        try {
            Native.putWindow(XlibWrapper.larg1, window_value);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), window, this.atom, 33L, 32, 0, XlibWrapper.larg1, 1);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setWindowProperty(XBaseWindow window, XBaseWindow window_value) {
        this.setWindowProperty(window.getWindow(), window_value.getWindow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWindowProperty(long window) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(window);
        WindowPropertyGetter getter = new WindowPropertyGetter(window, this, 0L, 1L, false, 33L);
        try {
            int status = getter.execute();
            if (status != 0 || getter.getData() == 0L) {
                long l = 0L;
                return l;
            }
            if (getter.getActualType() != 33L || getter.getActualFormat() != 32) {
                long l = 0L;
                return l;
            }
            long l = Native.getWindow(getter.getData());
            return l;
        }
        finally {
            getter.dispose();
        }
    }
}

