/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheEventLogging;
import org.apache.commons.jcs.auxiliary.disk.PurgatoryElement;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.engine.CacheEventQueueFactory;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDiskCache<K, V>
extends AbstractAuxiliaryCacheEventLogging<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDiskCache.class);
    private IDiskCacheAttributes diskCacheAttributes = null;
    private Map<K, PurgatoryElement<K, V>> purgatory;
    private ICacheEventQueue<K, V> cacheEventQueue;
    private boolean alive = false;
    private String cacheName;
    private int purgHits = 0;
    private final ReentrantReadWriteLock removeAllLock = new ReentrantReadWriteLock();

    protected AbstractDiskCache(IDiskCacheAttributes iDiskCacheAttributes) {
        this.diskCacheAttributes = iDiskCacheAttributes;
        this.cacheName = iDiskCacheAttributes.getCacheName();
        CacheEventQueueFactory cacheEventQueueFactory = new CacheEventQueueFactory();
        this.cacheEventQueue = cacheEventQueueFactory.createCacheEventQueue(new MyCacheListener(), CacheInfo.listenerId, this.cacheName, this.diskCacheAttributes.getEventQueuePoolName(), this.diskCacheAttributes.getEventQueueType());
        this.initPurgatory();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean bl) {
        this.alive = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPurgatory() {
        this.removeAllLock.writeLock().lock();
        try {
            AbstractDiskCache abstractDiskCache = this;
            synchronized (abstractDiskCache) {
                this.purgatory = this.diskCacheAttributes.getMaxPurgatorySize() >= 0 ? new LRUMap<K, PurgatoryElement<K, V>>(this.diskCacheAttributes.getMaxPurgatorySize()) : new HashMap<K, PurgatoryElement<K, V>>();
            }
        }
        finally {
            this.removeAllLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(ICacheElement<K, V> iCacheElement) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Putting element in purgatory, cacheName: " + this.cacheName + ", key: " + iCacheElement.getKey());
        }
        try {
            PurgatoryElement<K, V> purgatoryElement = new PurgatoryElement<K, V>(iCacheElement);
            purgatoryElement.setSpoolable(true);
            Map<K, PurgatoryElement<K, V>> map = this.purgatory;
            synchronized (map) {
                this.purgatory.put(purgatoryElement.getKey(), purgatoryElement);
            }
            this.cacheEventQueue.addPutEvent(purgatoryElement);
        }
        catch (IOException iOException) {
            log.error("Problem adding put event to queue.", iOException);
            this.cacheEventQueue.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICacheElement<K, V> get(K k) {
        if (!this.alive) {
            if (log.isDebugEnabled()) {
                log.debug("get was called, but the disk cache is not alive.");
            }
            return null;
        }
        PurgatoryElement<K, V> purgatoryElement = null;
        Map<K, PurgatoryElement<K, V>> map = this.purgatory;
        synchronized (map) {
            purgatoryElement = this.purgatory.get(k);
        }
        if (purgatoryElement != null) {
            ++this.purgHits;
            if (log.isDebugEnabled() && this.purgHits % 100 == 0) {
                log.debug("Purgatory hits = " + this.purgHits);
            }
            if (log.isDebugEnabled()) {
                log.debug("Found element in purgatory, cacheName: " + this.cacheName + ", key: " + k);
            }
            return purgatoryElement.getCacheElement();
        }
        try {
            return this.doGet(k);
        }
        catch (Exception exception) {
            log.error(exception);
            this.cacheEventQueue.destroy();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String string) throws IOException {
        HashSet<K> hashSet = null;
        Object object = this.purgatory;
        synchronized (object) {
            hashSet = new HashSet<K>(this.purgatory.keySet());
        }
        object = this.getKeyMatcher().getMatchingKeysFromArray(string, hashSet);
        Map<K, ICacheElement<K, ICacheElement<K, V>>> map = this.processGetMultiple((Set<K>)object);
        Map<K, ICacheElement<K, V>> map2 = this.doGetMatching(string);
        map.putAll(map2);
        return map;
    }

    @Override
    public Map<K, ICacheElement<K, V>> processGetMultiple(Set<K> set) {
        HashMap<K, ICacheElement<K, V>> hashMap = new HashMap<K, ICacheElement<K, V>>();
        if (set != null && !set.isEmpty()) {
            for (K k : set) {
                ICacheElement<K, V> iCacheElement = this.get(k);
                if (iCacheElement == null) continue;
                hashMap.put(k, iCacheElement);
            }
        }
        return hashMap;
    }

    @Override
    public abstract Set<K> getKeySet() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(K k) throws IOException {
        PurgatoryElement<K, V> purgatoryElement = null;
        Object object = this.purgatory;
        synchronized (object) {
            purgatoryElement = this.purgatory.get(k);
        }
        if (purgatoryElement != null) {
            object = purgatoryElement.getCacheElement();
            synchronized (object) {
                Map<K, PurgatoryElement<K, V>> map = this.purgatory;
                synchronized (map) {
                    this.purgatory.remove(k);
                }
                purgatoryElement.setSpoolable(false);
                this.doRemove(k);
            }
        }
        this.doRemove(k);
        return false;
    }

    @Override
    public final void removeAll() throws IOException {
        if (this.diskCacheAttributes.isAllowRemoveAll()) {
            this.initPurgatory();
            this.doRemoveAll();
        } else if (log.isInfoEnabled()) {
            log.info("RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    @Override
    public final void dispose() throws IOException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = true;
                long l = 100L;
                while (bl) {
                    bl = !AbstractDiskCache.this.cacheEventQueue.isEmpty();
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
                log.info("No longer waiting for event queue to finish: " + AbstractDiskCache.this.cacheEventQueue.getStatistics());
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            thread.join((long)this.diskCacheAttributes.getShutdownSpoolTimeLimit() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            log.error("The Shutdown Spool Process was interrupted.", interruptedException);
        }
        log.info("In dispose, destroying event queue.");
        this.cacheEventQueue.destroy();
        this.doDispose();
        this.alive = false;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Disk Cache");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Integer>("Purgatory Hits", this.purgHits));
        arrayList.add(new StatElement<Integer>("Purgatory Size", this.purgatory.size()));
        IStats iStats = this.cacheEventQueue.getStatistics();
        arrayList.addAll(iStats.getStatElements());
        stats.setStatElements(arrayList);
        return stats;
    }

    @Override
    public CacheStatus getStatus() {
        return this.alive ? CacheStatus.ALIVE : CacheStatus.DISPOSED;
    }

    @Override
    public abstract int getSize();

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.DISK_CACHE;
    }

    protected final ICacheElement<K, V> doGet(K k) throws IOException {
        return super.getWithEventLogging(k);
    }

    protected final Map<K, ICacheElement<K, V>> doGetMatching(String string) throws IOException {
        return super.getMatchingWithEventLogging(string);
    }

    protected final void doUpdate(ICacheElement<K, V> iCacheElement) throws IOException {
        super.updateWithEventLogging(iCacheElement);
    }

    protected final boolean doRemove(K k) throws IOException {
        return super.removeWithEventLogging(k);
    }

    protected final void doRemoveAll() throws IOException {
        super.removeAllWithEventLogging();
    }

    protected final void doDispose() throws IOException {
        super.disposeWithEventLogging();
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return this.getDiskLocation();
    }

    protected abstract String getDiskLocation();

    protected class MyCacheListener
    implements ICacheListener<K, V> {
        private long listenerId = 0L;

        protected MyCacheListener() {
        }

        @Override
        public long getListenerId() throws IOException {
            return this.listenerId;
        }

        @Override
        public void setListenerId(long l) throws IOException {
            this.listenerId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handlePut(ICacheElement<K, V> iCacheElement) throws IOException {
            if (AbstractDiskCache.this.alive) {
                if (iCacheElement instanceof PurgatoryElement) {
                    PurgatoryElement purgatoryElement = (PurgatoryElement)iCacheElement;
                    ICacheElement iCacheElement2 = purgatoryElement.getCacheElement();
                    synchronized (iCacheElement2) {
                        Map map;
                        AbstractDiskCache.this.removeAllLock.readLock().lock();
                        try {
                            map = AbstractDiskCache.this.purgatory;
                            synchronized (map) {
                                block21: {
                                    if (AbstractDiskCache.this.purgatory.containsKey(purgatoryElement.getKey())) break block21;
                                    return;
                                }
                                iCacheElement = purgatoryElement.getCacheElement();
                            }
                            if (purgatoryElement.isSpoolable()) {
                                AbstractDiskCache.this.doUpdate(iCacheElement);
                            }
                        }
                        finally {
                            AbstractDiskCache.this.removeAllLock.readLock().unlock();
                        }
                        map = AbstractDiskCache.this.purgatory;
                        synchronized (map) {
                            AbstractDiskCache.this.purgatory.remove(iCacheElement.getKey());
                        }
                    }
                }
                AbstractDiskCache.this.doUpdate(iCacheElement);
            } else {
                Map map = AbstractDiskCache.this.purgatory;
                synchronized (map) {
                    AbstractDiskCache.this.purgatory.remove(iCacheElement.getKey());
                }
            }
        }

        @Override
        public void handleRemove(String string, K k) throws IOException {
            if (AbstractDiskCache.this.alive && AbstractDiskCache.this.doRemove(k)) {
                log.debug("Element removed, key: " + k);
            }
        }

        @Override
        public void handleRemoveAll(String string) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doRemoveAll();
            }
        }

        @Override
        public void handleDispose(String string) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doDispose();
            }
        }
    }
}

