/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.IRemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.CacheEventQueueFactory;
import org.apache.commons.jcs.engine.CacheListeners;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.logging.CacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheServer<K, V>
extends UnicastRemoteObject
implements IRemoteCacheServer<K, V>,
Unreferenced {
    public static final String DFEAULT_REMOTE_CONFIGURATION_FILE = "/remote.cache.ccf";
    private static final long serialVersionUID = -8072345435941473116L;
    private static final Log log = LogFactory.getLog(RemoteCacheServer.class);
    private static final boolean timing = true;
    private int puts = 0;
    private final transient ConcurrentMap<String, CacheListeners<K, V>> cacheListenersMap = new ConcurrentHashMap<String, CacheListeners<K, V>>();
    private final transient ConcurrentMap<String, CacheListeners<K, V>> clusterListenersMap = new ConcurrentHashMap<String, CacheListeners<K, V>>();
    private transient CompositeCacheManager cacheManager;
    private final ConcurrentMap<Long, RemoteType> idTypeMap = new ConcurrentHashMap<Long, RemoteType>();
    private final ConcurrentMap<Long, String> idIPMap = new ConcurrentHashMap<Long, String>();
    private final int[] listenerId = new int[1];
    final IRemoteCacheServerAttributes remoteCacheServerAttributes;
    private final int logInterval = 100;
    private transient ICacheEventLogger cacheEventLogger;
    private ReentrantLock cacheListenersLock = new ReentrantLock();
    private ReentrantLock clusterListenersLock = new ReentrantLock();

    protected RemoteCacheServer(IRemoteCacheServerAttributes iRemoteCacheServerAttributes, Properties properties) throws RemoteException {
        super(iRemoteCacheServerAttributes.getServicePort());
        this.remoteCacheServerAttributes = iRemoteCacheServerAttributes;
        this.init(properties);
    }

    protected RemoteCacheServer(IRemoteCacheServerAttributes iRemoteCacheServerAttributes, Properties properties, RMISocketFactory rMISocketFactory) throws RemoteException {
        super(iRemoteCacheServerAttributes.getServicePort(), rMISocketFactory, rMISocketFactory);
        this.remoteCacheServerAttributes = iRemoteCacheServerAttributes;
        this.init(properties);
    }

    @Deprecated
    protected RemoteCacheServer(IRemoteCacheServerAttributes iRemoteCacheServerAttributes) throws RemoteException {
        super(iRemoteCacheServerAttributes.getServicePort());
        this.remoteCacheServerAttributes = iRemoteCacheServerAttributes;
        this.init(iRemoteCacheServerAttributes.getConfigFileName());
    }

    @Deprecated
    protected RemoteCacheServer(IRemoteCacheServerAttributes iRemoteCacheServerAttributes, RMISocketFactory rMISocketFactory) throws RemoteException {
        super(iRemoteCacheServerAttributes.getServicePort(), rMISocketFactory, rMISocketFactory);
        this.remoteCacheServerAttributes = iRemoteCacheServerAttributes;
        this.init(iRemoteCacheServerAttributes.getConfigFileName());
    }

    @Deprecated
    private void init(String string) throws RemoteException {
        String string2 = string == null ? DFEAULT_REMOTE_CONFIGURATION_FILE : string;
        Properties properties = null;
        try {
            properties = RemoteUtils.loadProps(string2);
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        this.init(properties);
    }

    private void init(Properties properties) throws RemoteException {
        try {
            this.cacheManager = this.createCacheManager(properties);
        }
        catch (CacheException cacheException) {
            throw new RemoteException(cacheException.getMessage(), cacheException);
        }
        String[] stringArray = this.cacheManager.getCacheNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CompositeCache compositeCache = this.cacheManager.getCache(string);
            this.cacheListenersMap.put(string, new CacheListeners(compositeCache));
        }
    }

    private CompositeCacheManager createCacheManager(Properties properties) throws CacheException {
        CompositeCacheManager compositeCacheManager = CompositeCacheManager.getUnconfiguredInstance();
        compositeCacheManager.configure(properties);
        return compositeCacheManager;
    }

    public void put(ICacheElement<K, V> iCacheElement) throws IOException {
        this.update(iCacheElement);
    }

    @Override
    public void update(ICacheElement<K, V> iCacheElement) throws IOException {
        this.update(iCacheElement, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ICacheElement<K, V> iCacheElement, long l) throws IOException {
        ICacheEvent<ICacheElement<K, V>> iCacheEvent = this.createICacheEvent(iCacheElement, l, "update");
        try {
            this.processUpdate(iCacheElement, l);
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdate(ICacheElement<K, V> iCacheElement, long l) {
        long l2 = 0L;
        l2 = System.currentTimeMillis();
        this.logUpdateInfo(iCacheElement);
        try {
            CacheListeners<K, V> cacheListeners = this.getCacheListeners(iCacheElement.getCacheName());
            iCacheElement.getVal();
            boolean bl = this.isRequestFromCluster(l);
            if (log.isDebugEnabled()) {
                log.debug("In update, requesterId = [" + l + "] fromCluster = " + bl);
            }
            CacheListeners<K, V> cacheListeners2 = cacheListeners;
            synchronized (cacheListeners2) {
                ICacheEventQueue<K, V>[] iCacheEventQueueArray;
                block17: {
                    try {
                        iCacheEventQueueArray = (ICacheEventQueue<K, V>[])cacheListeners.cache;
                        if (bl) {
                            if (log.isDebugEnabled()) {
                                log.debug("Put FROM cluster, NOT updating other auxiliaries for region.  requesterId [" + l + "]");
                            }
                            iCacheEventQueueArray.localUpdate(iCacheElement);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("Put NOT from cluster, updating other auxiliaries for region.  requesterId [" + l + "]");
                            }
                            iCacheEventQueueArray.update(iCacheElement);
                        }
                    }
                    catch (Exception exception) {
                        if (!log.isInfoEnabled()) break block17;
                        log.info("Exception caught updating item. requesterId [" + l + "] " + exception.getMessage());
                    }
                }
                if (!bl || bl && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    iCacheEventQueueArray = this.getEventQList(cacheListeners, l);
                    if (log.isDebugEnabled()) {
                        log.debug("qlist.length = " + iCacheEventQueueArray.length);
                    }
                    for (int i = 0; i < iCacheEventQueueArray.length; ++i) {
                        iCacheEventQueueArray[i].addPutEvent(iCacheElement);
                    }
                }
            }
        }
        catch (IOException iOException) {
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RemoteCacheServer", "update", iOException.getMessage() + " REGION: " + iCacheElement.getCacheName() + " ITEM: " + iCacheElement);
            }
            log.error("Trouble in Update. requesterId [" + l + "]", iOException);
        }
        long l3 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("put took " + String.valueOf(l3 - l2) + " ms.");
        }
    }

    private void logUpdateInfo(ICacheElement<K, V> iCacheElement) {
        ++this.puts;
        if (log.isInfoEnabled() && this.puts % 100 == 0) {
            log.info("puts = " + this.puts);
        }
        if (log.isDebugEnabled()) {
            log.debug("In update, put [" + iCacheElement.getKey() + "] in [" + iCacheElement.getCacheName() + "]");
        }
    }

    @Override
    public ICacheElement<K, V> get(String string, K k) throws IOException {
        return this.get(string, k, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheElement<K, V> get(String string, K k, long l) throws IOException {
        ICacheElement<K, V> iCacheElement = null;
        ICacheEvent<K> iCacheEvent = this.createICacheEvent(string, k, l, "get");
        try {
            iCacheElement = this.processGet(string, k, l);
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
        return iCacheElement;
    }

    private ICacheElement<K, V> processGet(String string, K k, long l) {
        CacheListeners<K, V> cacheListeners;
        boolean bl;
        block3: {
            bl = this.isRequestFromCluster(l);
            if (log.isDebugEnabled()) {
                log.debug("get [" + k + "] from cache [" + string + "] requesterId = [" + l + "] fromCluster = " + bl);
            }
            cacheListeners = null;
            try {
                cacheListeners = this.getCacheListeners(string);
            }
            catch (Exception exception) {
                log.error("Problem getting listeners.", exception);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RemoteCacheServer", "get", exception.getMessage() + string + " KEY: " + k);
            }
        }
        ICacheElement<K, V> iCacheElement = this.getFromCacheListeners(k, bl, cacheListeners, null);
        return iCacheElement;
    }

    private ICacheElement<K, V> getFromCacheListeners(K k, boolean bl, CacheListeners<K, V> cacheListeners, ICacheElement<K, V> iCacheElement) {
        ICacheElement<K, V> iCacheElement2 = iCacheElement;
        if (cacheListeners != null) {
            CompositeCache compositeCache = (CompositeCache)cacheListeners.cache;
            if (!bl && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug("NonLocalGet. fromCluster [" + bl + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                iCacheElement2 = compositeCache.get(k);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("LocalGet.  fromCluster [" + bl + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                iCacheElement2 = compositeCache.localGet(k);
            }
        }
        return iCacheElement2;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String string, String string2) throws IOException {
        return this.getMatching(string, string2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String string, String string2, long l) throws IOException {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(string, string2, l, "getMatching");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMatching(string, string2, l);
            return map;
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected Map<K, ICacheElement<K, V>> processGetMatching(String string, String string2, long l) {
        CacheListeners<K, V> cacheListeners;
        boolean bl;
        block3: {
            bl = this.isRequestFromCluster(l);
            if (log.isDebugEnabled()) {
                log.debug("getMatching [" + string2 + "] from cache [" + string + "] requesterId = [" + l + "] fromCluster = " + bl);
            }
            cacheListeners = null;
            try {
                cacheListeners = this.getCacheListeners(string);
            }
            catch (Exception exception) {
                log.error("Problem getting listeners.", exception);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RemoteCacheServer", "getMatching", exception.getMessage() + string + " pattern: " + string2);
            }
        }
        return this.getMatchingFromCacheListeners(string2, bl, cacheListeners);
    }

    private Map<K, ICacheElement<K, V>> getMatchingFromCacheListeners(String string, boolean bl, CacheListeners<K, V> cacheListeners) {
        Map map = null;
        if (cacheListeners != null) {
            CompositeCache compositeCache = (CompositeCache)cacheListeners.cache;
            if (!bl && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug("NonLocalGetMatching. fromCluster [" + bl + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                map = compositeCache.getMatching(string);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("LocalGetMatching.  fromCluster [" + bl + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                map = compositeCache.localGetMatching(string);
            }
        }
        return map;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String string, Set<K> set) throws IOException {
        return this.getMultiple(string, set, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String string, Set<K> set, long l) throws IOException {
        ICacheEvent<Serializable> iCacheEvent = this.createICacheEvent(string, (Serializable)((Object)set), l, "getMultiple");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMultiple(string, set, l);
            return map;
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    private Map<K, ICacheElement<K, V>> processGetMultiple(String string, Set<K> set, long l) {
        boolean bl = this.isRequestFromCluster(l);
        if (log.isDebugEnabled()) {
            log.debug("getMultiple [" + set + "] from cache [" + string + "] requesterId = [" + l + "] fromCluster = " + bl);
        }
        CacheListeners<K, V> cacheListeners = this.getCacheListeners(string);
        Map<K, ICacheElement<K, V>> map = this.getMultipleFromCacheListeners(set, null, bl, cacheListeners);
        return map;
    }

    private boolean isRequestFromCluster(long l) {
        RemoteType remoteType = (RemoteType)((Object)this.idTypeMap.get(l));
        return remoteType == RemoteType.CLUSTER;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromCacheListeners(Set<K> set, Map<K, ICacheElement<K, V>> map, boolean bl, CacheListeners<K, V> cacheListeners) {
        Map<K, ICacheElement<K, V>> map2 = map;
        if (cacheListeners != null) {
            CompositeCache compositeCache = (CompositeCache)cacheListeners.cache;
            if (!bl && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug("NonLocalGetMultiple. fromCluster [" + bl + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                map2 = compositeCache.getMultiple(set);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("LocalGetMultiple.  fromCluster [" + bl + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                map2 = compositeCache.localGetMultiple(set);
            }
        }
        return map2;
    }

    @Override
    public Set<K> getKeySet(String string) throws IOException {
        return this.processGetKeySet(string);
    }

    protected Set<K> processGetKeySet(String string) {
        CacheListeners<K, V> cacheListeners = null;
        try {
            cacheListeners = this.getCacheListeners(string);
        }
        catch (Exception exception) {
            log.error("Problem getting listeners.", exception);
        }
        if (cacheListeners == null) {
            return Collections.emptySet();
        }
        CompositeCache compositeCache = (CompositeCache)cacheListeners.cache;
        return compositeCache.getKeySet();
    }

    @Override
    public void remove(String string, K k) throws IOException {
        this.remove(string, k, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string, K k, long l) throws IOException {
        ICacheEvent<K> iCacheEvent = this.createICacheEvent(string, k, l, "remove");
        try {
            this.processRemove(string, k, l);
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemove(String string, K k, long l) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("remove [" + k + "] from cache [" + string + "]");
        }
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(string);
        boolean bl = this.isRequestFromCluster(l);
        if (cacheListeners != null) {
            CacheListeners cacheListeners2 = cacheListeners;
            synchronized (cacheListeners2) {
                boolean bl2 = false;
                CompositeCache compositeCache = (CompositeCache)cacheListeners.cache;
                if (bl) {
                    if (log.isDebugEnabled()) {
                        log.debug("Remove FROM cluster, NOT updating other auxiliaries for region");
                    }
                    bl2 = compositeCache.localRemove(k);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Remove NOT from cluster, updating other auxiliaries for region");
                    }
                    bl2 = compositeCache.remove(k);
                }
                if (log.isDebugEnabled()) {
                    log.debug("remove [" + k + "] from cache [" + string + "] success (was it found) = " + bl2);
                }
                if (!bl || bl && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] iCacheEventQueueArray = this.getEventQList(cacheListeners, l);
                    for (int i = 0; i < iCacheEventQueueArray.length; ++i) {
                        iCacheEventQueueArray[i].addRemoveEvent(k);
                    }
                }
            }
        }
    }

    @Override
    public void removeAll(String string) throws IOException {
        this.removeAll(string, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(String string, long l) throws IOException {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(string, "all", l, "removeAll");
        try {
            this.processRemoveAll(string, l);
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoveAll(String string, long l) throws IOException {
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(string);
        boolean bl = this.isRequestFromCluster(l);
        if (cacheListeners != null) {
            CacheListeners cacheListeners2 = cacheListeners;
            synchronized (cacheListeners2) {
                CompositeCache compositeCache = (CompositeCache)cacheListeners.cache;
                if (bl) {
                    if (log.isDebugEnabled()) {
                        log.debug("RemoveALL FROM cluster, NOT updating other auxiliaries for region");
                    }
                    compositeCache.localRemoveAll();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("RemoveALL NOT from cluster, updating other auxiliaries for region");
                    }
                    compositeCache.removeAll();
                }
                if (!bl || bl && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] iCacheEventQueueArray = this.getEventQList(cacheListeners, l);
                    for (int i = 0; i < iCacheEventQueueArray.length; ++i) {
                        iCacheEventQueueArray[i].addRemoveAllEvent();
                    }
                }
            }
        }
    }

    int getPutCount() {
        return this.puts;
    }

    @Override
    public void dispose(String string) throws IOException {
        this.dispose(string, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String string, long l) throws IOException {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(string, "none", l, "dispose");
        try {
            this.processDispose(string, l);
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDispose(String string, long l) throws IOException {
        CacheListeners cacheListeners;
        if (log.isInfoEnabled()) {
            log.info("Dispose request received from listener [" + l + "]");
        }
        if ((cacheListeners = (CacheListeners)this.cacheListenersMap.get(string)) != null) {
            CacheListeners cacheListeners2 = cacheListeners;
            synchronized (cacheListeners2) {
                ICacheEventQueue<K, V>[] iCacheEventQueueArray = this.getEventQList(cacheListeners, l);
                for (int i = 0; i < iCacheEventQueueArray.length; ++i) {
                    iCacheEventQueueArray[i].addDisposeEvent();
                }
                this.cacheManager.freeCache(string);
            }
        }
    }

    @Override
    public void release() throws IOException {
        for (CacheListeners cacheListeners : this.cacheListenersMap.values()) {
            ICacheEventQueue<K, V>[] iCacheEventQueueArray = this.getEventQList(cacheListeners, 0L);
            for (int i = 0; i < iCacheEventQueueArray.length; ++i) {
                iCacheEventQueueArray[i].addDisposeEvent();
            }
        }
        this.cacheManager.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners<K, V> getCacheListeners(String string) {
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(string);
        if (cacheListeners == null) {
            this.cacheListenersLock.lock();
            try {
                cacheListeners = (CacheListeners)this.cacheListenersMap.get(string);
                if (cacheListeners == null) {
                    CompositeCache compositeCache = this.cacheManager.getCache(string);
                    cacheListeners = new CacheListeners(compositeCache);
                    this.cacheListenersMap.put(string, cacheListeners);
                }
            }
            finally {
                this.cacheListenersLock.unlock();
            }
        }
        return cacheListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners<K, V> getClusterListeners(String string) {
        CacheListeners cacheListeners = (CacheListeners)this.clusterListenersMap.get(string);
        if (cacheListeners == null) {
            this.clusterListenersLock.lock();
            try {
                cacheListeners = (CacheListeners)this.clusterListenersMap.get(string);
                if (cacheListeners == null) {
                    CompositeCache compositeCache = this.cacheManager.getCache(string);
                    cacheListeners = new CacheListeners(compositeCache);
                    this.clusterListenersMap.put(string, cacheListeners);
                }
            }
            finally {
                this.clusterListenersLock.unlock();
            }
        }
        return cacheListeners;
    }

    private ICacheEventQueue<K, V>[] getEventQList(CacheListeners<K, V> cacheListeners, long l) {
        ICacheEventQueue[] iCacheEventQueueArray = cacheListeners.eventQMap.values().toArray(new ICacheEventQueue[0]);
        int n = 0;
        for (int i = 0; i < iCacheEventQueueArray.length; ++i) {
            ICacheEventQueue iCacheEventQueue = iCacheEventQueueArray[i];
            if (iCacheEventQueue.isWorking() && iCacheEventQueue.getListenerId() != l) {
                ++n;
                continue;
            }
            iCacheEventQueueArray[i] = null;
        }
        if (n == iCacheEventQueueArray.length) {
            return iCacheEventQueueArray;
        }
        ICacheEventQueue[] iCacheEventQueueArray2 = new ICacheEventQueue[n];
        n = 0;
        for (int i = 0; i < iCacheEventQueueArray.length; ++i) {
            if (iCacheEventQueueArray[i] == null) continue;
            iCacheEventQueueArray2[n++] = iCacheEventQueueArray[i];
        }
        return iCacheEventQueueArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <KK, VV> void cleanupEventQMap(Map<Long, ICacheEventQueue<KK, VV>> map) {
        Map<Long, ICacheEventQueue<KK, VV>> map2 = map;
        synchronized (map2) {
            Iterator<Map.Entry<Long, ICacheEventQueue<KK, VV>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, ICacheEventQueue<KK, VV>> entry = iterator.next();
                ICacheEventQueue<KK, VV> iCacheEventQueue = entry.getValue();
                if (iCacheEventQueue.isWorking()) continue;
                iterator.remove();
                log.warn("Cache event queue " + iCacheEventQueue + " is not working and removed from cache server.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KK, VV> void addCacheListener(String string, ICacheListener<KK, VV> iCacheListener) throws IOException {
        CacheListeners<K, V> cacheListeners;
        if (string == null || iCacheListener == null) {
            throw new IllegalArgumentException("cacheName and listener must not be null");
        }
        IRemoteCacheListener iRemoteCacheListener = (IRemoteCacheListener)iCacheListener;
        String string2 = iRemoteCacheListener.getLocalHostAddress();
        RemoteType remoteType = iRemoteCacheListener.getRemoteType();
        if (remoteType == RemoteType.CLUSTER) {
            log.debug("adding cluster listener, listenerAddress [" + string2 + "]");
            cacheListeners = this.getClusterListeners(string);
        } else {
            log.debug("adding normal listener, listenerAddress [" + string2 + "]");
            cacheListeners = this.getCacheListeners(string);
        }
        ConcurrentMap<Long, ICacheEventQueue<KK, VV>> concurrentMap = cacheListeners.eventQMap;
        RemoteCacheServer.cleanupEventQMap(concurrentMap);
        Class<ICacheListener> clazz = ICacheListener.class;
        synchronized (ICacheListener.class) {
            Object object;
            long l;
            block15: {
                l = 0L;
                try {
                    l = iCacheListener.getListenerId();
                    if (l == 0L) {
                        long l2 = this.nextListenerId();
                        if (log.isDebugEnabled()) {
                            log.debug("listener id=" + (l2 & 0xFFL) + " addded for cache [" + string + "], listenerAddress [" + string2 + "]");
                        }
                        iCacheListener.setListenerId(l2);
                        l = l2;
                        String string3 = "Adding vm listener under new id = [" + l2 + "], listenerAddress [" + string2 + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", string3);
                        if (log.isInfoEnabled()) {
                            log.info(string3);
                        }
                    } else {
                        String string4 = "Adding listener under existing id = [" + l + "], listenerAddress [" + string2 + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", string4);
                        if (log.isInfoEnabled()) {
                            log.info(string4);
                        }
                    }
                    this.idTypeMap.put(l, remoteType);
                    if (string2 != null) {
                        this.idIPMap.put(l, string2);
                    }
                }
                catch (IOException iOException) {
                    object = "Problem setting listener id, listenerAddress [" + string2 + "]";
                    log.error(object, iOException);
                    if (this.cacheEventLogger == null) break block15;
                    this.cacheEventLogger.logError("RemoteCacheServer", "addCacheListener", (String)object + " - " + iOException.getMessage());
                }
            }
            CacheEventQueueFactory<KK, VV> cacheEventQueueFactory = new CacheEventQueueFactory<KK, VV>();
            object = cacheEventQueueFactory.createCacheEventQueue(iCacheListener, l, string, this.remoteCacheServerAttributes.getEventQueuePoolName(), this.remoteCacheServerAttributes.getEventQueueType());
            concurrentMap.put(iCacheListener.getListenerId(), (ICacheEventQueue<KK, VV>)object);
            if (log.isInfoEnabled()) {
                log.info(cacheListeners);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public <KK, VV> void addCacheListener(ICacheListener<KK, VV> iCacheListener) throws IOException {
        for (String string : this.cacheListenersMap.keySet()) {
            this.addCacheListener(string, iCacheListener);
            if (!log.isDebugEnabled()) continue;
            log.debug("Adding listener for cache [" + string + "]");
        }
    }

    public <KK, VV> void removeCacheListener(String string, ICacheListener<KK, VV> iCacheListener) throws IOException {
        this.removeCacheListener(string, iCacheListener.getListenerId());
    }

    public void removeCacheListener(String string, long l) {
        String string2 = "Removing listener for cache region = [" + string + "] and listenerId [" + l + "]";
        this.logApplicationEvent("RemoteCacheServer", "removeCacheListener", string2);
        if (log.isInfoEnabled()) {
            log.info(string2);
        }
        boolean bl = this.isRequestFromCluster(l);
        CacheListeners<K, V> cacheListeners = null;
        cacheListeners = bl ? this.getClusterListeners(string) : this.getCacheListeners(string);
        ConcurrentMap concurrentMap = cacheListeners.eventQMap;
        RemoteCacheServer.cleanupEventQMap(concurrentMap);
        ICacheEventQueue iCacheEventQueue = (ICacheEventQueue)concurrentMap.remove(l);
        if (iCacheEventQueue != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found queue for cache region = [" + string + "] and listenerId  [" + l + "]");
            }
            iCacheEventQueue.destroy();
            RemoteCacheServer.cleanupEventQMap(concurrentMap);
        } else if (log.isDebugEnabled()) {
            log.debug("Did not find queue for cache region = [" + string + "] and listenerId [" + l + "]");
        }
        this.idTypeMap.remove(l);
        this.idIPMap.remove(l);
        if (log.isInfoEnabled()) {
            log.info("After removing listener [" + l + "] cache region " + string + "'s listener size [" + cacheListeners.eventQMap.size() + "]");
        }
    }

    public <KK, VV> void removeCacheListener(ICacheListener<KK, VV> iCacheListener) throws IOException {
        for (String string : this.cacheListenersMap.keySet()) {
            this.removeCacheListener(string, iCacheListener);
            if (!log.isInfoEnabled()) continue;
            log.info("Removing listener for cache [" + string + "]");
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown("", 1099);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(String string, int n) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("Received shutdown request. Shutting down server.");
        }
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            for (String string2 : this.cacheListenersMap.keySet()) {
                for (int i = 0; i <= this.listenerId[0]; ++i) {
                    this.removeCacheListener(string2, i);
                }
                if (!log.isInfoEnabled()) continue;
                log.info("Removing listener for cache [" + string2 + "]");
            }
            this.cacheListenersMap.clear();
            this.clusterListenersMap.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            RemoteCacheServerFactory.shutdownImpl(string, n);
            this.cacheManager.shutDown();
            return;
        }
    }

    @Override
    public void unreferenced() {
        if (log.isInfoEnabled()) {
            log.info("*** Server now unreferenced and subject to GC. ***");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextListenerId() {
        long l = 0L;
        if (this.listenerId[0] == Integer.MAX_VALUE) {
            int[] nArray = this.listenerId;
            synchronized (this.listenerId) {
                l = this.listenerId[0];
                this.listenerId[0] = 0;
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            this.listenerId[0] = this.listenerId[0] + 1;
            l = this.listenerId[0];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return l;
        }
    }

    @Override
    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    private ICacheEvent<ICacheElement<K, V>> createICacheEvent(ICacheElement<K, V> iCacheElement, long l, String string) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent<ICacheElement<K, V>>();
        }
        String string2 = this.getExtraInfoForRequesterId(l);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", iCacheElement.getCacheName(), string, string2, iCacheElement);
    }

    private <T> ICacheEvent<T> createICacheEvent(String string, T t, long l, String string2) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent();
        }
        String string3 = this.getExtraInfoForRequesterId(l);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", string, string2, string3, t);
    }

    protected void logApplicationEvent(String string, String string2, String string3) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(string, string2, string3);
        }
    }

    protected <T> void logICacheEvent(ICacheEvent<T> iCacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(iCacheEvent);
        }
    }

    protected String getExtraInfoForRequesterId(long l) {
        String string = (String)this.idIPMap.get(l);
        return string;
    }

    public void setCacheEventLogger(ICacheEventLogger iCacheEventLogger) {
        this.cacheEventLogger = iCacheEventLogger;
    }
}

