/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected transient Shortcut sc;
    private transient LayerChangeAdapter layerChangeAdapter;
    private transient ActiveLayerChangeAdapter activeLayerChangeAdapter;
    private transient SelectionChangeAdapter selectionChangeAdapter;

    public JosmAction(String string, ImageProvider imageProvider, String string2, Shortcut shortcut, boolean bl, String string3, boolean bl2) {
        super(string);
        if (imageProvider != null) {
            imageProvider.getResource().attachImageIcon(this, true);
        }
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null && !this.sc.isAutomatic()) {
            MainApplication.registerActionShortcut(this, this.sc);
        }
        this.setTooltip(string2);
        if (this.getValue("toolbar") == null) {
            this.putValue("toolbar", string3);
        }
        if (bl && MainApplication.getToolbar() != null) {
            MainApplication.getToolbar().register(this);
        }
        if (bl2) {
            this.installAdapters();
        }
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4, boolean bl2) {
        this(string, string2 == null ? null : new ImageProvider(string2), string3, shortcut, bl, string4 == null ? string2 : string4, bl2);
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, boolean bl2) {
        this(string, string2, string3, shortcut, bl, null, bl2);
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        this(string, string2, string3, shortcut, bl, null, true);
    }

    public JosmAction() {
        this(true);
    }

    public JosmAction(boolean bl) {
        this.setHelpId();
        if (bl) {
            this.installAdapters();
        }
    }

    protected void installAdapters() {
        if (this.listenToLayerChange()) {
            this.layerChangeAdapter = new LayerChangeAdapter();
            this.activeLayerChangeAdapter = new ActiveLayerChangeAdapter();
            this.getLayerManager().addLayerChangeListener(this.layerChangeAdapter);
            this.getLayerManager().addActiveLayerChangeListener(this.activeLayerChangeAdapter);
        }
        if (this.listenToSelectionChange()) {
            this.selectionChangeAdapter = new SelectionChangeAdapter();
            SelectionEventManager.getInstance().addSelectionListener(this.selectionChangeAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        }
        this.initEnabledState();
    }

    protected boolean listenToLayerChange() {
        return true;
    }

    protected boolean listenToSelectionChange() {
        return true;
    }

    @Override
    public void destroy() {
        if (this.sc != null && !this.sc.isAutomatic()) {
            MainApplication.unregisterActionShortcut(this);
        }
        if (this.layerChangeAdapter != null) {
            this.getLayerManager().removeLayerChangeListener(this.layerChangeAdapter);
            this.getLayerManager().removeActiveLayerChangeListener(this.activeLayerChangeAdapter);
        }
        if (this.selectionChangeAdapter != null) {
            DataSet.removeSelectionListener(this.selectionChangeAdapter);
        }
    }

    private void setHelpId() {
        String string = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - 6);
        }
        this.putValue("help", string);
    }

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut", new Object[0]), 65535, 5000);
        }
        return this.sc;
    }

    public final void setTooltip(String string) {
        if (string != null) {
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, this.sc));
        }
    }

    public MainLayerManager getLayerManager() {
        return MainApplication.getLayerManager();
    }

    protected static void waitFuture(Future<?> future, PleaseWaitProgressMonitor pleaseWaitProgressMonitor) {
        MainApplication.worker.submit(() -> {
            try {
                future.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException exception) {
                Logging.error(exception);
                return;
            }
            pleaseWaitProgressMonitor.close();
        });
    }

    protected void initEnabledState() {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
    }

    protected final void updateEnabledStateOnCurrentSelection() {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(dataSet.getSelected());
        }
    }

    protected class SelectionChangeAdapter
    implements SelectionChangedListener {
        protected SelectionChangeAdapter() {
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            JosmAction.this.updateEnabledState(collection);
        }

        public String toString() {
            return "SelectionChangeAdapter [" + JosmAction.this + ']';
        }
    }

    protected class ActiveLayerChangeAdapter
    implements MainLayerManager.ActiveLayerChangeListener {
        protected ActiveLayerChangeAdapter() {
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
            JosmAction.this.updateEnabledState();
        }

        public String toString() {
            return "ActiveLayerChangeAdapter [" + JosmAction.this + ']';
        }
    }

    protected class LayerChangeAdapter
    implements LayerManager.LayerChangeListener {
        protected LayerChangeAdapter() {
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
            JosmAction.this.updateEnabledState();
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
            JosmAction.this.updateEnabledState();
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
            JosmAction.this.updateEnabledState();
        }

        public String toString() {
            return "LayerChangeAdapter [" + JosmAction.this + ']';
        }
    }
}

