/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangeNodesCommand
extends Command {
    private final Way way;
    private final List<Node> newNodes;

    public ChangeNodesCommand(Way way, List<Node> list) {
        this.way = way;
        this.newNodes = list;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Cannot set nodes to be an empty list.");
        }
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.way.setNodes(this.newNodes);
        this.way.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.way);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Change nodes of {0}", this.way.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(OsmPrimitiveType.WAY);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.way, this.newNodes);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangeNodesCommand changeNodesCommand = (ChangeNodesCommand)object;
        return Objects.equals(this.way, changeNodesCommand.way) && Objects.equals(this.newNodes, changeNodesCommand.newNodes);
    }
}

