/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class VersionTableModel
extends AbstractTableModel {
    private final HistoryBrowserModel model;

    public VersionTableModel(HistoryBrowserModel historyBrowserModel) {
        this.model = historyBrowserModel;
    }

    @Override
    public int getRowCount() {
        if (this.model.getHistory() == null) {
            return 0;
        }
        int n = this.model.getHistory().getNumVersions();
        if (this.model.getLatest() != null) {
            ++n;
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                HistoryOsmPrimitive historyOsmPrimitive = this.model.getPrimitive(n);
                if (historyOsmPrimitive != null) {
                    return Long.toString(historyOsmPrimitive.getVersion());
                }
                return null;
            }
            case 1: {
                return this.model.isReferencePointInTime(n);
            }
            case 2: {
                return this.model.isCurrentPointInTime(n);
            }
            case 3: {
                HistoryOsmPrimitive historyOsmPrimitive = this.model.getPrimitive(n);
                if (historyOsmPrimitive != null && historyOsmPrimitive.getTimestamp() != null) {
                    return DateUtils.formatDateTime(historyOsmPrimitive.getTimestamp(), 3, 3);
                }
                return null;
            }
            case 4: {
                User user;
                HistoryOsmPrimitive historyOsmPrimitive = this.model.getPrimitive(n);
                if (historyOsmPrimitive != null && (user = historyOsmPrimitive.getUser()) != null) {
                    return user.getName();
                }
                return null;
            }
            case 5: {
                Changeset changeset;
                HistoryOsmPrimitive historyOsmPrimitive = this.model.getPrimitive(n);
                if (historyOsmPrimitive != null && (changeset = historyOsmPrimitive.getChangeset()) != null) {
                    return changeset.get("created_by");
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (!((Boolean)object).booleanValue()) {
            return;
        }
        try {
            switch (n2) {
                case 1: {
                    this.model.setReferencePointInTime(n);
                    break;
                }
                case 2: {
                    this.model.setCurrentPointInTime(n);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.error(illegalArgumentException);
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 >= 1 && n2 <= 2;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }
}

