/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportQueue;

public class ReportedException
extends RuntimeException {
    private static final int MAX_COLLECTION_ENTRIES = 30;
    private static final long serialVersionUID = 737333873766201033L;
    private final transient Map<Thread, StackTraceElement[]> allStackTraces;
    private final LinkedList<Section> sections = new LinkedList();
    private final transient Thread caughtOnThread;
    private String methodWarningFrom;

    ReportedException(Throwable throwable) {
        this(throwable, Thread.currentThread());
    }

    ReportedException(Throwable throwable, Thread thread) {
        super(throwable);
        this.allStackTraces = Thread.getAllStackTraces();
        this.caughtOnThread = thread;
    }

    public void warn() {
        this.methodWarningFrom = BugReport.getCallingMethod(2);
        try {
            BugReportQueue.getInstance().submit(this);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public void startSection(String string) {
        this.sections.add(new Section(string));
    }

    public void printReportDataTo(PrintWriter printWriter) {
        printWriter.println("=== REPORTED CRASH DATA ===");
        for (Section section : this.sections) {
            section.printSection(printWriter);
            printWriter.println();
        }
        if (this.methodWarningFrom != null) {
            printWriter.println("Warning issued by: " + this.methodWarningFrom);
            printWriter.println();
        }
    }

    public void printReportStackTo(PrintWriter printWriter) {
        printWriter.println("=== STACK TRACE ===");
        printWriter.println(ReportedException.niceThreadName(this.caughtOnThread));
        this.getCause().printStackTrace(printWriter);
        printWriter.println();
    }

    public void printReportThreadsTo(PrintWriter printWriter) {
        printWriter.println("=== RUNNING THREADS ===");
        for (Map.Entry<Thread, StackTraceElement[]> entry : this.allStackTraces.entrySet()) {
            printWriter.println(ReportedException.niceThreadName(entry.getKey()));
            if (this.caughtOnThread.equals(entry.getKey())) {
                printWriter.println("Stacktrace see above.");
            } else {
                for (StackTraceElement stackTraceElement : entry.getValue()) {
                    printWriter.println(stackTraceElement);
                }
            }
            printWriter.println();
        }
    }

    private static String niceThreadName(Thread thread) {
        StringBuilder stringBuilder = new StringBuilder("Thread: ").append(thread.getName()).append(" (").append(thread.getId()).append(')');
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup != null) {
            stringBuilder.append(" of ").append(threadGroup.getName());
        }
        return stringBuilder.toString();
    }

    public boolean isSame(ReportedException reportedException) {
        if (!this.getMessage().equals(reportedException.getMessage())) {
            return false;
        }
        return ReportedException.hasSameStackTrace(new CauseTraceIterator(), reportedException.getCause());
    }

    private static boolean hasSameStackTrace(CauseTraceIterator causeTraceIterator, Throwable throwable) {
        Throwable throwable2;
        Object[] objectArray;
        if (!causeTraceIterator.hasNext()) {
            return true;
        }
        Throwable throwable3 = causeTraceIterator.next();
        Object[] objectArray2 = throwable3.getStackTrace();
        if (!Arrays.equals(objectArray2, objectArray = throwable.getStackTrace())) {
            return false;
        }
        Throwable throwable4 = throwable3.getCause();
        if (throwable4 == null != ((throwable2 = throwable.getCause()) == null)) {
            return false;
        }
        if (throwable4 != null) {
            return ReportedException.hasSameStackTrace(causeTraceIterator, throwable2);
        }
        return true;
    }

    public ReportedException put(String string, Object object) {
        return this.put(string, () -> object);
    }

    public ReportedException put(String string, Supplier<Object> supplier) {
        String string2;
        try {
            Object object = supplier.get();
            string2 = object == null ? "null" : (object instanceof Collection ? ReportedException.makeCollectionNice((Collection)object) : (object.getClass().isArray() ? ReportedException.makeCollectionNice(Arrays.asList(object)) : object.toString()));
        }
        catch (RuntimeException runtimeException) {
            Logging.warn(runtimeException);
            string2 = "<Error calling toString()>";
        }
        this.sections.getLast().put(string, string2);
        return this;
    }

    private static String makeCollectionNice(Collection<?> collection) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(32);
        for (Object obj : collection) {
            stringBuilder.append("\n    - ");
            if (n <= 30) {
                stringBuilder.append(obj);
                continue;
            }
            stringBuilder.append("\n    ... (").append(collection.size()).append(" entries)");
            break;
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return "ReportedException [thread=" + this.caughtOnThread + ", exception=" + this.getCause() + ", methodWarningFrom=" + this.methodWarningFrom + ']';
    }

    public boolean mayHaveConcurrentSource() {
        return StreamUtils.toStream(() -> new CauseTraceIterator()).anyMatch(throwable -> throwable instanceof ConcurrentModificationException || throwable instanceof InvocationTargetException);
    }

    public boolean isOutOfMemory() {
        return StreamUtils.toStream(() -> new CauseTraceIterator()).anyMatch(throwable -> throwable instanceof OutOfMemoryError);
    }

    private static class Section
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String sectionName;
        private final ArrayList<SectionEntry> entries = new ArrayList();

        Section(String string) {
            this.sectionName = string;
        }

        public void put(String string, String string2) {
            this.entries.add(new SectionEntry(string, string2));
        }

        public void printSection(PrintWriter printWriter) {
            printWriter.println(this.sectionName + ':');
            if (this.entries.isEmpty()) {
                printWriter.println("No data collected.");
            } else {
                for (SectionEntry sectionEntry : this.entries) {
                    sectionEntry.print(printWriter);
                }
            }
        }
    }

    private static class SectionEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final String value;

        SectionEntry(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public void print(PrintWriter printWriter) {
            printWriter.print(" - ");
            printWriter.print(this.key);
            printWriter.print(": ");
            printWriter.println(this.value);
        }
    }

    private final class CauseTraceIterator
    implements Iterator<Throwable> {
        private Throwable current;
        private final Set<Throwable> dejaVu;

        private CauseTraceIterator() {
            this.current = ReportedException.this.getCause();
            this.dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Throwable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Throwable throwable = this.current;
            this.advance();
            return throwable;
        }

        private void advance() {
            this.dejaVu.add(this.current);
            this.current = this.current.getCause();
            if (this.current != null && this.dejaVu.contains(this.current)) {
                this.current = null;
            }
        }
    }
}

