/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.io.TextStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;
import org.jetbrains.kotlin.js.util.TextOutput;

public class SourceMap3Builder
implements SourceMapBuilder {
    private final StringBuilder out = new StringBuilder(8192);
    private final File generatedFile;
    private final TextOutput textOutput;
    private final String pathPrefix;
    private final TObjectIntHashMap<SourceKey> sources = new TObjectIntHashMap<SourceKey>(){

        @Override
        public int get(SourceKey key) {
            int index2 = this.index(key);
            return index2 < 0 ? -1 : this._values[index2];
        }
    };
    private final List<String> orderedSources = new ArrayList<String>();
    private final List<Supplier<Reader>> orderedSourceContentSuppliers = new ArrayList<Supplier<Reader>>();
    private int previousGeneratedColumn = -1;
    private int previousSourceIndex;
    private int previousSourceLine;
    private int previousSourceColumn;
    private int previousMappingOffset;
    private int previousPreviousSourceIndex;
    private int previousPreviousSourceLine;
    private int previousPreviousSourceColumn;
    private boolean currentMappingIsEmpty = true;

    public SourceMap3Builder(File generatedFile, TextOutput textOutput, String pathPrefix) {
        this.generatedFile = generatedFile;
        this.textOutput = textOutput;
        this.pathPrefix = pathPrefix;
    }

    @Override
    public File getOutFile() {
        return new File(this.generatedFile.getParentFile(), this.generatedFile.getName() + ".map");
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder(this.out.length() + 128 * this.orderedSources.size());
        sb.append("{\"version\":3,\"file\":\"").append(this.generatedFile.getName()).append('\"').append(',');
        this.appendSources(sb);
        sb.append(",");
        this.appendSourcesContent(sb);
        sb.append(",\"names\":[");
        sb.append("],\"mappings\":\"");
        sb.append((CharSequence)this.out);
        sb.append("\"}");
        return sb.toString();
    }

    private void appendSources(StringBuilder sb) {
        boolean isNotFirst = false;
        sb.append('\"').append("sources").append("\":[");
        for (String source : this.orderedSources) {
            if (isNotFirst) {
                sb.append(',');
            } else {
                isNotFirst = true;
            }
            sb.append(JsToStringGenerationVisitor.javaScriptString(this.pathPrefix + source, true));
        }
        sb.append(']');
    }

    private void appendSourcesContent(StringBuilder sb) {
        boolean isNotFirst = false;
        sb.append('\"').append("sourcesContent").append("\":[");
        for (Supplier<Reader> contentSupplier : this.orderedSourceContentSuppliers) {
            if (isNotFirst) {
                sb.append(',');
            } else {
                isNotFirst = true;
            }
            Reader reader = contentSupplier.get();
            if (reader != null) {
                sb.append(JsToStringGenerationVisitor.javaScriptString(TextStreamsKt.readText(reader), true));
                continue;
            }
            sb.append("null");
        }
        sb.append(']');
    }

    @Override
    public void newLine() {
        this.out.append(';');
        this.previousGeneratedColumn = -1;
    }

    @Override
    public void skipLinesAtBeginning(int count) {
        this.out.insert(0, StringUtil.repeatSymbol(';', count));
    }

    private int getSourceIndex(String source, Object identityObject, Supplier<Reader> contentSupplier) {
        SourceKey key = new SourceKey(source, identityObject);
        int sourceIndex = this.sources.get(key);
        if (sourceIndex == -1) {
            sourceIndex = this.orderedSources.size();
            this.sources.put(key, sourceIndex);
            this.orderedSources.add(source);
            this.orderedSourceContentSuppliers.add(contentSupplier);
        }
        return sourceIndex;
    }

    @Override
    public void addMapping(@NotNull String source, @Nullable Object identityObject, @NotNull Supplier<Reader> sourceContent, int sourceLine, int sourceColumn) {
        if (source == null) {
            SourceMap3Builder.$$$reportNull$$$0(0);
        }
        if (sourceContent == null) {
            SourceMap3Builder.$$$reportNull$$$0(1);
        }
        source = source.replace(File.separatorChar, '/');
        int sourceIndex = this.getSourceIndex(source, identityObject, sourceContent);
        if (!this.currentMappingIsEmpty && this.previousSourceIndex == sourceIndex && this.previousSourceLine == sourceLine && this.previousSourceColumn == sourceColumn) {
            return;
        }
        this.startMapping();
        Base64VLQ.encode(this.out, sourceIndex - this.previousSourceIndex);
        this.previousSourceIndex = sourceIndex;
        Base64VLQ.encode(this.out, sourceLine - this.previousSourceLine);
        this.previousSourceLine = sourceLine;
        Base64VLQ.encode(this.out, sourceColumn - this.previousSourceColumn);
        this.previousSourceColumn = sourceColumn;
        this.currentMappingIsEmpty = false;
    }

    @Override
    public void addEmptyMapping() {
        if (!this.currentMappingIsEmpty) {
            this.startMapping();
            this.currentMappingIsEmpty = true;
        }
    }

    private void startMapping() {
        boolean newGroupStarted;
        boolean bl = newGroupStarted = this.previousGeneratedColumn == -1;
        if (newGroupStarted) {
            this.previousGeneratedColumn = 0;
        }
        int columnDiff = this.textOutput.getColumn() - this.previousGeneratedColumn;
        if (!newGroupStarted) {
            this.out.append(',');
        }
        if (columnDiff > 0 || newGroupStarted) {
            Base64VLQ.encode(this.out, columnDiff);
            this.previousGeneratedColumn = this.textOutput.getColumn();
            this.previousMappingOffset = this.out.length();
            this.previousPreviousSourceIndex = this.previousSourceIndex;
            this.previousPreviousSourceLine = this.previousSourceLine;
            this.previousPreviousSourceColumn = this.previousSourceColumn;
        } else {
            this.out.setLength(this.previousMappingOffset);
            this.previousSourceIndex = this.previousPreviousSourceIndex;
            this.previousSourceLine = this.previousPreviousSourceLine;
            this.previousSourceColumn = this.previousPreviousSourceColumn;
        }
    }

    @Override
    public void addLink() {
        this.textOutput.print("\n//# sourceMappingURL=");
        this.textOutput.print(this.generatedFile.getName());
        this.textOutput.print(".map\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceContent";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/sourceMap/SourceMap3Builder";
        objectArray[2] = "addMapping";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class SourceKey {
        private final String sourcePath;
        private final Object identityKey;

        SourceKey(String sourcePath, Object identityKey) {
            this.sourcePath = sourcePath;
            this.identityKey = identityKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceKey)) {
                return false;
            }
            SourceKey key = (SourceKey)o;
            if (!this.sourcePath.equals(key.sourcePath)) {
                return false;
            }
            return !(this.identityKey != null ? !this.identityKey.equals(key.identityKey) : key.identityKey != null);
        }

        public int hashCode() {
            int result2 = this.sourcePath.hashCode();
            result2 = 31 * result2 + (this.identityKey != null ? this.identityKey.hashCode() : 0);
            return result2;
        }
    }

    private static final class Base64VLQ {
        private static final char[] BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

        private Base64VLQ() {
        }

        private static int toVLQSigned(int value) {
            return value < 0 ? (-value << 1) + 1 : value << 1;
        }

        public static void encode(StringBuilder out, int value) {
            value = Base64VLQ.toVLQSigned(value);
            do {
                int digit = value & 0x1F;
                if ((value >>>= 5) > 0) {
                    digit |= 0x20;
                }
                out.append(BASE64_MAP[digit]);
            } while (value > 0);
        }
    }
}

