/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.bridge;

import java.util.Arrays;
import org.gephi.graph.api.ColumnObserver;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.Node;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.edge.EdgeModeler;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.model.node.NodeModeler;
import org.gephi.visualization.octree.Octree;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.text.TextManager;
import org.gephi.visualization.text.TextModelImpl;
import org.openide.util.Lookup;

public class DataBridge
implements VizArchitecture {
    protected static final long ONEOVERPHI = 106039L;
    protected AbstractEngine engine;
    protected GraphController controller;
    protected TextManager textManager;
    protected ColumnObserver[] nodeColumnObservers;
    protected ColumnObserver[] edgeColumnObservers;
    protected int nodeColumnHashCode;
    protected int edgeColumnHashCode;
    private VizConfig vizConfig;
    private TextModelImpl textModel;
    protected GraphLimits limits;
    protected GraphModel graphModel;
    protected Graph graph;
    protected GraphObserver observer;
    protected NodeModel[] nodes;
    protected EdgeModel[] edges;

    @Override
    public void initArchitecture() {
        this.engine = VizController.getInstance().getEngine();
        this.controller = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.vizConfig = VizController.getInstance().getVizConfig();
        this.limits = VizController.getInstance().getLimits();
        this.textManager = VizController.getInstance().getTextManager();
    }

    public synchronized boolean updateWorld() {
        Octree octree;
        boolean force = false;
        if (this.observer != null && this.observer.isDestroyed() || this.graphModel != null && this.graph.getView() != this.graphModel.getVisibleView()) {
            if (this.observer != null && !this.observer.isDestroyed()) {
                this.observer.destroy();
            }
            this.observer = null;
            if (this.graphModel != null) {
                this.graph.writeLock();
                this.graph = this.graphModel.getGraphVisible();
                this.observer = this.graphModel.createGraphObserver(this.graph, false);
                force = true;
                this.graph.writeUnlock();
            }
        }
        if (force || this.observer != null && (this.observer.isNew() || this.observer.hasGraphChanged()) || this.hasColumnsChanged()) {
            if (this.observer.isNew()) {
                this.observer.hasGraphChanged();
            }
            NodeModeler nodeModeler = this.engine.getNodeModeler();
            EdgeModeler edgeModeler = this.engine.getEdgeModeler();
            Octree octree2 = this.engine.getOctree();
            int removedNodes = 0;
            int addedNodes = 0;
            int removedEdges = 0;
            int addedEdges = 0;
            this.graph.readLock();
            boolean isView = !this.graph.getView().isMainView();
            for (int i = 0; i < this.nodes.length; ++i) {
                NodeModel node = this.nodes[i];
                if (node == null || node.getNode().getStoreId() != -1 && (!isView || this.graph.contains(node.getNode()))) continue;
                octree2.removeNode(node);
                this.nodes[i] = null;
                ++removedNodes;
            }
            for (NodeModel node : this.graph.getNodes()) {
                NodeModel model;
                int id = node.getStoreId();
                if (id >= this.nodes.length || this.nodes[id] == null) {
                    this.growNodes(id);
                    model = nodeModeler.initModel((Node)node);
                    octree2.addNode(model);
                    this.nodes[id] = model;
                    ++addedNodes;
                } else {
                    model = this.nodes[id];
                }
                this.textManager.refreshNode(this.graph, model, this.textModel);
            }
            for (int i = 0; i < this.edges.length; ++i) {
                NodeModel targetModel;
                EdgeModel edge = this.edges[i];
                if (edge == null || edge.getEdge().getStoreId() != -1 && (!isView || this.graph.contains(edge.getEdge()))) continue;
                int sourceId = edge.getEdge().getSource().getStoreId();
                int targetId = edge.getEdge().getTarget().getStoreId();
                NodeModel sourceModel = sourceId == -1 ? null : this.nodes[sourceId];
                NodeModel nodeModel = targetModel = targetId == -1 ? null : this.nodes[targetId];
                if (sourceModel != null) {
                    sourceModel.removeEdge(edge);
                }
                if (targetModel != null && sourceModel != targetModel) {
                    targetModel.removeEdge(edge);
                }
                this.edges[i] = null;
                ++removedEdges;
            }
            float minWeight = Float.MAX_VALUE;
            float maxWeight = Float.MIN_VALUE;
            for (Edge edge : this.graph.getEdges()) {
                EdgeModel model;
                int id = edge.getStoreId();
                if (id >= this.edges.length || this.edges[id] == null) {
                    this.growEdges(id);
                    NodeModel sourceModel = this.nodes[edge.getSource().getStoreId()];
                    NodeModel targetModel = this.nodes[edge.getTarget().getStoreId()];
                    model = edgeModeler.initModel(edge, sourceModel, targetModel);
                    sourceModel.addEdge(model);
                    if (targetModel != sourceModel) {
                        targetModel.addEdge(model);
                    }
                    this.edges[id] = model;
                    ++addedEdges;
                } else {
                    model = this.edges[id];
                }
                float w = (float)edge.getWeight(this.graph.getView());
                model.setWeight(w);
                minWeight = Math.min(w, minWeight);
                maxWeight = Math.max(w, maxWeight);
                this.textManager.refreshEdge(this.graph, model, this.textModel);
            }
            if (!isView) {
                this.limits.setMaxWeight(maxWeight);
                this.limits.setMinWeight(minWeight);
            }
            this.graph.readUnlock();
            return true;
        }
        if (this.observer == null && !(octree = this.engine.getOctree()).isEmpty()) {
            octree.clear();
        }
        return false;
    }

    private boolean hasColumnsChanged() {
        if (this.nodeColumnObservers != null && this.edgeColumnObservers != null) {
            Object[] nodeColumns = this.textModel.getNodeTextColumns();
            int nodeCode = Arrays.hashCode(nodeColumns);
            if (nodeCode != this.nodeColumnHashCode) {
                this.refreshNodeColumns(this.textModel);
                return true;
            }
            Object[] edgeColumns = this.textModel.getEdgeTextColumns();
            int edgeCode = Arrays.hashCode(edgeColumns);
            if (edgeCode != this.edgeColumnHashCode) {
                this.refreshEdgeColumns(this.textModel);
                return true;
            }
            boolean nodeC = false;
            boolean edgeC = false;
            for (ColumnObserver c : this.nodeColumnObservers) {
                nodeC |= c.hasColumnChanged();
            }
            for (ColumnObserver c : this.edgeColumnObservers) {
                edgeC |= c.hasColumnChanged();
            }
            return nodeC || edgeC;
        }
        return false;
    }

    public synchronized void reset() {
        this.graphModel = this.controller.getGraphModel();
        if (this.graphModel != null) {
            this.graph = this.graphModel.getGraphVisible();
        }
        if (this.observer != null && (this.graphModel == null || this.observer.getGraph() != this.graph)) {
            if (!this.observer.isDestroyed()) {
                this.observer.destroy();
            }
            this.observer = null;
        }
        if (this.nodeColumnObservers != null) {
            for (ColumnObserver c : this.nodeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.nodeColumnObservers = null;
        }
        if (this.edgeColumnObservers != null) {
            for (ColumnObserver c : this.edgeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.edgeColumnObservers = null;
        }
        this.nodes = new NodeModel[10];
        this.edges = new EdgeModel[10];
        Octree octree = this.engine.getOctree();
        if (!octree.isEmpty()) {
            octree.clear();
        }
        if (this.graphModel != null) {
            this.observer = this.graphModel.createGraphObserver(this.graph, false);
            this.textModel = VizController.getInstance().getVizModel().getTextModel();
            this.refreshNodeColumns(this.textModel);
            this.refreshEdgeColumns(this.textModel);
        }
    }

    private void refreshNodeColumns(TextModelImpl textModelImpl) {
        if (this.nodeColumnObservers != null) {
            for (ColumnObserver c : this.nodeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.nodeColumnObservers = null;
        }
        Object[] nodeColumns = textModelImpl.getNodeTextColumns();
        this.nodeColumnHashCode = Arrays.hashCode(nodeColumns);
        this.nodeColumnObservers = new ColumnObserver[nodeColumns.length];
        for (int i = 0; i < nodeColumns.length; ++i) {
            this.nodeColumnObservers[i] = nodeColumns[i].createColumnObserver(false);
        }
    }

    private void refreshEdgeColumns(TextModelImpl textModelImpl) {
        if (this.edgeColumnObservers != null) {
            for (ColumnObserver c : this.edgeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.edgeColumnObservers = null;
        }
        Object[] edgeColumns = textModelImpl.getEdgeTextColumns();
        this.edgeColumnHashCode = Arrays.hashCode(edgeColumns);
        this.edgeColumnObservers = new ColumnObserver[edgeColumns.length];
        for (int i = 0; i < edgeColumns.length; ++i) {
            this.edgeColumnObservers[i] = edgeColumns[i].createColumnObserver(false);
        }
    }

    public boolean isDirected() {
        return this.graphModel != null && !this.graphModel.isUndirected();
    }

    public Graph getGraph() {
        return this.graph;
    }

    private void growNodes(int index) {
        if (this.nodes == null) {
            this.nodes = new NodeModel[10];
        } else if (index >= this.nodes.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.nodes.length >>> 16, (long)(index + 1)), Integer.MAX_VALUE);
            NodeModel[] t = new NodeModel[newLength];
            System.arraycopy(this.nodes, 0, t, 0, this.nodes.length);
            this.nodes = t;
        }
    }

    private void growEdges(int index) {
        if (this.edges == null) {
            this.edges = new EdgeModel[10];
        } else if (index >= this.edges.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.edges.length >>> 16, (long)(index + 1)), Integer.MAX_VALUE);
            EdgeModel[] t = new EdgeModel[newLength];
            System.arraycopy(this.edges, 0, t, 0, this.edges.length);
            this.edges = t;
        }
    }
}

