/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.model.edge;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.ElementProperties;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.model.Model;
import org.gephi.visualization.model.TextModel;
import org.gephi.visualization.model.node.NodeModel;

public abstract class EdgeModel
implements Model,
TextModel {
    protected final Edge edge;
    protected float weight;
    protected boolean selected;
    public int markTime;
    protected int octantSourceId;
    protected int octantTargetId;
    protected final float[] color = new float[4];

    public EdgeModel(Edge edge) {
        this.edge = edge;
        this.markTime = 0;
    }

    public abstract NodeModel getSourceModel();

    public abstract NodeModel getTargetModel();

    public abstract boolean isAutoSelected();

    public abstract void displayArrow(GL2 var1, GLU var2, VizModel var3);

    public Edge getEdge() {
        return this.edge;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    @Override
    public boolean hasCustomTextColor() {
        return this.edge.getTextProperties().getAlpha() > 0.0f;
    }

    @Override
    public void setText(String text) {
        this.edge.getTextProperties().setText(text);
    }

    @Override
    public float getTextWidth() {
        return this.edge.getTextProperties().getWidth();
    }

    @Override
    public float getTextHeight() {
        return this.edge.getTextProperties().getHeight();
    }

    @Override
    public String getText() {
        return this.edge.getTextProperties().getText();
    }

    @Override
    public float getTextSize() {
        return this.edge.getTextProperties().getSize();
    }

    @Override
    public float getTextR() {
        return this.edge.getTextProperties().getR();
    }

    @Override
    public float getTextG() {
        return this.edge.getTextProperties().getG();
    }

    @Override
    public float getTextB() {
        return this.edge.getTextProperties().getB();
    }

    @Override
    public float getTextAlpha() {
        return this.edge.getTextProperties().getAlpha();
    }

    @Override
    public boolean isTextVisible() {
        return this.edge.getTextProperties().isVisible();
    }

    @Override
    public ElementProperties getElementProperties() {
        return this.edge;
    }

    public int getOctantSourceId() {
        return this.octantSourceId;
    }

    public int getOctantTargetId() {
        return this.octantTargetId;
    }

    public void setOctantSourceId(int octantSourceId) {
        this.octantSourceId = octantSourceId;
    }

    public void setOctantTargetId(int octantTargetId) {
        this.octantTargetId = octantTargetId;
    }

    public float[] getColor() {
        return this.color;
    }
}

