/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop.reporter;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gephi.branding.desktop.reporter.Report;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

public class ReportController {
    private static final String POST_URL = "http://gephi.org/crashreporter/report.php";

    public void sendReport(final Report report) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.sending"));
                try {
                    handle.start();
                    Document doc = ReportController.this.buildReportDocument(report);
                    if (doc != null && ReportController.this.sendDocument(doc)) {
                        handle.finish();
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.sent"), 1));
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                handle.finish();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.failed"), 2));
            }
        }, "Exception Reporter");
        thread.start();
    }

    public Document buildReportDocument(Report report) {
        this.logMessageLog(report);
        this.logVersion(report);
        this.logScreenSize(report);
        this.logCPU(report);
        this.logMemoryInfo(report);
        this.logJavaInfo(report);
        this.logGLInfo(report);
        return this.buildXMLDocument(report);
    }

    public boolean sendDocument(Document document) {
        try {
            int num;
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            String xmlString = "report=" + URLEncoder.encode(sw.toString(), "UTF-8");
            URL url = new URL(POST_URL);
            URLConnection con = url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setDefaultUseCaches(false);
            OutputStreamWriter writer = new OutputStreamWriter(con.getOutputStream());
            writer.write(xmlString);
            writer.flush();
            writer.close();
            InputStreamReader reader = new InputStreamReader(con.getInputStream());
            StringBuilder buf = new StringBuilder();
            char[] cbuf = new char[2048];
            while (-1 != (num = reader.read(cbuf))) {
                buf.append(cbuf, 0, num);
            }
            String serverResult = buf.toString();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Document buildXMLDocument(Report report) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            report.writeXml(document);
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void logScreenSize(Report report) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        report.setScreenSize(screenSize);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        report.setScreenDevices(ge.getScreenDevices().length);
    }

    private void logCPU(Report report) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        report.setNumberOfProcessors(bean.getAvailableProcessors());
        String unknown = "unknown";
        String str = System.getProperty("os.name", unknown) + ", " + System.getProperty("os.version", unknown) + ", " + System.getProperty("os.arch", unknown);
        report.setOs(str);
    }

    private void logMemoryInfo(Report report) {
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        report.setHeapMemoryUsage(bean.getHeapMemoryUsage().toString());
        report.setNonHeapMemoryUsage(bean.getNonHeapMemoryUsage().toString());
    }

    private void logJavaInfo(Report report) {
        String str = System.getProperty("java.vm.name", "unknown") + ", " + System.getProperty("java.vm.version", "") + ", " + System.getProperty("java.runtime.name", "unknown") + ", " + System.getProperty("java.runtime.version", "");
        report.setVm(str);
    }

    private void logVersion(Report report) {
        String str = "";
        try {
            str = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
            report.setVersion(str);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void logGLInfo(Report report) {
        String output = report.getLog();
        try {
            String line;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(output));
            while ((line = lineNumberReader.readLine()) != null) {
                if (line.startsWith("GL_VENDOR:")) {
                    report.setGlVendor(line.substring(11));
                    continue;
                }
                if (line.startsWith("GL_RENDERER:")) {
                    report.setGlRenderer(line.substring(13));
                    continue;
                }
                if (!line.startsWith("GL_VERSION:")) continue;
                report.setGlVersion(line.substring(12));
                break;
            }
            lineNumberReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logModules(Report report) {
        for (ModuleInfo m : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            String moduleStr = "";
            SpecificationVersion specVersion = m.getSpecificationVersion();
            moduleStr = specVersion != null ? m.getCodeName() + " [" + specVersion.toString() + "]" : m.getCodeName();
            if (m.isEnabled()) {
                report.addEnabledModule(moduleStr);
                continue;
            }
            report.addDisabledModule(moduleStr);
        }
    }

    private void logMessageLog(Report report) {
        System.out.flush();
        String ud = System.getProperty("netbeans.user");
        if (ud == null || "memory".equals(ud)) {
            return;
        }
        Handler[] handlers = Logger.getLogger("").getHandlers();
        handlers[0].flush();
        File userDir = new File(ud);
        File directory = new File(new File(userDir, "var"), "log");
        File messagesLog = new File(directory, "messages.log");
        String log = "";
        try {
            byte[] buffer = new byte[(int)messagesLog.length()];
            BufferedInputStream f = new BufferedInputStream(new FileInputStream(messagesLog));
            f.read(buffer);
            log = new String(buffer);
        }
        catch (Exception e) {
            // empty catch block
        }
        report.setLog(log);
    }
}

