/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.io.export.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.gephi.desktop.io.export.ExportControllerUI;
import org.gephi.desktop.io.export.api.TopDialog;
import org.gephi.desktop.io.export.spi.ExporterClassUI;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.io.exporter.spi.VectorExporter;
import org.gephi.io.exporter.spi.VectorFileExporterBuilder;
import org.gephi.ui.utils.DialogFileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class VectorialFileExporterUI
implements ExporterClassUI {
    private VectorFileExporterBuilder selectedBuilder;
    private VectorExporter selectedExporter;
    private File selectedFile;
    private JDialog dialog;

    @Override
    public String getName() {
        return NbBundle.getMessage(VectorialFileExporterUI.class, (String)"VectorialFileExporterUI_title");
    }

    @Override
    public boolean isEnable() {
        return true;
    }

    @Override
    public void action() {
        String LAST_PATH = "VectorialFileExporterUI_Last_Path";
        String LAST_PATH_DEFAULT = "VectorialFileExporterUI_Last_Path_Default";
        final ExportControllerUI exportController = (ExportControllerUI)Lookup.getDefault().lookup(ExportControllerUI.class);
        if (exportController == null) {
            return;
        }
        String lastPathDefault = NbPreferences.forModule(VectorialFileExporterUI.class).get("VectorialFileExporterUI_Last_Path_Default", null);
        String lastPath = NbPreferences.forModule(VectorialFileExporterUI.class).get("VectorialFileExporterUI_Last_Path", lastPathDefault);
        FlowLayout layout = new FlowLayout(2);
        JPanel optionsPanel = new JPanel(layout);
        final JButton optionsButton = new JButton(NbBundle.getMessage(VectorialFileExporterUI.class, (String)"VectorialFileExporterUI_optionsButton_name"));
        optionsPanel.add(optionsButton);
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExporterUI exporterUI = exportController.getExportController().getUI((Exporter)VectorialFileExporterUI.this.selectedExporter);
                if (exporterUI != null) {
                    JPanel panel = exporterUI.getPanel();
                    exporterUI.setup((Exporter)VectorialFileExporterUI.this.selectedExporter);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(VectorialFileExporterUI.class, (String)"VectorialFileExporterUI_optionsDialog_title", (Object)VectorialFileExporterUI.this.selectedBuilder.getName()));
                    TopDialog topDialog = new TopDialog(VectorialFileExporterUI.this.dialog, dd.getTitle(), dd.isModal(), (NotifyDescriptor)dd, dd.getClosingOptions(), dd.getButtonListener());
                    topDialog.setVisible(true);
                    Object result = dd.getValue() != null ? dd.getValue() : NotifyDescriptor.CLOSED_OPTION;
                    exporterUI.unsetup(result == NotifyDescriptor.OK_OPTION);
                }
            }
        });
        final JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)optionsPanel, "North");
        final JFileChooser chooser = new JFileChooser(lastPath){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                VectorialFileExporterUI.this.dialog = super.createDialog(parent);
                Component c = VectorialFileExporterUI.this.dialog.getContentPane().getComponent(0);
                if (c != null && c instanceof JComponent) {
                    Insets insets = ((JComponent)c).getInsets();
                    southPanel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                }
                VectorialFileExporterUI.this.dialog.getContentPane().add((Component)southPanel, "South");
                return VectorialFileExporterUI.this.dialog;
            }

            @Override
            public void approveSelection() {
                if (VectorialFileExporterUI.this.canExport(this)) {
                    super.approveSelection();
                }
            }
        };
        chooser.setDialogTitle(NbBundle.getMessage(VectorialFileExporterUI.class, (String)"VectorialFileExporterUI_filechooser_title"));
        chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DialogFileFilter fileFilter = (DialogFileFilter)evt.getNewValue();
                VectorialFileExporterUI.this.selectedBuilder = VectorialFileExporterUI.this.getExporter(fileFilter);
                if (VectorialFileExporterUI.this.selectedBuilder != null) {
                    VectorialFileExporterUI.this.selectedExporter = VectorialFileExporterUI.this.selectedBuilder.buildExporter();
                }
                if (VectorialFileExporterUI.this.selectedExporter != null && exportController.getExportController().getUI((Exporter)VectorialFileExporterUI.this.selectedExporter) != null) {
                    optionsButton.setEnabled(true);
                } else {
                    optionsButton.setEnabled(false);
                }
                if (VectorialFileExporterUI.this.selectedFile != null && fileFilter != null) {
                    String fileName = VectorialFileExporterUI.this.selectedFile.getName();
                    String directoryPath = chooser.getCurrentDirectory().getAbsolutePath();
                    if (fileName.lastIndexOf(".") != -1) {
                        fileName = fileName.substring(0, fileName.lastIndexOf("."));
                        fileName = fileName.concat((String)fileFilter.getExtensions().get(0));
                        VectorialFileExporterUI.this.selectedFile = new File(directoryPath, fileName);
                        chooser.setSelectedFile(VectorialFileExporterUI.this.selectedFile);
                    }
                }
            }
        });
        chooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    VectorialFileExporterUI.this.selectedFile = (File)evt.getNewValue();
                }
            }
        });
        DialogFileFilter defaultFilter = null;
        for (VectorFileExporterBuilder vectorFileExporter : Lookup.getDefault().lookupAll(VectorFileExporterBuilder.class)) {
            for (FileType fileType : vectorFileExporter.getFileTypes()) {
                DialogFileFilter dialogFileFilter = new DialogFileFilter(fileType.getName());
                dialogFileFilter.addExtensions(fileType.getExtensions());
                if (defaultFilter == null) {
                    defaultFilter = dialogFileFilter;
                }
                chooser.addChoosableFileFilter((FileFilter)dialogFileFilter);
            }
        }
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter((FileFilter)defaultFilter);
        this.selectedFile = new File(chooser.getCurrentDirectory(), "Untitled" + (String)defaultFilter.getExtensions().get(0));
        chooser.setSelectedFile(this.selectedFile);
        int returnFile = chooser.showSaveDialog(null);
        if (returnFile == 0) {
            File file = chooser.getSelectedFile();
            file = FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            NbPreferences.forModule(VectorialFileExporterUI.class).put("VectorialFileExporterUI_Last_Path", file.getAbsolutePath());
            exportController.exportFile(fileObject, (Exporter)this.selectedExporter);
        }
        this.dialog = null;
    }

    private boolean canExport(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        String defaultExtention = this.selectedBuilder.getFileTypes()[0].getExtension();
        try {
            if (!file.getPath().endsWith(defaultExtention)) {
                file = new File(file.getPath() + defaultExtention);
                chooser.setSelectedFile(file);
            }
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    String failMsg = NbBundle.getMessage(VectorialFileExporterUI.class, (String)"VectorialFileExporterUI_SaveFailed", (Object[])new Object[]{file.getPath()});
                    JOptionPane.showMessageDialog(null, failMsg);
                    return false;
                }
            } else {
                String overwriteMsg = NbBundle.getMessage(VectorialFileExporterUI.class, (String)"VectorialFileExporterUI_overwriteDialog_message", (Object[])new Object[]{file.getPath()});
                if (JOptionPane.showConfirmDialog(null, overwriteMsg, NbBundle.getMessage(VectorialFileExporterUI.class, (String)"VectorialFileExporterUI_overwriteDialog_title"), 0) != 0) {
                    return false;
                }
            }
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage(), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
            return false;
        }
        return true;
    }

    private VectorFileExporterBuilder getExporter(DialogFileFilter fileFilter) {
        for (VectorFileExporterBuilder graphFileExporter : Lookup.getDefault().lookupAll(VectorFileExporterBuilder.class)) {
            for (FileType fileType : graphFileExporter.getFileTypes()) {
                DialogFileFilter tempFilter = new DialogFileFilter(fileType.getName());
                tempFilter.addExtensions(fileType.getExtensions());
                if (!tempFilter.equals((Object)fileFilter)) continue;
                return graphFileExporter;
            }
        }
        return null;
    }
}

