/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.api.datatables;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.joda.time.DateTimeZone;
import org.openide.util.Lookup;

public class AttributeTableCSVExporter {
    private static final Character DEFAULT_SEPARATOR = Character.valueOf(',');
    public static final int FAKE_COLUMN_EDGE_SOURCE = -1;
    public static final int FAKE_COLUMN_EDGE_TARGET = -2;
    public static final int FAKE_COLUMN_EDGE_TYPE = -3;

    public static void writeCSVFile(Graph graph, Table table, OutputStream out) throws IOException {
        AttributeTableCSVExporter.writeCSVFile(graph, table, out, null, null, null, null);
    }

    public static void writeCSVFile(Graph graph, Table table, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        AttributeTableCSVExporter.writeCSVFile(graph, table, new FileOutputStream(file), null, null, null, null);
    }

    public static void writeCSVFile(Graph graph, Table table, File file, Character separator, Charset charset, Integer[] columnIndexesToExport, Element[] rows) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        AttributeTableCSVExporter.writeCSVFile(graph, table, new FileOutputStream(file), separator, charset, columnIndexesToExport, rows);
    }

    public static void writeCSVFile(Graph graph, Table table, OutputStream out, Character separator, Charset charset, Integer[] columnIndexesToExport, Element[] rows) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("out cannot be null");
        }
        if (separator == null) {
            separator = DEFAULT_SEPARATOR;
        }
        if (charset == null) {
            charset = Charset.forName("UTF-8");
        }
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        boolean isEdgeTable = ac.isEdgeTable(table);
        if (rows == null) {
            rows = isEdgeTable ? graph.getEdges().toArray() : graph.getNodes().toArray();
        }
        TimeFormat timeFormat = graph.getModel().getTimeFormat();
        DateTimeZone timeZone = graph.getModel().getTimeZone();
        if (columnIndexesToExport == null) {
            ArrayList<Integer> columnIndexesToExportList = new ArrayList<Integer>();
            if (isEdgeTable) {
                columnIndexesToExportList.add(-1);
                columnIndexesToExportList.add(-2);
                columnIndexesToExportList.add(-3);
            }
            for (Column column : table) {
                columnIndexesToExportList.add(column.getIndex());
            }
            columnIndexesToExport = columnIndexesToExportList.toArray(new Integer[0]);
        }
        CsvWriter writer = new CsvWriter(out, separator.charValue(), charset);
        for (int column = 0; column < columnIndexesToExport.length; ++column) {
            String columnTitle;
            int columnIndex = columnIndexesToExport[column];
            if (columnIndex == -1) {
                writer.write("Source");
                continue;
            }
            if (columnIndex == -2) {
                writer.write("Target");
                continue;
            }
            if (columnIndex == -3) {
                writer.write("Type");
                continue;
            }
            String columnId = table.getColumn(columnIndex).getId();
            String columnHeader = columnId.equalsIgnoreCase(columnTitle = table.getColumn(columnIndex).getId()) ? columnTitle : columnId;
            writer.write(columnHeader, true);
        }
        writer.endRecord();
        for (int row = 0; row < rows.length; ++row) {
            for (int i = 0; i < columnIndexesToExport.length; ++i) {
                int columnIndex = columnIndexesToExport[i];
                Object value = columnIndex == -1 ? ((Edge)rows[row]).getSource().getId() : (columnIndex == -2 ? ((Edge)rows[row]).getTarget().getId() : (columnIndex == -3 ? (((Edge)rows[row]).isDirected() ? "Directed" : "Undirected") : rows[row].getAttribute(table.getColumn(columnIndex))));
                String text = value != null ? AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone) : "";
                writer.write(text, true);
            }
            writer.endRecord();
        }
        writer.close();
    }
}

