/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import java.awt.Color;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.impl.ColumnDraftImpl;
import org.gephi.io.importer.impl.ImportContainerImpl;
import org.openide.util.NbBundle;

public abstract class ElementDraftImpl
implements ElementDraft {
    protected final ImportContainerImpl container;
    protected final String id;
    protected String label;
    protected Color color;
    protected Color labelColor;
    protected float labelSize = -1.0f;
    protected boolean labelVisible = true;
    protected Object[] attributes;
    protected TimeSet timeSet;

    public ElementDraftImpl(ImportContainerImpl container, String id) {
        this.container = container;
        this.id = id;
        this.attributes = new Object[0];
    }

    abstract ColumnDraft getColumn(String var1);

    abstract ColumnDraft getColumn(String var1, Class var2);

    @Override
    public Double getGraphTimestamp() {
        return this.container.getTimestamp();
    }

    @Override
    public Interval getGraphInterval() {
        return this.container.getInterval();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    @Override
    public float getLabelSize() {
        return this.labelSize;
    }

    @Override
    public Color getLabelColor() {
        return this.labelColor;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Object getValue(String key) {
        ColumnDraft column = this.getColumn(key);
        if (column != null) {
            return this.getAttributeValue(((ColumnDraftImpl)column).getIndex());
        }
        return null;
    }

    @Override
    public void setColor(String r, String g, String b) {
        this.setColor(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
    }

    @Override
    public void setColor(float r, float g, float b) {
        r = Math.max(Math.min(r, 1.0f), 0.0f);
        g = Math.max(Math.min(g, 1.0f), 0.0f);
        b = Math.max(Math.min(b, 1.0f), 0.0f);
        this.setColor(new Color(r, g, b));
    }

    @Override
    public void setColor(int r, int g, int b) {
        this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    @Override
    public void setColor(String color) {
        Color cl = ImportUtils.parseColor(color);
        if (cl != null) {
            this.setColor(cl);
        } else {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_ColorParse", (Object)color, (Object)this.id);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.WARNING));
        }
    }

    @Override
    public void setLabelVisible(boolean labelVisible) {
        this.labelVisible = labelVisible;
    }

    @Override
    public void setLabelSize(float size) {
        this.labelSize = size;
    }

    @Override
    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    @Override
    public void setLabelColor(String r, String g, String b) {
        this.setLabelColor(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
    }

    @Override
    public void setLabelColor(float r, float g, float b) {
        r = Math.max(Math.min(r, 1.0f), 0.0f);
        g = Math.max(Math.min(g, 1.0f), 0.0f);
        b = Math.max(Math.min(b, 1.0f), 0.0f);
        this.setLabelColor(new Color(r, g, b));
    }

    @Override
    public void setLabelColor(int r, int g, int b) {
        this.setLabelColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    @Override
    public void setLabelColor(String color) {
        Color cl = ImportUtils.parseColor(color);
        if (cl != null) {
            this.setLabelColor(cl);
        } else {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_LabelColorParse", (Object)color, (Object)this.id);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.WARNING));
        }
    }

    @Override
    public void setValue(String key, Object value) {
        Class type = value.getClass();
        if (AttributeUtils.isDynamicType(type)) {
            type = AttributeUtils.getStaticType(type);
        }
        ColumnDraft column = this.getColumn(key, type);
        try {
            this.setAttributeValue(column, value);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_SetValueError", (Object)value.toString(), (Object)this.id, (Object)ex.getMessage());
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
        }
    }

    @Override
    public void setValue(String key, Object value, String dateTime) {
        this.setValue(key, value, this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(dateTime) : AttributeUtils.parseDateTime((String)dateTime));
    }

    @Override
    public void setValue(String key, Object value, double timestamp) {
        ColumnDraft column = this.getColumn(key, value.getClass());
        try {
            this.setAttributeValue(column, value, timestamp);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_SetValueTimestampError", (Object)value.toString(), (Object)this.id, (Object)timestamp, (Object)ex.getMessage(), (Object[])new Object[0]);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
        }
    }

    @Override
    public void setValue(String key, Object value, String startDateTime, String endDateTime) {
        double start;
        if (startDateTime == null || startDateTime.isEmpty() || "-inf".equalsIgnoreCase(startDateTime) || "-infinity".equalsIgnoreCase(startDateTime)) {
            start = Double.NEGATIVE_INFINITY;
        } else {
            double d = start = this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(startDateTime) : AttributeUtils.parseDateTime((String)startDateTime);
        }
        double end = endDateTime == null || endDateTime.isEmpty() || "inf".equalsIgnoreCase(endDateTime) || "infinity".equalsIgnoreCase(endDateTime) ? Double.POSITIVE_INFINITY : (this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(endDateTime) : AttributeUtils.parseDateTime((String)endDateTime));
        this.setValue(key, value, start, end);
    }

    @Override
    public void setValue(String key, Object value, double start, double end) {
        ColumnDraft column = this.getColumn(key, value.getClass());
        try {
            this.setAttributeValue(column, value, start, end);
        }
        catch (Exception ex) {
            String interval = "[" + start + "," + end + "]";
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_SetValueIntervalError", (Object)value.toString(), (Object)this.id, (Object)interval, (Object)ex.getMessage(), (Object[])new Object[0]);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
        }
    }

    @Override
    public void parseAndSetValue(String key, String value) {
        Class typeClass;
        ColumnDraft column = this.getColumn(key);
        if (column.isDynamic()) {
            if (this.container.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
                if (this.container.getInterval() != null) {
                    this.parseAndSetValue(key, value, this.container.getInterval().getLow(), this.container.getInterval().getHigh());
                    return;
                }
                typeClass = AttributeUtils.getIntervalMapType((Class)column.getTypeClass());
            } else {
                if (this.container.getTimestamp() != null) {
                    this.parseAndSetValue(key, value, this.container.getTimestamp());
                    return;
                }
                typeClass = AttributeUtils.getTimestampMapType((Class)column.getTypeClass());
            }
        } else {
            typeClass = column.getTypeClass();
        }
        Object val = AttributeUtils.parse((String)value, (Class)typeClass);
        this.setValue(key, val);
    }

    @Override
    public void parseAndSetValue(String key, String value, String dateTime) {
        this.parseAndSetValue(key, value, this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(dateTime) : AttributeUtils.parseDateTime((String)dateTime));
    }

    @Override
    public void parseAndSetValue(String key, String value, double timestamp) {
        ColumnDraft column = this.getColumn(key);
        Object val = AttributeUtils.parse((String)value, (Class)column.getTypeClass());
        this.setValue(key, val, timestamp);
    }

    @Override
    public void parseAndSetValue(String key, String value, String startDateTime, String endDateTime) {
        double start;
        if (startDateTime == null || startDateTime.isEmpty() || "-inf".equalsIgnoreCase(startDateTime) || "-infinity".equalsIgnoreCase(startDateTime)) {
            start = Double.NEGATIVE_INFINITY;
        } else {
            double d = start = this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(startDateTime) : AttributeUtils.parseDateTime((String)startDateTime);
        }
        double end = endDateTime == null || endDateTime.isEmpty() || "inf".equalsIgnoreCase(endDateTime) || "infinity".equalsIgnoreCase(endDateTime) ? Double.POSITIVE_INFINITY : (this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(endDateTime) : AttributeUtils.parseDateTime((String)endDateTime));
        this.parseAndSetValue(key, value, start, end);
    }

    @Override
    public void parseAndSetValue(String key, String value, double start, double end) {
        ColumnDraft column = this.getColumn(key);
        Object val = AttributeUtils.parse((String)value, (Class)column.getTypeClass());
        this.setValue(key, val, start, end);
    }

    @Override
    public void addTimestamp(String dateTime) {
        this.addTimestamp(this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(dateTime) : AttributeUtils.parseDateTime((String)dateTime));
    }

    @Override
    public void addTimestamp(double timestamp) {
        if (!this.container.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_NotTimestampRepresentation", (Object)this.id);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        if (this.timeSet == null) {
            this.timeSet = new TimestampSet();
        }
        this.timeSet.add((Object)timestamp);
    }

    @Override
    public void addTimestamps(String timestamps) {
        if (!this.container.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_NotTimestampRepresentation", (Object)this.id);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        TimestampSet t = (TimestampSet)AttributeUtils.parse((String)timestamps, TimestampSet.class);
        if (this.timeSet == null) {
            this.timeSet = t;
        } else {
            for (Double d : t.toArray()) {
                this.timeSet.add((Object)d);
            }
        }
    }

    @Override
    public TimeSet getTimeSet() {
        return this.timeSet;
    }

    @Override
    public void addInterval(String intervalStartDateTime, String intervalEndDateTime) {
        double start;
        if (intervalStartDateTime == null || intervalStartDateTime.isEmpty() || "-inf".equalsIgnoreCase(intervalStartDateTime) || "-infinity".equalsIgnoreCase(intervalStartDateTime)) {
            start = Double.NEGATIVE_INFINITY;
        } else {
            double d = start = this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(intervalStartDateTime) : AttributeUtils.parseDateTime((String)intervalStartDateTime);
        }
        double end = intervalEndDateTime == null || intervalEndDateTime.isEmpty() || "inf".equalsIgnoreCase(intervalEndDateTime) || "infinity".equalsIgnoreCase(intervalEndDateTime) ? Double.POSITIVE_INFINITY : (this.container.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(intervalEndDateTime) : AttributeUtils.parseDateTime((String)intervalEndDateTime));
        this.addInterval(start, end);
    }

    @Override
    public void addIntervals(String intervals) {
        if (!this.container.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_NotIntervalRepresentation", (Object)this.id);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        IntervalSet s = (IntervalSet)AttributeUtils.parse((String)intervals, IntervalSet.class);
        if (this.timeSet == null) {
            this.timeSet = s;
        } else {
            for (Interval i : s.toArray()) {
                this.timeSet.add((Object)i);
            }
        }
    }

    @Override
    public void addInterval(double intervalStart, double intervalEnd) {
        if (!this.container.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_NotIntervalRepresentation", (Object)this.id);
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        try {
            Interval interval = new Interval(intervalStart, intervalEnd);
            if (this.timeSet == null) {
                this.timeSet = new IntervalSet();
            }
            this.timeSet.add((Object)interval);
        }
        catch (Exception e) {
            String interval = "[" + intervalStart + "," + intervalEnd + "]";
            String message = NbBundle.getMessage(ElementDraftImpl.class, (String)"ElementDraftException_IntervalSetError", (Object)interval, (Object)this.id, (Object)e.getMessage());
            this.container.getReport().logIssue(new Issue(message, Issue.Level.SEVERE));
        }
    }

    public boolean isDynamic() {
        return this.timeSet != null && !this.timeSet.isEmpty();
    }

    public boolean hasDynamicAttributes() {
        for (Object att : this.attributes) {
            if (att == null || !(att instanceof TimeMap) || ((TimeMap)att).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected void setAttributeValue(ColumnDraft column, Object value) throws Exception {
        int index = ((ColumnDraftImpl)column).getIndex();
        value = AttributeUtils.standardizeValue((Object)value);
        Class typeClass = column.getTypeClass();
        if (column.isDynamic()) {
            typeClass = this.container.getTimeRepresentation() == TimeRepresentation.INTERVAL ? AttributeUtils.getIntervalMapType((Class)typeClass) : AttributeUtils.getTimestampMapType((Class)typeClass);
        }
        if (!value.getClass().equals(typeClass)) {
            throw new RuntimeException("The expected value class was " + typeClass.getSimpleName() + " and " + value.getClass().getSimpleName() + " was found");
        }
        if (index >= this.attributes.length) {
            Object[] newArray = new Object[index + 1];
            System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
            this.attributes = newArray;
        }
        this.attributes[index] = value;
    }

    protected void setAttributeValue(ColumnDraft column, Object value, double timestamp) throws Exception {
        TimestampMap m;
        int index = ((ColumnDraftImpl)column).getIndex();
        Class typeClass = column.getTypeClass();
        if (!(value = AttributeUtils.standardizeValue((Object)value)).getClass().equals(typeClass)) {
            throw new RuntimeException("The expected value class was " + typeClass.getSimpleName() + " and " + value.getClass().getSimpleName() + " was found");
        }
        if (!column.isDynamic()) {
            throw new RuntimeException("Can't set a dynamic value to a static column");
        }
        if (index >= this.attributes.length) {
            Object[] newArray = new Object[index + 1];
            System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
            this.attributes = newArray;
        }
        if ((m = (TimestampMap)this.attributes[index]) == null) {
            m = (TimestampMap)AttributeUtils.getTimestampMapType((Class)column.getTypeClass()).newInstance();
            this.attributes[index] = m;
        }
        m.put(Double.valueOf(timestamp), value);
    }

    protected void setAttributeValue(ColumnDraft column, Object value, double start, double end) throws Exception {
        IntervalMap m;
        int index = ((ColumnDraftImpl)column).getIndex();
        value = AttributeUtils.standardizeValue((Object)value);
        Class typeClass = column.getTypeClass();
        if (!value.getClass().equals(typeClass)) {
            throw new RuntimeException("The expected value class was " + typeClass.getSimpleName() + " and " + value.getClass().getSimpleName() + " was found");
        }
        if (!column.isDynamic()) {
            throw new RuntimeException("Can't set a dynamic value to a static column");
        }
        Interval interval = new Interval(start, end);
        if (index >= this.attributes.length) {
            Object[] newArray = new Object[index + 1];
            System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
            this.attributes = newArray;
        }
        if ((m = (IntervalMap)this.attributes[index]) == null) {
            m = (IntervalMap)AttributeUtils.getIntervalMapType((Class)column.getTypeClass()).newInstance();
            this.attributes[index] = m;
        }
        m.put(interval, value);
    }

    protected Object getAttributeValue(int index) {
        if (index < this.attributes.length) {
            return this.attributes[index];
        }
        return null;
    }
}

