/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin.partition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicListUI;
import org.gephi.appearance.api.Partition;
import org.gephi.filters.plugin.partition.PartitionBuilder;
import org.openide.util.NbBundle;

public class PartitionPanel
extends JPanel {
    private PartitionBuilder.PartitionFilter filter;
    private JPopupMenu popupMenu;
    private JScrollPane jScrollPane1;
    private JList list;

    public PartitionPanel() {
        this.initComponents();
        this.setMinimumSize(new Dimension(50, 90));
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                PartWrapper pw = (PartWrapper)value;
                if (pw.isEnabled()) {
                    label.setEnabled(true);
                    label.setIcon(pw.icon);
                } else {
                    label.setEnabled(false);
                    label.setDisabledIcon(pw.disabledIcon);
                }
                label.setFont(label.getFont().deriveFont(10.0f));
                label.setIconTextGap(6);
                this.setOpaque(false);
                this.setForeground(list.getForeground());
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                return label;
            }
        };
        this.list.setCellRenderer(renderer);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int index = PartitionPanel.this.list.locationToIndex(e.getPoint());
                    if (index == -1) {
                        return;
                    }
                    PartWrapper pw = (PartWrapper)PartitionPanel.this.list.getModel().getElementAt(index);
                    boolean set = !pw.isEnabled();
                    pw.setEnabled(set);
                    if (set) {
                        PartitionPanel.this.filter.addPart(pw.getPart());
                    } else {
                        PartitionPanel.this.filter.removePart(pw.getPart());
                    }
                    PartitionPanel.this.list.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (PartitionPanel.this.filter != null && e.isPopupTrigger()) {
                    PartitionPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PartitionPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        this.createPopup();
    }

    public void setup(PartitionBuilder.PartitionFilter filter) {
        this.filter = filter;
        Partition partition = filter.getPartition();
        if (partition != null) {
            this.refresh(partition, filter.getParts());
        }
    }

    private void refresh(Partition partition, Set<Object> currentParts) {
        DefaultListModel<PartWrapper> model = new DefaultListModel<PartWrapper>();
        int i = 0;
        for (Object p : partition.getSortedValues()) {
            PartWrapper pw = new PartWrapper(p, partition.percentage(p), partition.getColor(p));
            pw.setEnabled(currentParts.contains(p));
            model.add(i++, pw);
        }
        this.list.setModel(model);
    }

    private void createPopup() {
        this.popupMenu = new JPopupMenu();
        JMenuItem refreshItem = new JMenuItem(NbBundle.getMessage(PartitionPanel.class, (String)"PartitionPanel.action.refresh"));
        refreshItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionPanel.this.setup(PartitionPanel.this.filter);
            }
        });
        this.popupMenu.add(refreshItem);
        JMenuItem selectItem = new JMenuItem(NbBundle.getMessage(PartitionPanel.class, (String)"PartitionPanel.action.selectall"));
        selectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionPanel.this.filter.selectAll();
                PartitionPanel.this.refresh(PartitionPanel.this.filter.getPartition(), new HashSet(PartitionPanel.this.filter.getParts()));
            }
        });
        this.popupMenu.add(selectItem);
        JMenuItem unselectItem = new JMenuItem(NbBundle.getMessage(PartitionPanel.class, (String)"PartitionPanel.action.unselectall"));
        unselectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionPanel.this.filter.unselectAll();
                PartitionPanel.this.refresh(PartitionPanel.this.filter.getPartition(), new HashSet());
            }
        });
        this.popupMenu.add(unselectItem);
    }

    public static void computeListSize(JList list) {
        if (list.getUI() instanceof BasicListUI) {
            BasicListUI ui = (BasicListUI)list.getUI();
            try {
                Method method = BasicListUI.class.getDeclaredMethod("updateLayoutState", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)ui, new Object[0]);
                list.revalidate();
                list.repaint();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.list.setSelectionMode(0);
        this.list.setOpaque(false);
        this.jScrollPane1.setViewportView(this.list);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private static class PaletteIcon
    implements Icon {
        private final int COLOR_WIDTH;
        private final int COLOR_HEIGHT;
        private final Color BORDER_COLOR;
        private final Color color;

        public PaletteIcon(Color color) {
            this.color = color;
            this.BORDER_COLOR = new Color(0x444444);
            this.COLOR_WIDTH = 11;
            this.COLOR_HEIGHT = 11;
        }

        public PaletteIcon() {
            this.color = new Color(0xDDDDDD);
            this.BORDER_COLOR = new Color(0x999999);
            this.COLOR_WIDTH = 11;
            this.COLOR_HEIGHT = 11;
        }

        @Override
        public int getIconWidth() {
            return this.COLOR_WIDTH;
        }

        @Override
        public int getIconHeight() {
            return this.COLOR_HEIGHT + 2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x + 2, y, this.COLOR_WIDTH, this.COLOR_HEIGHT);
            g.setColor(this.BORDER_COLOR);
            g.drawRect(x + 2, y, this.COLOR_WIDTH, this.COLOR_HEIGHT);
        }
    }

    private static class PartWrapper {
        private final Object part;
        private final float percentage;
        private final PaletteIcon icon;
        private final PaletteIcon disabledIcon;
        private boolean enabled = false;
        private static final NumberFormat FORMATTER = NumberFormat.getPercentInstance();

        public PartWrapper(Object part, float percentage, Color color) {
            this.part = part;
            this.percentage = percentage;
            this.icon = new PaletteIcon(color);
            this.disabledIcon = new PaletteIcon();
            FORMATTER.setMaximumFractionDigits(2);
        }

        public PaletteIcon getIcon() {
            return this.icon;
        }

        public Object getPart() {
            return this.part;
        }

        public String toString() {
            String percentageStr = FORMATTER.format(this.percentage / 100.0f);
            return this.part.toString() + " (" + percentageStr + ")";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

