/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.ManagedRenderer;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.presets.DefaultPreset;
import org.gephi.preview.spi.MouseResponsiveRenderer;
import org.gephi.preview.spi.PreviewMouseListener;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.gephi.preview.types.DependantOriginalColor;
import org.gephi.preview.types.EdgeColor;
import org.gephi.preview.types.editors.BasicDependantColorPropertyEditor;
import org.gephi.preview.types.editors.BasicDependantOriginalColorPropertyEditor;
import org.gephi.preview.types.editors.BasicEdgeColorPropertyEditor;
import org.gephi.project.api.Workspace;
import org.gephi.utils.Serialization;
import org.openide.util.Lookup;

public class PreviewModelImpl
implements PreviewModel {
    private final PreviewController previewController;
    private final Workspace workspace;
    private final Map<String, List<Item>> typeMap;
    private final Map<Object, Object> sourceMap;
    private ManagedRenderer[] managedRenderers;
    private PreviewMouseListener[] enabledMouseListeners;
    private PreviewProperties properties;

    public PreviewModelImpl(Workspace workspace) {
        this(workspace, null);
    }

    public PreviewModelImpl(Workspace workspace, PreviewController previewController) {
        this.previewController = previewController != null ? previewController : (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        this.typeMap = new HashMap<String, List<Item>>();
        this.sourceMap = new HashMap<Object, Object>();
        this.workspace = workspace;
        this.initBasicPropertyEditors();
        this.initManagedRenderers();
        this.prepareManagedListeners();
    }

    private void initBasicPropertyEditors() {
        if (PropertyEditorManager.findEditor(DependantColor.class) == null) {
            PropertyEditorManager.registerEditor(DependantColor.class, BasicDependantColorPropertyEditor.class);
        }
        if (PropertyEditorManager.findEditor(DependantOriginalColor.class) == null) {
            PropertyEditorManager.registerEditor(DependantOriginalColor.class, BasicDependantOriginalColorPropertyEditor.class);
        }
        if (PropertyEditorManager.findEditor(EdgeColor.class) == null) {
            PropertyEditorManager.registerEditor(EdgeColor.class, BasicEdgeColorPropertyEditor.class);
        }
    }

    private void initManagedRenderers() {
        Renderer[] registeredRenderers = this.previewController.getRegisteredRenderers();
        HashSet<String> replacedRenderers = new HashSet<String>();
        this.managedRenderers = new ManagedRenderer[registeredRenderers.length];
        for (int i = 0; i < registeredRenderers.length; ++i) {
            Renderer r = registeredRenderers[i];
            Class<?> superClass = r.getClass().getSuperclass();
            if (superClass != null && superClass.getName().startsWith("org.gephi.preview.plugin.renderers.")) {
                this.managedRenderers[i] = new ManagedRenderer(r, !replacedRenderers.contains(superClass.getName()));
                replacedRenderers.add(superClass.getName());
                continue;
            }
            this.managedRenderers[i] = new ManagedRenderer(r, true);
        }
    }

    private void prepareManagedListeners() {
        ArrayList<PreviewMouseListener> listeners = new ArrayList<PreviewMouseListener>();
        for (PreviewMouseListener listener : Lookup.getDefault().lookupAll(PreviewMouseListener.class)) {
            for (Renderer renderer : this.getManagedEnabledRenderers()) {
                if (!(renderer instanceof MouseResponsiveRenderer) || !((MouseResponsiveRenderer)((Object)renderer)).needsPreviewMouseListener(listener) || listeners.contains(listener)) continue;
                listeners.add(listener);
            }
        }
        Collections.reverse(listeners);
        this.enabledMouseListeners = listeners.toArray(new PreviewMouseListener[0]);
    }

    private synchronized void initProperties() {
        if (this.properties == null) {
            this.properties = new PreviewProperties();
            for (Renderer renderer : this.getManagedEnabledRenderers()) {
                PreviewProperty[] props;
                for (PreviewProperty p : props = renderer.getProperties()) {
                    this.properties.addProperty(p);
                }
            }
            this.properties.applyPreset(new DefaultPreset());
            this.properties.putValue("visibility-ratio", Float.valueOf(1.0f));
        }
    }

    @Override
    public PreviewProperties getProperties() {
        this.initProperties();
        return this.properties;
    }

    @Override
    public Item[] getItems(String type) {
        List<Item> list = this.typeMap.get(type);
        if (list != null) {
            return list.toArray(new Item[0]);
        }
        return new Item[0];
    }

    @Override
    public Item getItem(String type, Object source) {
        Item[] items;
        for (Item item : items = this.getItems(source)) {
            if (!item.getType().equals(type)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Item[] getItems(Object source) {
        Object value = this.sourceMap.get(source);
        if (value instanceof List) {
            return ((List)value).toArray(new Item[0]);
        }
        if (value instanceof Item) {
            return new Item[]{(Item)value};
        }
        return new Item[0];
    }

    public String[] getItemTypes() {
        return this.typeMap.keySet().toArray(new String[0]);
    }

    public void loadItems(String type, Item[] items) {
        List<Item> typeList = this.typeMap.get(type);
        if (typeList == null) {
            typeList = new ArrayList<Item>(items.length);
            typeList.addAll(Arrays.asList(items));
            this.typeMap.put(type, typeList);
            for (Item item : items) {
                Object value = this.sourceMap.get(item.getSource());
                if (value == null) {
                    this.sourceMap.put(item.getSource(), item);
                    continue;
                }
                if (!(value instanceof List)) continue;
                ((List)value).add(item);
            }
        } else {
            block1: for (Item item : items) {
                Object value = this.sourceMap.get(item.getSource());
                if (value == null) {
                    typeList.add(item);
                    this.sourceMap.put(item.getSource(), item);
                    continue;
                }
                if (value instanceof Item && ((Item)value).getType().equals(item.getType())) {
                    this.mergeItems(item, (Item)value);
                    continue;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                for (Item itemSameSource : list) {
                    if (!itemSameSource.getType().equals(item.getType())) continue;
                    this.mergeItems(item, itemSameSource);
                    continue block1;
                }
            }
        }
    }

    private Item mergeItems(Item item, Item toBeMerged) {
        for (String key : toBeMerged.getKeys()) {
            item.setData(key, toBeMerged.getData(key));
        }
        return item;
    }

    public void clear() {
        this.typeMap.clear();
        this.sourceMap.clear();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public CanvasSize getGraphicsCanvasSize() {
        float x1 = Float.MAX_VALUE;
        float y1 = Float.MAX_VALUE;
        float x2 = Float.MIN_VALUE;
        float y2 = Float.MIN_VALUE;
        for (Renderer r : this.getManagedEnabledRenderers()) {
            for (String type : this.getItemTypes()) {
                for (Item item : this.getItems(type)) {
                    if (!r.isRendererForitem(item, this.getProperties())) continue;
                    CanvasSize cs = r.getCanvasSize(item, this.getProperties());
                    x1 = Math.min(x1, cs.getX());
                    y1 = Math.min(y1, cs.getY());
                    x2 = Math.max(x2, cs.getMaxX());
                    y2 = Math.max(y2, cs.getMaxY());
                }
            }
        }
        return new CanvasSize(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public ManagedRenderer[] getManagedRenderers() {
        return this.managedRenderers;
    }

    private void completeManagedRenderersListIfNecessary() {
        if (this.managedRenderers != null) {
            HashSet<String> existing = new HashSet<String>();
            for (ManagedRenderer mr : this.managedRenderers) {
                existing.add(mr.getRenderer().getClass().getName());
            }
            ArrayList<ManagedRenderer> completeManagedRenderersList = new ArrayList<ManagedRenderer>();
            completeManagedRenderersList.addAll(Arrays.asList(this.managedRenderers));
            for (Renderer renderer : this.previewController.getRegisteredRenderers()) {
                if (existing.contains(renderer.getClass().getName())) continue;
                completeManagedRenderersList.add(new ManagedRenderer(renderer, false));
            }
            this.managedRenderers = completeManagedRenderersList.toArray(new ManagedRenderer[0]);
        }
    }

    private void reloadProperties() {
        if (this.properties == null) {
            this.initProperties();
        } else {
            PreviewProperties newProperties = new PreviewProperties();
            for (Renderer renderer : this.getManagedEnabledRenderers()) {
                PreviewProperty[] props;
                for (PreviewProperty p : props = renderer.getProperties()) {
                    newProperties.addProperty(p);
                    if (!this.properties.hasProperty(p.getName())) continue;
                    newProperties.putValue(p.getName(), this.properties.getValue(p.getName()));
                }
            }
            for (PreviewProperty p : this.properties.getProperties()) {
                this.properties.removeProperty(p);
            }
            for (PreviewProperty property : newProperties.getProperties()) {
                this.properties.addProperty(property);
            }
        }
    }

    @Override
    public void setManagedRenderers(ManagedRenderer[] managedRenderers) {
        for (ManagedRenderer managedRenderer : managedRenderers) {
            if (managedRenderer != null) continue;
            throw new IllegalArgumentException("managedRenderers should not contain null values");
        }
        this.managedRenderers = managedRenderers;
        this.completeManagedRenderersListIfNecessary();
        this.prepareManagedListeners();
        this.reloadProperties();
    }

    @Override
    public Renderer[] getManagedEnabledRenderers() {
        if (this.managedRenderers != null) {
            ArrayList<Renderer> renderers = new ArrayList<Renderer>();
            for (ManagedRenderer mr : this.managedRenderers) {
                if (!mr.isEnabled()) continue;
                renderers.add(mr.getRenderer());
            }
            return renderers.toArray(new Renderer[0]);
        }
        return null;
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        this.initProperties();
        for (PreviewProperty property : this.properties.getProperties()) {
            String text;
            String propertyName = property.getName();
            Object propertyValue = property.getValue();
            if (propertyValue == null || (text = Serialization.getValueAsText(propertyValue)) == null) continue;
            writer.writeStartElement("previewproperty");
            writer.writeAttribute("name", propertyName);
            writer.writeCharacters(text);
            writer.writeEndElement();
        }
        for (Map.Entry<String, Object> simpleValueEntry : this.properties.getSimpleValues()) {
            Object value;
            if (simpleValueEntry.getKey().equals("width") || simpleValueEntry.getKey().equals("height") || (value = simpleValueEntry.getValue()) == null) continue;
            Class<?> clazz = value.getClass();
            String text = Serialization.getValueAsText((Object)value);
            if (text == null) continue;
            writer.writeStartElement("previewsimplevalue");
            writer.writeAttribute("name", simpleValueEntry.getKey());
            writer.writeAttribute("class", clazz.getName());
            writer.writeCharacters(text);
            writer.writeEndElement();
        }
        if (this.managedRenderers != null) {
            for (ManagedRenderer managedRenderer : this.managedRenderers) {
                writer.writeStartElement("managedrenderer");
                writer.writeAttribute("class", managedRenderer.getRenderer().getClass().getName());
                writer.writeAttribute("enabled", String.valueOf(managedRenderer.isEnabled()));
                writer.writeEndElement();
            }
        }
    }

    public void readXML(XMLStreamReader reader) throws XMLStreamException {
        PreviewProperties props = this.getProperties();
        String propName = null;
        boolean isSimpleValue = false;
        String simpleValueClass = null;
        ArrayList<ManagedRenderer> managedRenderersList = new ArrayList<ManagedRenderer>();
        HashMap<String, Renderer> availableRenderers = new HashMap<String, Renderer>();
        for (Renderer renderer : Lookup.getDefault().lookupAll(Renderer.class)) {
            availableRenderers.put(renderer.getClass().getName(), renderer);
            Class<?> superClass = renderer.getClass().getSuperclass();
            if (superClass == null || !superClass.getName().startsWith("org.gephi.preview.plugin.renderers.")) continue;
            availableRenderers.put(superClass.getName(), renderer);
        }
        boolean end = false;
        block6: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if ("previewproperty".equalsIgnoreCase(name)) {
                        propName = reader.getAttributeValue(null, "name");
                        isSimpleValue = false;
                        break;
                    }
                    if ("previewsimplevalue".equalsIgnoreCase(name)) {
                        propName = reader.getAttributeValue(null, "name");
                        simpleValueClass = reader.getAttributeValue(null, "class");
                        isSimpleValue = true;
                        break;
                    }
                    if (!"managedrenderer".equalsIgnoreCase(name)) break;
                    String rendererClass = reader.getAttributeValue(null, "class");
                    if (!availableRenderers.containsKey(rendererClass)) continue block6;
                    managedRenderersList.add(new ManagedRenderer((Renderer)availableRenderers.get(rendererClass), Boolean.parseBoolean(reader.getAttributeValue(null, "enabled"))));
                    break;
                }
                case 4: {
                    if (reader.isWhiteSpace() || propName == null) break;
                    if (!isSimpleValue) {
                        Object value;
                        PreviewProperty p = props.getProperty(propName);
                        if (p == null || (value = Serialization.readValueFromText((String)reader.getText(), (Class)p.getType())) == null) continue block6;
                        p.setValue(value);
                        break;
                    }
                    if (simpleValueClass == null || propName.equals("width") || propName.equals("height")) break;
                    Object value = Serialization.readValueFromText((String)reader.getText(), (String)simpleValueClass);
                    if (value == null) continue block6;
                    props.putValue(propName, value);
                    break;
                }
                case 2: {
                    if ("previewmodel".equalsIgnoreCase(reader.getLocalName())) {
                        end = true;
                    }
                    propName = null;
                }
            }
        }
        if (!managedRenderersList.isEmpty()) {
            this.setManagedRenderers(managedRenderersList.toArray(new ManagedRenderer[0]));
        }
    }

    @Override
    public PreviewMouseListener[] getEnabledMouseListeners() {
        return this.enabledMouseListeners;
    }
}

