/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.gephi.preview.AbstractRenderTarget;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.spi.RenderTargetBuilder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SVGRenderTargetBuilder
implements RenderTargetBuilder {
    @Override
    public RenderTarget buildRenderTarget(PreviewModel previewModel) {
        CanvasSize cs = previewModel.getGraphicsCanvasSize();
        boolean scaleStrokes = previewModel.getProperties().getBooleanValue("svg.scale.strokes");
        SVGRenderTargetImpl renderTarget = new SVGRenderTargetImpl(cs, scaleStrokes);
        return renderTarget;
    }

    @Override
    public String getName() {
        return "svg";
    }

    public static enum LengthUnit {
        CENTIMETER,
        MILLIMETER,
        INCH,
        PIXELS,
        PERCENTAGE;


        public String toString() {
            switch (this) {
                case CENTIMETER: {
                    return "cm";
                }
                case MILLIMETER: {
                    return "mm";
                }
                case INCH: {
                    return "in";
                }
                case PIXELS: {
                    return "px";
                }
            }
            return "%";
        }
    }

    public static class SupportSize {
        private final float width;
        private final float height;
        private final LengthUnit lengthUnit;

        public SupportSize(float width, float height, LengthUnit lengthUnit) {
            this.width = width;
            this.height = height;
            this.lengthUnit = lengthUnit;
        }

        public float getWidthFloat() {
            return this.width;
        }

        public float getHeightFloat() {
            return this.height;
        }

        public String getWidth() {
            return this.width + this.lengthUnit.toString();
        }

        public String getHeight() {
            return this.height + this.lengthUnit.toString();
        }
    }

    public static class SVGRenderTargetImpl
    extends AbstractRenderTarget
    implements SVGTarget {
        private final Document document;
        private float scaleRatio = 1.0f;
        private final Map<String, Element> topElements = new HashMap<String, Element>();

        public SVGRenderTargetImpl(CanvasSize cs, boolean scaleStrokes) {
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            DocumentType doctype = impl.createDocumentType("-//W3C//DTD SVG 1.1//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", "");
            this.document = impl.createDocument("http://www.w3.org/2000/svg", "svg", doctype);
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            ctx.setDynamicState(2);
            GVTBuilder builder = new GVTBuilder();
            builder.build(ctx, this.document);
            SupportSize ss = new SupportSize(595.0f, 841.0f, LengthUnit.PIXELS);
            if (cs.getWidth() > cs.getHeight()) {
                ss = new SupportSize(cs.getWidth() * ss.getHeightFloat() / cs.getHeight(), ss.getHeightFloat(), LengthUnit.PIXELS);
            } else if (cs.getHeight() > cs.getWidth()) {
                ss = new SupportSize(ss.getWidthFloat(), cs.getHeight() * ss.getWidthFloat() / cs.getWidth(), LengthUnit.PIXELS);
            }
            Element svgRoot = this.document.getDocumentElement();
            svgRoot.setAttributeNS(null, "width", cs.getWidth() + "");
            svgRoot.setAttributeNS(null, "height", cs.getHeight() + "");
            svgRoot.setAttributeNS(null, "version", "1.1");
            svgRoot.setAttributeNS(null, "viewBox", String.format(Locale.ENGLISH, "%f %f %f %f", Float.valueOf(cs.getX()), Float.valueOf(cs.getY()), Float.valueOf(cs.getWidth()), Float.valueOf(cs.getHeight())));
            if (scaleStrokes) {
                this.scaleRatio = ss.getWidthFloat() / cs.getWidth();
            }
        }

        @Override
        public Element getTopElement(String name) {
            Element topElement = this.topElements.get(name);
            if (topElement == null) {
                topElement = this.createElement("g");
                topElement.setAttribute("id", name);
                this.topElements.put(name, topElement);
                this.document.getDocumentElement().appendChild(topElement);
            }
            return topElement;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public float getScaleRatio() {
            return this.scaleRatio;
        }

        @Override
        public Element createElement(String qualifiedName) {
            return this.document.createElementNS("http://www.w3.org/2000/svg", qualifiedName);
        }

        @Override
        public Text createTextNode(String data) {
            return this.document.createTextNode(data);
        }

        @Override
        public String toHexString(Color color) {
            int i;
            String str = Integer.toHexString(color.getRGB());
            for (i = str.length(); i > 6; --i) {
                str = str.substring(1);
            }
            for (i = str.length(); i < 6; ++i) {
                str = "0" + str;
            }
            return "#" + str;
        }
    }
}

