/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import java.util.HashSet;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.openide.util.NbBundle;

public class DiffusionMethods {
    public static Node[] getNeighbors(Graph graph, Node[] nodes) {
        graph.readLock();
        HashSet nodeTree = new HashSet();
        for (Node n : nodes) {
            nodeTree.addAll(graph.getNeighbors(n).toCollection());
        }
        graph.readUnlock();
        for (Node n : nodes) {
            nodeTree.remove(n);
        }
        return nodeTree.toArray(new Node[0]);
    }

    public static Node[] getNeighborsOfNeighbors(Graph graph, Node[] nodes) {
        graph.readLock();
        HashSet nodeTree = new HashSet();
        for (Node n : nodes) {
            nodeTree.addAll(graph.getNeighbors(n).toCollection());
        }
        for (Node n : nodes) {
            nodeTree.remove(n);
        }
        for (Node n : nodeTree.toArray(new Node[0])) {
            nodeTree.addAll(graph.getNeighbors(n).toCollection());
        }
        graph.readUnlock();
        for (Node n : nodes) {
            nodeTree.remove(n);
        }
        return nodeTree.toArray(new Node[0]);
    }

    public static Node[] getPredecessors(DirectedGraph graph, Node[] nodes) {
        graph.readLock();
        HashSet nodeTree = new HashSet();
        for (Node n : nodes) {
            nodeTree.addAll(graph.getPredecessors(n).toCollection());
        }
        graph.readUnlock();
        for (Node n : nodes) {
            nodeTree.remove(n);
        }
        return nodeTree.toArray(new Node[0]);
    }

    public static Node[] getSuccessors(DirectedGraph graph, Node[] nodes) {
        graph.readLock();
        HashSet nodeTree = new HashSet();
        for (Node n : nodes) {
            nodeTree.addAll(graph.getSuccessors(n).toCollection());
        }
        graph.readUnlock();
        for (Node n : nodes) {
            nodeTree.remove(n);
        }
        return nodeTree.toArray(new Node[0]);
    }

    public static enum DiffusionMethod {
        NONE("DiffusionMethod.None"),
        NEIGHBORS("DiffusionMethod.Neighbors"),
        NEIGHBORS_OF_NEIGHBORS("DiffusionMethod.NeighborsOfNeighbors"),
        PREDECESSORS("DiffusionMethod.Predecessors"),
        SUCCESSORS("DiffusionMethod.Successors");

        private final String name;

        private DiffusionMethod(String name) {
            this.name = name;
        }

        public String getName() {
            return NbBundle.getMessage(DiffusionMethods.class, (String)this.name);
        }

        public String toString() {
            return this.getName();
        }
    }
}

