/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.Point;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import org.gephi.timeline.api.TimelineChart;
import org.gephi.timeline.api.TimelineModel;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TimelineTooltip {
    private static final int DELAY = 500;
    private TimelineModel model;
    private String position;
    private String min;
    private String max;
    private String y;
    private Timer timer;
    private RichTooltip tooltip;
    private Lock lock = new ReentrantLock();

    public void setModel(TimelineModel model) {
        this.model = model;
    }

    public void start(final double currentPosition, final Point mousePosition, final JComponent component) {
        this.stop();
        if (this.model == null) {
            return;
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimelineTooltip.this.lock.lock();
                try {
                    if (TimelineTooltip.this.tooltip != null) {
                        TimelineTooltip.this.tooltip.hideTooltip();
                    }
                    TimelineTooltip.this.buildData(currentPosition);
                    TimelineTooltip.this.tooltip = TimelineTooltip.this.buildTooltip();
                    TimelineTooltip.this.tooltip.showTooltip(component, mousePosition);
                }
                finally {
                    TimelineTooltip.this.lock.unlock();
                }
            }
        }, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.lock.lock();
        try {
            if (this.tooltip != null) {
                this.tooltip.hideTooltip();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.timer = null;
        this.tooltip = null;
    }

    private void buildData(double currentPosition) {
        TimelineChart chart;
        Number yNumber;
        switch (this.model.getTimeFormat()) {
            case DOUBLE: {
                int exponentMin = (int)Math.round(Math.log10(this.model.getCustomMin()));
                DecimalFormat decimalFormat = new DecimalFormat();
                decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
                if (exponentMin > 0) {
                    this.min = String.valueOf(this.model.getCustomMin());
                    this.max = String.valueOf(this.model.getCustomMax());
                    this.position = String.valueOf(currentPosition);
                    break;
                }
                decimalFormat.setMaximumFractionDigits(Math.abs(exponentMin) + 2);
                this.min = decimalFormat.format(this.model.getCustomMin());
                this.max = decimalFormat.format(this.model.getCustomMax());
                this.position = decimalFormat.format(currentPosition);
                break;
            }
            case DATE: {
                DateTime minDate = new DateTime((long)this.model.getCustomMin());
                DateTime maxDate = new DateTime((long)this.model.getCustomMax());
                DateTime posDate = new DateTime((long)currentPosition);
                DateTimeFormatter formatter = ISODateTimeFormat.date();
                this.min = formatter.print((ReadableInstant)minDate);
                this.max = formatter.print((ReadableInstant)maxDate);
                this.position = formatter.print((ReadableInstant)posDate);
                break;
            }
            default: {
                DateTime minDate = new DateTime((long)this.model.getCustomMin());
                DateTime maxDate = new DateTime((long)this.model.getCustomMax());
                DateTime posDate = new DateTime((long)currentPosition);
                DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
                this.min = formatter.print((ReadableInstant)minDate);
                this.max = formatter.print((ReadableInstant)maxDate);
                this.position = formatter.print((ReadableInstant)posDate);
                break;
            }
        }
        this.y = this.model.getChart() != null ? ((yNumber = (chart = this.model.getChart()).getY((Number)currentPosition)) != null ? yNumber.toString() : null) : null;
    }

    private RichTooltip buildTooltip() {
        RichTooltip richTooltip = new RichTooltip();
        richTooltip.addDescriptionSection(NbBundle.getMessage(TimelineTooltip.class, (String)"TimelineTooltip.min") + ": " + this.getMin());
        richTooltip.addDescriptionSection(NbBundle.getMessage(TimelineTooltip.class, (String)"TimelineTooltip.max") + ": " + this.getMax());
        richTooltip.setTitle(NbBundle.getMessage(TimelineTooltip.class, (String)"TimelineTooltip.position") + ": " + this.getPosition());
        richTooltip.setMainImage(ImageUtilities.loadImage((String)"org/gephi/desktop/timeline/resources/info.png"));
        if (this.getY() != null) {
            richTooltip.addFooterSection(this.model.getChart().getColumn());
            richTooltip.addFooterSection(NbBundle.getMessage(TimelineTooltip.class, (String)"TimelineTooltip.chart") + ": " + this.getY());
            richTooltip.setFooterImage(ImageUtilities.loadImage((String)"org/gephi/desktop/timeline/resources/chart.png"));
        }
        return richTooltip;
    }

    public String getY() {
        return this.y;
    }

    public String getPosition() {
        return this.position;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }
}

