/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.timeline.CustomBoundsDialog;
import org.gephi.desktop.timeline.PlaySettingsDialog;
import org.gephi.desktop.timeline.TimeFormatDialog;
import org.gephi.desktop.timeline.TimelineDrawer;
import org.gephi.timeline.api.TimelineController;
import org.gephi.timeline.api.TimelineModel;
import org.gephi.timeline.api.TimelineModelEvent;
import org.gephi.timeline.api.TimelineModelListener;
import org.gephi.ui.components.CloseButton;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.VizController;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class TimelineTopComponent
extends JPanel
implements TimelineModelListener {
    private transient TimelineDrawer drawer;
    private transient TimelineModel model;
    private transient TimelineController controller;
    private JButton closeButton;
    private JButton columnsButton;
    private JPanel containerPanel;
    private JPanel controlPanel;
    private JButton disableButon;
    private JPanel disabledTimeline;
    private JLabel disabledTimelineLabel;
    private JPanel enablePanel;
    private JButton enableTimelineButton;
    private JPanel innerPanel;
    private JToolBar innerToolbar;
    private JToggleButton playButton;
    private JButton settingsButton;
    private transient JPanel timelinePanel;
    private JToolBar toolbarEnable;

    public TimelineTopComponent() {
        this.initComponents();
        if (UIUtils.isAquaLookAndFeel()) {
            this.containerPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.enablePanel.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.disabledTimeline.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.controlPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.innerPanel.setBackground(UIManager.getColor("NbTabControl.editorTabBackground"));
        }
        this.drawer = (TimelineDrawer)this.timelinePanel;
        this.setName(NbBundle.getMessage(TimelineTopComponent.class, (String)"CTL_TimelineTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.controller = (TimelineController)Lookup.getDefault().lookup(TimelineController.class);
        this.controller.addListener((TimelineModelListener)this);
        this.setup(this.controller.getModel());
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimelineTopComponent.this.controller.setEnabled(false);
                TimelineTopComponent.this.setTimeLineVisible(false);
            }
        });
        this.disableButon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimelineTopComponent.this.controller.setEnabled(false);
            }
        });
        this.enableTimelineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimelineTopComponent.this.model != null) {
                    TimelineTopComponent.this.controller.setEnabled(true);
                }
            }
        });
        this.columnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] columns;
                JPopupMenu menu = new JPopupMenu();
                String selectedColumn = TimelineTopComponent.this.model.getChart() != null ? TimelineTopComponent.this.model.getChart().getColumn() : null;
                for (final String col : columns = TimelineTopComponent.this.controller.getDynamicGraphColumns()) {
                    boolean selected = col == null ? selectedColumn == null : col.equals(selectedColumn);
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(col, selected);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TimelineTopComponent.this.controller.selectColumn(col);
                        }
                    });
                    menu.add(item);
                }
                if (columns.length == 0) {
                    menu.add("<html><i>" + NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.charts.empty") + "</i></html>");
                }
                menu.add(new JSeparator());
                if (columns.length > 0) {
                    JMenuItem disableItem = new JMenuItem(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.charts.disable"));
                    disableItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TimelineTopComponent.this.controller.selectColumn(null);
                        }
                    });
                    menu.add(disableItem);
                    if (selectedColumn == null) {
                        disableItem.setEnabled(false);
                    }
                }
                menu.show(TimelineTopComponent.this.columnsButton, 0, -menu.getPreferredSize().height);
            }
        });
        this.settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                Image customBoundsIcon = ImageUtilities.loadImage((String)"org/gephi/desktop/timeline/resources/custom_bounds.png", (boolean)false);
                JMenuItem customBoundsItem = new JMenuItem(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.settings.setCustomBounds"), ImageUtilities.image2Icon((Image)customBoundsIcon));
                customBoundsItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomBoundsDialog d = new CustomBoundsDialog();
                        d.setup(TimelineTopComponent.this.model);
                        ValidationPanel validationPanel = CustomBoundsDialog.createValidationPanel(d);
                        String title = NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.title");
                        final DialogDescriptor descriptor = new DialogDescriptor((Object)validationPanel, title);
                        validationPanel.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent e) {
                                descriptor.setValid(!((ValidationPanel)e.getSource()).isProblem());
                            }
                        });
                        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                        if (result == NotifyDescriptor.OK_OPTION) {
                            d.unsetup();
                        }
                    }
                });
                menu.add(customBoundsItem);
                Image animationIcon = ImageUtilities.loadImage((String)"org/gephi/desktop/timeline/resources/animation_settings.png", (boolean)false);
                JMenuItem animationItem = new JMenuItem(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.settings.setPlaySettings"), ImageUtilities.image2Icon((Image)animationIcon));
                animationItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlaySettingsDialog d = new PlaySettingsDialog();
                        d.setup(TimelineTopComponent.this.model);
                        String title = NbBundle.getMessage(CustomBoundsDialog.class, (String)"PlaySettingsDialog.title");
                        DialogDescriptor descriptor = new DialogDescriptor((Object)d, title);
                        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                        if (result == NotifyDescriptor.OK_OPTION) {
                            d.unsetup();
                        }
                    }
                });
                menu.add(animationItem);
                Image dateFormatIcon = ImageUtilities.loadImage((String)"org/gephi/desktop/timeline/resources/time_format_small.png", (boolean)false);
                JMenuItem dateFormatItem = new JMenuItem(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.settings.setTimeFormat"), ImageUtilities.image2Icon((Image)dateFormatIcon));
                dateFormatItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeFormatDialog d = new TimeFormatDialog();
                        d.setup(TimelineTopComponent.this.model);
                        String title = NbBundle.getMessage(TimeFormatDialog.class, (String)"TimeFormatDialog.title");
                        DialogDescriptor descriptor = new DialogDescriptor((Object)d, title);
                        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                        if (result == NotifyDescriptor.OK_OPTION) {
                            d.unsetup();
                        }
                    }
                });
                menu.add(dateFormatItem);
                menu.show(TimelineTopComponent.this.settingsButton, 0, -menu.getPreferredSize().height);
            }
        });
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimelineTopComponent.this.model != null) {
                    if (TimelineTopComponent.this.model.isPlaying() && !TimelineTopComponent.this.playButton.isSelected()) {
                        TimelineTopComponent.this.controller.stopPlay();
                    } else if (!TimelineTopComponent.this.model.isPlaying() && TimelineTopComponent.this.playButton.isSelected()) {
                        TimelineTopComponent.this.controller.startPlay();
                    }
                }
            }
        });
    }

    private void setup(TimelineModel model) {
        this.model = model;
        if (model != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineTopComponent.this.drawer.setModel(TimelineTopComponent.this.model);
                    TimelineTopComponent.this.enableTimeline(TimelineTopComponent.this.model);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineTopComponent.this.drawer.setModel(TimelineTopComponent.this.model);
                    TimelineTopComponent.this.enableTimeline(null);
                }
            });
        }
    }

    public void timelineModelChanged(TimelineModelEvent event) {
        if (event.getEventType().equals((Object)TimelineModelEvent.EventType.MODEL)) {
            this.setup(event.getSource());
        } else if (event.getEventType().equals((Object)TimelineModelEvent.EventType.ENABLED)) {
            this.enableTimeline(event.getSource());
        } else if (event.getEventType().equals((Object)TimelineModelEvent.EventType.VALID_BOUNDS)) {
            this.enableTimeline(event.getSource());
        } else if (event.getEventType().equals((Object)TimelineModelEvent.EventType.PLAY_START)) {
            this.setPlaying(true);
        } else if (event.getEventType().equals((Object)TimelineModelEvent.EventType.PLAY_STOP)) {
            this.setPlaying(false);
        }
        this.drawer.consumeEvent(event);
    }

    private void enableTimeline(TimelineModel model) {
        CardLayout cardLayout = (CardLayout)this.containerPanel.getLayout();
        if (model == null) {
            cardLayout.show(this.containerPanel, "top");
            this.enableTimelineButton.setEnabled(false);
            this.setTimeLineVisible(false);
        } else if (!model.hasValidBounds()) {
            cardLayout.show(this.containerPanel, "disabled");
        } else if (model.isEnabled()) {
            cardLayout.show(this.containerPanel, "bottom");
            this.setTimeLineVisible(true);
        } else {
            cardLayout.show(this.containerPanel, "top");
            this.enableTimelineButton.setEnabled(true);
            this.setTimeLineVisible(true);
        }
    }

    private void setPlaying(final boolean playing) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineTopComponent.this.playButton.setSelected(playing);
            }
        });
    }

    public void setTimeLineVisible(final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (visible != TimelineTopComponent.this.isVisible()) {
                    TimelineTopComponent.this.setVisible(visible);
                    VizController.getInstance().getDrawable().reinitWindow();
                }
            }
        });
    }

    private void initComponents() {
        this.containerPanel = new JPanel();
        this.enablePanel = new JPanel();
        this.toolbarEnable = new JToolBar();
        this.enableTimelineButton = new JButton();
        this.disabledTimeline = new JPanel();
        this.disabledTimelineLabel = new JLabel();
        this.innerPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.playButton = new JToggleButton();
        this.innerToolbar = new JToolBar(1);
        this.disableButon = new JButton();
        this.columnsButton = new JButton();
        this.settingsButton = new JButton();
        this.timelinePanel = new TimelineDrawer();
        this.closeButton = new CloseButton();
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 68));
        this.setMinimumSize(new Dimension(414, 68));
        this.setPreferredSize(new Dimension(424, 68));
        this.setLayout(new GridBagLayout());
        this.containerPanel.setLayout(new CardLayout());
        this.enablePanel.setLayout(new GridBagLayout());
        this.toolbarEnable.setFloatable(false);
        this.toolbarEnable.setRollover(true);
        this.toolbarEnable.setOpaque(false);
        this.enableTimelineButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/activate.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.enableTimelineButton, (String)NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.enableTimelineButton.text"));
        this.enableTimelineButton.setToolTipText(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.enableTimelineButton.toolTipText"));
        this.enableTimelineButton.setFocusable(false);
        this.enableTimelineButton.setHorizontalTextPosition(4);
        this.enableTimelineButton.setMargin(new Insets(4, 6, 4, 6));
        this.toolbarEnable.add(this.enableTimelineButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.enablePanel.add((Component)this.toolbarEnable, gridBagConstraints);
        this.containerPanel.add((Component)this.enablePanel, "top");
        this.disabledTimeline.setLayout(new GridBagLayout());
        this.disabledTimelineLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/activate.png")));
        Mnemonics.setLocalizedText((JLabel)this.disabledTimelineLabel, (String)NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.disabledTimelineLabel.text"));
        this.disabledTimelineLabel.setEnabled(false);
        this.disabledTimeline.add((Component)this.disabledTimelineLabel, new GridBagConstraints());
        this.containerPanel.add((Component)this.disabledTimeline, "disabled");
        this.innerPanel.setLayout(new GridBagLayout());
        this.controlPanel.setLayout(new GridBagLayout());
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/disabled.png")));
        this.playButton.setToolTipText(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.playButton.toolTipText"));
        this.playButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/disabled.png")));
        this.playButton.setFocusable(false);
        this.playButton.setHorizontalTextPosition(0);
        this.playButton.setRequestFocusEnabled(false);
        this.playButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/enabled.png")));
        this.playButton.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.playButton, gridBagConstraints);
        this.innerToolbar.setBorder(null);
        this.innerToolbar.setFloatable(false);
        this.innerToolbar.setRollover(true);
        this.innerToolbar.setOpaque(false);
        this.disableButon.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/cross.png")));
        this.disableButon.setToolTipText(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.disableButon.toolTipText"));
        this.disableButon.setFocusable(false);
        this.disableButon.setHorizontalTextPosition(0);
        this.disableButon.setIconTextGap(0);
        this.disableButon.setVerticalTextPosition(3);
        this.innerToolbar.add(this.disableButon);
        this.columnsButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/chart.png")));
        this.columnsButton.setFocusable(false);
        this.columnsButton.setHorizontalTextPosition(0);
        this.columnsButton.setVerticalTextPosition(3);
        this.innerToolbar.add(this.columnsButton);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/timeline/resources/settings.png")));
        this.settingsButton.setFocusable(false);
        this.settingsButton.setHorizontalTextPosition(0);
        this.settingsButton.setIconTextGap(0);
        this.settingsButton.setVerticalTextPosition(3);
        this.innerToolbar.add(this.settingsButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.controlPanel.add((Component)this.innerToolbar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        this.innerPanel.add((Component)this.controlPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.innerPanel.add((Component)this.timelinePanel, gridBagConstraints);
        this.containerPanel.add((Component)this.innerPanel, "bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.containerPanel, gridBagConstraints);
        this.closeButton.setToolTipText(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimelineTopComponent.closeButton.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.closeButton, gridBagConstraints);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

