/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.NbBundle;

public class Degree
implements Statistics,
LongTask {
    public static final String INDEGREE = "indegree";
    public static final String OUTDEGREE = "outdegree";
    public static final String DEGREE = "degree";
    public static final String AVERAGE_DEGREE = "avgdegree";
    private boolean isDirected;
    private boolean isCanceled;
    private ProgressTicket progress;
    private double avgDegree;
    private Map<Integer, Integer> inDegreeDist;
    private Map<Integer, Integer> outDegreeDist;
    private Map<Integer, Integer> degreeDist;

    public double getAverageDegree() {
        return this.avgDegree;
    }

    public void execute(GraphModel graphModel) {
        Graph graph = graphModel.getGraphVisible();
        this.execute(graph);
    }

    public void execute(Graph graph) {
        this.isDirected = graph.isDirected();
        this.isCanceled = false;
        this.initializeDegreeDists();
        this.initializeAttributeColunms(graph.getModel());
        graph.readLock();
        this.avgDegree = this.calculateAverageDegree(graph, this.isDirected, true);
        graph.setAttribute(AVERAGE_DEGREE, (Object)this.avgDegree);
        graph.readUnlockAll();
    }

    protected int calculateInDegree(DirectedGraph directedGraph, Node n) {
        return directedGraph.getInDegree(n);
    }

    protected int calculateOutDegree(DirectedGraph directedGraph, Node n) {
        return directedGraph.getOutDegree(n);
    }

    protected int calculateDegree(Graph graph, Node n) {
        return graph.getDegree(n);
    }

    protected double calculateAverageDegree(Graph graph, boolean isDirected, boolean updateAttributes) {
        double averageDegree = 0.0;
        DirectedGraph directedGraph = null;
        if (isDirected) {
            directedGraph = (DirectedGraph)graph;
        }
        Progress.start((ProgressTicket)this.progress, (int)graph.getNodeCount());
        for (Node n : graph.getNodes()) {
            int inDegree = 0;
            int outDegree = 0;
            int degree = 0;
            if (isDirected) {
                inDegree = this.calculateInDegree(directedGraph, n);
                outDegree = this.calculateOutDegree(directedGraph, n);
            }
            degree = this.calculateDegree(graph, n);
            if (updateAttributes) {
                n.setAttribute(DEGREE, (Object)degree);
                if (isDirected) {
                    n.setAttribute(INDEGREE, (Object)inDegree);
                    n.setAttribute(OUTDEGREE, (Object)outDegree);
                    this.updateDegreeDists(inDegree, outDegree, degree);
                } else {
                    this.updateDegreeDists(degree);
                }
            }
            averageDegree += (double)degree;
            if (this.isCanceled) break;
            Progress.progress((ProgressTicket)this.progress);
        }
        return averageDegree /= (double)graph.getNodeCount();
    }

    private void initializeAttributeColunms(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        if (this.isDirected) {
            if (!nodeTable.hasColumn(INDEGREE)) {
                nodeTable.addColumn(INDEGREE, NbBundle.getMessage(Degree.class, (String)"Degree.nodecolumn.InDegree"), Integer.class, (Object)0);
            }
            if (!nodeTable.hasColumn(OUTDEGREE)) {
                nodeTable.addColumn(OUTDEGREE, NbBundle.getMessage(Degree.class, (String)"Degree.nodecolumn.OutDegree"), Integer.class, (Object)0);
            }
        }
        if (!nodeTable.hasColumn(DEGREE)) {
            nodeTable.addColumn(DEGREE, NbBundle.getMessage(Degree.class, (String)"Degree.nodecolumn.Degree"), Integer.class, (Object)0);
        }
    }

    private void initializeDegreeDists() {
        this.inDegreeDist = new HashMap<Integer, Integer>();
        this.outDegreeDist = new HashMap<Integer, Integer>();
        this.degreeDist = new HashMap<Integer, Integer>();
    }

    private void updateDegreeDists(int inDegree, int outDegree, int degree) {
        if (!this.inDegreeDist.containsKey(inDegree)) {
            this.inDegreeDist.put(inDegree, 0);
        }
        this.inDegreeDist.put(inDegree, this.inDegreeDist.get(inDegree) + 1);
        if (!this.outDegreeDist.containsKey(outDegree)) {
            this.outDegreeDist.put(outDegree, 0);
        }
        this.outDegreeDist.put(outDegree, this.outDegreeDist.get(outDegree) + 1);
        if (!this.degreeDist.containsKey(degree)) {
            this.degreeDist.put(degree, 0);
        }
        this.degreeDist.put(degree, this.degreeDist.get(degree) + 1);
    }

    private void updateDegreeDists(int degree) {
        if (!this.degreeDist.containsKey(degree)) {
            this.degreeDist.put(degree, 0);
        }
        this.degreeDist.put(degree, this.degreeDist.get(degree) + 1);
    }

    public String getReport() {
        String report = "";
        if (this.isDirected) {
            report = this.getDirectedReport();
        } else {
            XYSeries dSeries = ChartUtils.createXYSeries(this.degreeDist, "Degree Distribution");
            XYSeriesCollection dataset1 = new XYSeriesCollection();
            dataset1.addSeries(dSeries);
            JFreeChart chart1 = ChartFactory.createXYLineChart((String)"Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            chart1.removeLegend();
            ChartUtils.decorateChart(chart1);
            ChartUtils.scaleChart(chart1, dSeries, false);
            String degreeImageFile = ChartUtils.renderChart(chart1, "degree-distribution.png");
            DecimalFormat f = new DecimalFormat("#0.000");
            report = "<HTML> <BODY> <h1>Degree Report </h1> <hr><br> <h2> Results: </h2>Average Degree: " + f.format(this.avgDegree) + "<br /><br />" + degreeImageFile + "</BODY></HTML>";
        }
        return report;
    }

    public String getDirectedReport() {
        XYSeries dSeries = ChartUtils.createXYSeries(this.degreeDist, "Degree Distribution");
        XYSeries idSeries = ChartUtils.createXYSeries(this.inDegreeDist, "In-Degree Distribution");
        XYSeries odSeries = ChartUtils.createXYSeries(this.outDegreeDist, "Out-Degree Distribution");
        XYSeriesCollection dataset1 = new XYSeriesCollection();
        dataset1.addSeries(dSeries);
        XYSeriesCollection dataset2 = new XYSeriesCollection();
        dataset2.addSeries(idSeries);
        XYSeriesCollection dataset3 = new XYSeriesCollection();
        dataset3.addSeries(odSeries);
        JFreeChart chart1 = ChartFactory.createXYLineChart((String)"Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart1.removeLegend();
        ChartUtils.decorateChart(chart1);
        ChartUtils.scaleChart(chart1, dSeries, false);
        String degreeImageFile = ChartUtils.renderChart(chart1, "degree-distribution.png");
        JFreeChart chart2 = ChartFactory.createXYLineChart((String)"In-Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset2, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart2.removeLegend();
        ChartUtils.decorateChart(chart2);
        ChartUtils.scaleChart(chart2, dSeries, false);
        String indegreeImageFile = ChartUtils.renderChart(chart2, "indegree-distribution.png");
        JFreeChart chart3 = ChartFactory.createXYLineChart((String)"Out-Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset3, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart3.removeLegend();
        ChartUtils.decorateChart(chart3);
        ChartUtils.scaleChart(chart3, dSeries, false);
        String outdegreeImageFile = ChartUtils.renderChart(chart3, "outdegree-distribution.png");
        DecimalFormat f = new DecimalFormat("#0.000");
        String report = "<HTML> <BODY> <h1>Degree Report </h1> <hr><br> <h2> Results: </h2>Average Degree: " + f.format(this.avgDegree) + "<br /><br />" + degreeImageFile + "<br /><br />" + indegreeImageFile + "<br /><br />" + outdegreeImageFile + "</BODY></HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

