/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.importer;

import java.awt.Component;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.importer.WizardPanel1;
import org.gephi.desktop.importer.WizardPanel2;
import org.gephi.desktop.importer.WizardVisualPanel1;
import org.gephi.io.importer.spi.ImporterWizardUI;
import org.gephi.io.importer.spi.WizardImporter;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;

public class WizardIterator
implements WizardDescriptor.Iterator {
    private int index;
    private WizardDescriptor.Panel[] originalPanels;
    private WizardDescriptor.Panel[] panels;
    private ImporterWizardUI currentWizardUI;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new WizardPanel1(), new WizardPanel2()};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            this.originalPanels = this.panels;
        }
        return this.panels;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel p = this.getPanels()[this.index];
        return p;
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.index == 0) {
            for (ImporterWizardUI wizardUi : Lookup.getDefault().lookupAll(ImporterWizardUI.class)) {
                WizardVisualPanel1 visual1 = (WizardVisualPanel1)this.current().getComponent();
                if (!visual1.getCurrentCategory().equals(wizardUi.getCategory()) || !visual1.getCurrentWizard().equals(wizardUi.getDisplayName())) continue;
                WizardDescriptor.Panel[] wizardPanels = wizardUi.getPanels();
                WizardDescriptor.Panel tempFirstPanel = this.panels[0];
                this.panels = new WizardDescriptor.Panel[wizardPanels.length + 1];
                this.panels[0] = tempFirstPanel;
                for (int i = 0; i < wizardPanels.length; ++i) {
                    this.panels[i + 1] = wizardPanels[i];
                    wizardUi.setup(wizardPanels[i]);
                }
                this.currentWizardUI = wizardUi;
            }
            this.repaintLeftComponent();
        }
        ++this.index;
    }

    private void repaintLeftComponent() {
        String[] steps = new String[this.panels.length];
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        if (this.index == 1) {
            this.panels = this.originalPanels;
            this.repaintLeftComponent();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public ImporterWizardUI getCurrentWizardUI() {
        return this.currentWizardUI;
    }

    void unsetupPanels(WizardImporter importer) {
        for (int i = 1; i < this.panels.length; ++i) {
            this.currentWizardUI.unsetup(importer, this.panels[i]);
        }
    }
}

