/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.importer;

import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gephi.io.importer.spi.ImporterWizardUI;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class WizardVisualPanel1
extends JPanel
implements ChangeListener {
    private final DefaultListModel subTypeModel = new DefaultListModel();
    private JList categoryList;
    private JTextArea descriptionArea;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel labelCategory;
    private JLabel labelDescription;
    private JLabel labelWizard;
    private JList wizardList;

    public WizardVisualPanel1() {
        this.initComponents();
        this.reloadDescription();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(WizardVisualPanel1.class, (String)"WizardVisualPanel1.title");
    }

    private void initComponents() {
        this.labelCategory = new JLabel();
        this.labelWizard = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.categoryList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.wizardList = new JList();
        this.labelDescription = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.setMaximumSize(new Dimension(500, 360));
        this.setPreferredSize(new Dimension(500, 360));
        Mnemonics.setLocalizedText((JLabel)this.labelCategory, (String)NbBundle.getMessage(WizardVisualPanel1.class, (String)"WizardVisualPanel1.labelCategory.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelWizard, (String)NbBundle.getMessage(WizardVisualPanel1.class, (String)"WizardVisualPanel1.labelWizard.text"));
        this.categoryList.setModel(this.getCategoryListModel());
        this.categoryList.setSelectionMode(0);
        this.categoryList.setSelectedIndex(0);
        this.categoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WizardVisualPanel1.this.categoryListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.categoryList);
        this.wizardList.setModel(this.reloadSubType());
        this.wizardList.setSelectionMode(0);
        this.wizardList.setSelectedIndex(0);
        this.wizardList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WizardVisualPanel1.this.wizardListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.wizardList);
        Mnemonics.setLocalizedText((JLabel)this.labelDescription, (String)NbBundle.getMessage(WizardVisualPanel1.class, (String)"WizardVisualPanel1.labelDescription.text"));
        this.descriptionArea.setColumns(20);
        this.descriptionArea.setRows(5);
        this.jScrollPane3.setViewportView(this.descriptionArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelCategory, -2, 107, -2).addComponent(this.jScrollPane1, -2, 199, -2)).addGap(55, 55, 55).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelWizard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE))).addComponent(this.labelDescription)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCategory).addComponent(this.labelWizard)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 207, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 207, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, -1, -2).addContainerGap()));
    }

    private void categoryListValueChanged(ListSelectionEvent evt) {
        this.reloadSubType();
        if (this.wizardList.getSelectedValue() == null) {
            this.descriptionArea.setText("");
        }
        this.wizardList.setSelectedIndex(0);
    }

    private void wizardListValueChanged(ListSelectionEvent evt) {
        this.reloadDescription();
    }

    public String getCurrentCategory() {
        return this.categoryList.getSelectedValue().toString();
    }

    public String getCurrentWizard() {
        return this.wizardList.getSelectedValue().toString();
    }

    private ListModel getCategoryListModel() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (ImporterWizardUI wizardUi : Lookup.getDefault().lookupAll(ImporterWizardUI.class)) {
            if (model.contains(wizardUi.getCategory())) continue;
            model.addElement(wizardUi.getCategory());
        }
        return model;
    }

    private ListModel reloadSubType() {
        this.subTypeModel.clear();
        if (this.categoryList.getSelectedValue() == null) {
            return this.subTypeModel;
        }
        String category = this.categoryList.getSelectedValue().toString();
        for (ImporterWizardUI wizardUi : Lookup.getDefault().lookupAll(ImporterWizardUI.class)) {
            if (!category.equals(wizardUi.getCategory())) continue;
            this.subTypeModel.addElement(wizardUi.getDisplayName());
            this.descriptionArea.setText(wizardUi.getDescription());
        }
        return this.subTypeModel;
    }

    private void reloadDescription() {
        if (this.emptyList()) {
            return;
        }
        String category = this.categoryList.getSelectedValue().toString();
        String wizard = this.wizardList.getSelectedValue().toString();
        for (ImporterWizardUI wizardUi : Lookup.getDefault().lookupAll(ImporterWizardUI.class)) {
            if (!category.equals(wizardUi.getCategory()) || !wizard.equals(wizardUi.getDisplayName())) continue;
            this.descriptionArea.setText(wizardUi.getDescription());
        }
    }

    boolean emptyList() {
        return this.categoryList.getSelectedValue() == null || this.wizardList.getSelectedValue() == null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

